<link href="{{ url('assets/select2/select2.min.css') }}" rel="stylesheet" />

<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">{{ $page_title }}</h5>

            <!-- General Form Elements -->
            <form action="{{ url(ADMIN_URL . 'save-site-menu-settings') }}" method="post" id="edit-form" class="g-3"
                enctype="multipart/form-data">
                @csrf
                <?php if($results['mode'] == 'edit'){ ?>
                <input type="hidden" name="smu_id" value="{{ encrypt($results['results'][0]['smu_id']) }}">
                <?php } ?>

                <input type="hidden" name="mode" value="{{ $results['mode'] }}">

                <div class="row mb-3">
                    <div class="col-sm-4">
                        <input type="text" id="name" class="form-control " placeholder="Menu Name"
                            name="name" value="{{ $results['results'][0]['smu_name'] ?? old('name') }}">
                    </div>
                    <div class="col-sm-4">
                        <input type="text" id="slug" class="form-control " placeholder="Menu Slug"
                            name="slug" value="{{ $results['results'][0]['smu_slug'] ?? old('slug') }}">
                    </div>
                    <div class="col-sm-4">
                        <input type="text" id="icon" class="form-control " placeholder="Menu Icon Class"
                            name="icon" value="{{ $results['results'][0]['smu_icon'] ?? old('icon') }}">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="menu_parents"  name="menu_parents">
                            <option value="">Select parent menu</option>
                            <?php  foreach($results['data']  as $sK => $sV){?>
                                <option value="<?= $sK ?>"
                                    {{ ($results['results'][0]['smu_parent'] ?? old('positions')) == $sK ? 'selected' : '' }}>
                                    <?= $sV ?>
                                </option>
                                <?php }?>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="positions" required="" name="positions">
                            <option value="">Select Menu Postions</option>
                            <?php  foreach(WEBSITE_MENU_POSITIONS as $sK => $sV){?>
                            <option value="<?= $sK ?>"
                                {{ ($results['results'][0]['smu_position'] ?? old('positions')) == $sK ? 'selected' : '' }}>
                                <?= $sV ?>
                            </option>
                            <?php }?>
                        </select>
                    </div>
                    <div class="col-sm-4">
                        <select class="form-select form-control select2" id="status" required="" name="status">
                            <option value="">Select Status</option>
                            <?php  foreach(WEBSITE_STATUS_LABEL as $sK => $sV){?>
                            <option value="<?= $sK ?>"
                                {{ ($results['results'][0]['smu_status'] ?? old('status')) == $sK ? 'selected' : '' }}>
                                <?= $sV ?>
                            </option>
                            <?php }?>
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-8">
                        <input type="text" id="menu-url" class="form-control " placeholder="Menu Url" name="url"
                            value="{{ $results['results'][0]['smu_url'] ?? old('url') }}">
                    </div>
                    <div class="col-sm-2">
                        <input type="number" id="sort-order" class="form-control " placeholder="Sort Order"
                            name="sortorder" value="{{ $results['results'][0]['smu_sort_order'] ?? old('sortorder') }}">
                    </div>
                    <div class="col-sm-2">
                        <label class="form-label" for="target">Page Target</label>
                        <input type="checkbox" id="target" class="form-control " placeholder="Page target"
                            name="target" {{ $results['results'][0]['smu_target'] ?? old('target') ? 'checked' : '' }}>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-sm-10">
                        <button type="submit" class="btn btn-sm btn-primary">Submit</button>
                        <a href="{{ url(ADMIN_URL . 'site-menu-settings') }}"
                            class="btn btn-sm btn-warning text-white">Back</a>
                    </div>
                </div>

            </form><!-- End General Form Elements -->
        </div>
    </div>
</div>

<script src="{{ url('assets/select2/select2.min.js') }}"></script>

<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>
<script>
    $(".select2").select2();


    $(document).ready(function() {

        $('#edit-form').validate({
            rules: {
                name: {
                    required: true,
                },
                slug: {
                    required: true,
                },
                positions: {
                    required: true,
                },
                status: {
                    required: true,
                },
                url: {
                    required: true,
                },
                sortorder: {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: "Site menu name must be required",
                },
                slug: {
                    required: "Site menu slug must be required",
                },
                positions: {
                    required: "Site menu position must be required",
                },
                status: {
                    required: "Site menu Status must be required",
                },
                url: {
                    required: "Site menu url must be required",
                },
                sortorder: {
                    required: "Site menu sort order must be required",
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });


</script>
