<style>
    .header-banner-img {
        background: url("assets/img/video-overlay.jpg");
        background-repeat: no-repeat;
        background-size: cover;
        position: relative;
        padding: 150px 0;
        padding-bottom: 80px;
    }

    .header-banner-img::before {
        background-color: #76b51b63 !important;
        content: '';
        display: block;
        height: 100%;
        position: absolute;
        width: 100%;
        top: 0;
    }

    .header-banner-img.pricing-section .section-heading h2,
    .header-banner-img.pricing-section .section-heading p {
        position: relative;
        z-index: 10;
        color: #fff;
    }
</style>


<!--page header section start-->
<section class="pricing-section header-banner-img">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-9 col-lg-6">
                <div class="section-heading text-center mb-4">
                    <h2>Contact Us</h2>
                    <p> Lorem ipsum dolor sit amet consectetur adipisicing elit. Rerum corporis repellat non,
                        consequuntur delec </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

<!--our contact promo start-->
<section class="promo-section pt-60 ">
    <div class="container">
        <div class="row justify-content-md-center justify-content-sm-center">
            <div class="col-md-6 col-lg-4">
                <div class="card single-promo-card text-center p-3 my-3">
                    <div class="card-body">
                        <div class="pb-2">
                            <span class="fas fa-envelope icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="pt-2 pb-3">
                            <h5>Mail Us</h5>
                            <p class="mb-0">Say something to start a live chat hello@yourdomain.com</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card single-promo-card text-center p-3 my-3">
                    <div class="card-body">
                        <div class="pb-2">
                            <span class="fas fa-headset icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="pt-2 pb-3">
                            <h5>24/7 Live Chat</h5>
                            <p class="mb-0">We endeavour to answer all enquiries within 24 hours on business days.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card single-promo-card text-center p-3 my-3">
                    <div class="card-body">
                        <div class="pb-2">
                            <span class="fas fa-map-marker-alt icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="pt-2 pb-3">
                            <h5>Visit Us</h5>
                            <p class="mb-0">xyzlocation.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--our contact promo end-->

<!--our contact section start-->
<section class="contact-us-section ptb-60" id="contact">
    <div class="container">
        <div class="row">
            <div class="col-12 pb-3 message-box">

                <?php
                if (Session::has('message')) {
                    [$type, $message] = explode('|', Session::get('message'));
                    $type = $type == 'error' ? 'danger' : 'success';
                    echo sprintf('<div class="alert alert-%s alert-dismissible fade show" role="alert">%s <button type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i class="fa fa-times"></i></button></div>', $type, $message);
                }
                ?>
                @foreach ($errors->all() as $error)
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">{{ $error }}
                        <button type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i
                                class="fa fa-times"></i></button></div>
                @endforeach
            </div>
            <div class="col-md-8 col-lg-9">
                <div class="contact-us-form-wrap gray-light-bg position-relative">
                    <form action="{{ url('send-contact-info') }}" method="post" id="contact-us-form"
                        class="contact-us-form">
                        @csrf
                        <div class="form-row">
                            <div class="col-md-9 col-12">
                                <h5 class="mb-3">Send Us a Message</h5>
                            </div>
                            <div class="col-md-9 col-12">
                                <div class="form-group mb-3">
                                    <input type="text" class="form-control" name="name" id="name"
                                        placeholder="Enter name" required="required" />
                                </div>
                            </div>
                            <div class="col-md-9 col-12">
                                <div class="form-group mb-3">
                                    <input type="tel" class="form-control" name="mobile" id="mobile"
                                        placeholder="Enter Mobile Number" required="required" />
                                </div>
                            </div>
                            <div class="col-md-9 col-12">
                                <div class="form-group mb-3">
                                    <input type="email" class="form-control" name="email" id="email"
                                        placeholder="Enter Email Address" required="required" />
                                </div>
                            </div>
                            <div class="col-md-9 col-12">
                                <div class="mb-4">
                                    <textarea name="message" id="message" class="form-control w-100 h-100" rows="5" cols="25"
                                        placeholder="Message" maxlength="500"></textarea>
                                </div>
                            </div>
                            <div class="col-sm-12 mt-3">
                                <button type="submit" class="btn btn-tertiary web_all_button_sizes" id="btnContactUs">
                                    Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="contact-us-content main_secondary_bg text-white shadow-lg mt-5 mt-md-0 mt-lg-0">
                        <h3 class="text-white">
                            Looking for a excellent Business idea?
                        </h3>
                        <p>Drop by anytime, we endeavour to answer all enquiries within 24 hours on business days.
                        </p>
                        <ul class="contact-info-list mt-3">
                            <li class="d-flex py-3">
                                <div class="contact-icon me-3">
                                    <span class="fas fa-location-arrow text-tertiary"></span>
                                </div>
                                <div class="contact-text">
                                    <h6 class="mb-1 text-white font-weight-normal">
                                        Company Location
                                    </h6>
                                    <small> xyz location </small>
                                </div>
                            </li>
                            <li class="d-flex py-3">
                                <div class="contact-icon me-3">
                                    <span class="fas fa-envelope text-tertiary"></span>
                                </div>
                                <div class="contact-text">
                                    <h6 class="mb-1 text-white font-weight-normal">
                                        Email Address
                                    </h6>
                                    <small> hello@yourdomain.com </small>
                                </div>
                            </li>
                        </ul>
                        <ul class="list-inline social-list-default background-color social-hover-2 mt-2">
                            <li class="list-inline-item">
                                <a class="twitter" href="#"><i class="fab fa-twitter"></i></a>
                            </li>
                            <li class="list-inline-item">
                                <a class="youtube" href="#"><i class="fab fa-youtube"></i></a>
                            </li>
                            <li class="list-inline-item">
                                <a class="linkedin" href="#"><i class="fab fa-linkedin-in"></i></a>
                            </li>
                            <li class="list-inline-item">
                                <a class="dribbble" href="#"><i class="fab fa-dribbble"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--our contact section end-->

<!--google map start-->
<div class="google-map">
    <iframe
        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15272182.726027898!2d73.69968851892529!3d20.84945741075149!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x30635ff06b92b791%3A0xd78c4fa1854213a6!2sIndia!5e0!3m2!1sen!2sin!4v1679327798214!5m2!1sen!2sin"
        height="450" style="border:0;" allowfullscreen=""></iframe>
</div>
<!--google map end-->

<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>
<script>
    $(document).ready(function() {
        $('#contact-us-form').validate({
            rules: {
                name: {
                    required: true,
                    minlength: 3,
                    maxlength: 50,
                },
                mobile: {
                    required: true,
                    digits: true,
                    minlength: 6,
                    maxlength: 20,
                },
                email: {
                    required: true,
                    email: true,
                },
                message: {
                    required: true,
                    minlength: 10,
                    maxlength: 500,
                }
            },
            messages: {
                name: {
                    required: "Name must be required",
                    minlength: "Name must be minimum 3 character",
                    maxlength: "Name must be maximum 50 character",
                },
                mobile: {
                    required: "Mobile Number must be required",
                    digits: "Mobile Number must be digits",
                },
                email: {
                    required: "Email Address Must be required",
                    email: "Email Address Must be Valid",
                },
                message: {
                    required: "Message must be required",
                    minlength: "Message must be minimum 10 character",
                    maxlength: "Message must be maximum 500 character",

                }
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });
</script>
