@include('admin.dashboard.left_side_bar')

<!-- Begin Page Content -->
<div class="container-fluid">

    <?php
    if (Session::has('message')) {
        [$type, $message] = explode('|', Session::get('message'));
        $type = $type == 'error' ? 'danger' : 'success';
        echo sprintf('<div class="alert alert-%s alert-dismissible fade show" role="alert">%s <button type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i class="fa fa-times"></i></button></div>', $type, $message);
    }
    ?>
    @foreach ($errors->all() as $error)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">{{ $error }} <button
                type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i class="fa fa-times"></i></button></div>
    @endforeach


    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ $page_title }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Home</a></li>
                <li class="breadcrumb-item active">{{ $page_title }}</li>
            </ol>
        </nav>
    </div>

    <?php
    if (!empty($results)) {
        $results = $results;
    } else {
        $results = [];
    }
    
    if (!empty($page_title)) {
        $page_title = $page_title;
    } else {
        $page_title = '';
    }
    echo view($page, ['page_title' => $page_title, 'results' => $results]);
    
    ?>
</div>
<!-- /.container-fluid -->

@include('admin.dashboard.dashboard_footer')
