<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{ $title }}</title>
    <meta charset="utf-8" />
    <link rel="icon" href="{{ url('assets/img/icon/icon1.png') }}">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta content="ihosting Web Hosting" name="description" />
    <meta content="{{ $meta_keyword }}" name="keywords" />
    <meta content="" name="author" />
    <link id="theme-style" href="{{ url('assets/css/main.css') }}" type="text/css" as="style" rel="stylesheet" />
    <link id="theme-style" href="{{ url('assets/css/animate.css') }}" type="text/css" as="style" rel="stylesheet" />
    <script src="{{ url('assets/js/vendors/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ url('assets/js/vendors/bootstrap.bundle.min.js') }}"></script>

</head>

<body>
    <style>
        .bg-pattern-2 {
            z-index: 1;
            position: relative;
        }

        bg-pattern-2.bg-image2::before {
            opacity: 0.06;
        }

        .bg-pattern-2::before {
            content: "";
            position: absolute;
            inset-block-start: 0;
            inset-inline-start: 0;
            height: 100%;
            width: 100%;
            opacity: 0.4;
            z-index: -1;
        }

        .heading-section {
            text-align: center;
            -webkit-margin-after: 3rem;
            margin-block-end: 3rem;
        }

        .heading-title {
            font-size: 2rem;
            -webkit-margin-after: 0.5rem;
            margin-block-end: 0.5rem;
            color: #fff;
            font-weight: 700;
            line-height: 1.2;
        }

        .heading-description {
            font-size: 1rem;
            -webkit-margin-after: 0;
            margin-block-end: 0;
            opacity: 0.8;
        }

        .feature-card-16 {
            transition: all 350ms ease-in;
            -webkit-padding-after: 0;
            padding-block-end: 0;
            overflow: hidden;
            z-index: 1;
        }

        .feature-card-16::before {
            inset-inline-end: 0;
            inset-block-start: -12%;
        }

        .feature-card-16::before,
        .feature-card-16::after {
            content: "";
            position: absolute;
            inset-inline-end: -8%;
            inset-block-start: 0;
            height: 80px;
            width: 80px;
            border-radius: 50%;
            background-color: #0948b3;
            opacity: 0.05;
            z-index: -1;
        }

        .feature-icon.primary {
            background-color: #0948b3;
        }

        .br-style1 {
            border-start-start-radius: 50%;
            border-start-end-radius: 50%;
            border-end-end-radius: 50%;
            border-end-start-radius: 0;
        }

        .brand-logo {
            height: 70px !important;
        }
    </style>
    <!--preloader start-->
    <div id="preloader">
        <div class="preloader-wrap">
            <div class="preloader">
                <i>.</i>
                <i>.</i>
                <i>.</i>
            </div>
        </div>
    </div>
    <div id="header-top-bar" class="top-bar wow slideInRight main_primary_bg text-center text-light pb-1">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-12 col-lg-12  d-lg-block d-md-block">
                    <ul class="list-unstyled list-inline topbar-nav topbar-nav-left">
                        <li class="list-inline-item text-center top-bar-head-offers">
                            <span>Get your business online with web hosting</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="top-bar gray-light-bg pb-1">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-6 col-lg-5 d-none d-lg-block d-md-block">
                    <ul class="list-unstyled list-inline topbar-nav topbar-nav-left">
                        <li class="list-inline-item">
                            <a class="navbar-brand pt-0" href="{{ url('/') }}">
                                <img src="assets/img/logo-dark.png" class="img img-fluid brand-logo"
                                    alt="I Hosting Mart">
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6 col-lg-7">
                    <ul class="list-unstyled list-inline top-head-bar topbar-nav topbar-nav-right text-lg-end">

                        <li class="list-inline-item">
                            <a href="tel:+123456789">
                                <i class="fas fa-phone me-1"></i> +123456789</a>
                        </li>
                        <li class="list-inline-item">
                            <a href="#">24x7x365 Support</a>
                        </li>
                        <li class="list-inline-item">
                            <select class="form-select mt-1" id="currency_dropdown">
                                <option value="INDIA" data-sysmbol="">
                                    <img src="assets/img/countries/in.png" alt="india"
                                        style=" height: 18px; width: 18px;" />INR
                                </option>
                                <option value="USA" data-sysmbol="">
                                    <img src="assets/img/countries/us.png" alt="europe"
                                        style=" height: 18px; width: 18px;" /> USD
                                </option>
                                <option value="EUROPE" data-sysmbol=""><img src="assets/img/countries/eur.png"
                                        alt="europe"style=" height: 18px; width: 18px;" /> EUR</option>
                            </select>
                        </li>
                        <li class="list-inline-item header-nav-last-item">
                            <a class="btn btn-tertiary animated-btn" href="{{ url('/') }}" target="_blank">
                                <span class="fa fa-user pe-2"></span>
                                Login
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!--preloader end-->
    <!--header section start-->
    <header id="header" class="header-main">
        <!--main header menu start-->
        <div id="logoAndNav" class="main-header-menu-wrap main_secondary_bg fixed-top">
            <div class="container">
                <nav class="js-mega-menu navbar navbar-expand-md header-nav">
                    <!--responsive toggle button start-->
                    <button type="button" class="navbar-toggler btn" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasLeft">
                        <span id="hamburgerTrigger">
                            <span class="fas fa-bars"></span>
                        </span>
                    </button>
                    <!--responsive toggle button end-->

                    <!--main menu start-->
                    <div id="navBar" class="collapse navbar-collapse">
                        <ul class="navbar-nav ms-auto main-navbar-nav">

                            <li class="nav-item hs-has-mega-menu custom-nav-item" data-position="center">
                                <a id="homeMegaMenu" class="nav-link custom-nav-link main-link-toggle"
                                    href="{{ url('/hosting') }}" aria-haspopup="true" aria-expanded="false">
                                    Hosting
                                </a>
                                <!--home mega menu start-->
                                <div class="hs-mega-menu main-sub-menu w-100" aria-labelledby="homeMegaMenu"
                                    style="width:750px !important;">
                                    <div class="row g-0">
                                        <div class="col-lg-5 col-sm-6 col-12 gray-light-bg custom-radius-left">
                                            <div class="menu-item-wrap  p-4">
                                                <h6 class="main_primary_text_color">Shared Web Hosting</h6>
                                                <p>
                                                    Shared Web Hosting packages are highly cost-effective bundled with
                                                    Amazing feature and freebies such as free domain, Fre SSl Same
                                                    renewal pricing, etc. Get started with our world class hosting to
                                                    build your dream website now!
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-lg-7 col-sm-6 col-12 custom-radius-right">
                                            <div class="row no-gutters p-4">
                                                <div class="col-sm-6">
                                                    <span class="sub-menu-title main_primary_text_color">Web Hosting
                                                    </span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-linux me-2"></i>
                                                                Linux Hosting
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-windows me-2"></i>
                                                                Windows Hosting
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-solid fa-cart-shopping"></i>
                                                                e-commerce Hosting
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="col-sm-6">
                                                    <span class="sub-menu-title main_primary_text_color">CMS Hosting
                                                    </span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-wordpress-simple me-2"></i>
                                                                WordPress Hosting
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-magento me-2"></i>
                                                                Megento Hosting
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-drupal me-2"></i>
                                                                Drupal Hosting
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('hosting-details') }}">
                                                                <i class="fa-brands fa-joomla me-2"></i>
                                                                Joomla Hosting
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--home mega menu end-->
                            </li>
                            <!--hosting end-->

                            <!--domain start-->
                            <li class="nav-item hs-has-mega-menu custom-nav-item position-relative"
                                data-position="center">
                                <a id="domainMegaMenu" class="nav-link custom-nav-link main-link-toggle"
                                    href="{{ url('/domains') }}" aria-haspopup="true" aria-expanded="false">
                                    Domain
                                </a>
                                <!-- Demos - Mega Menu -->
                                <div class="hs-mega-menu main-sub-menu" style="width: 330px;"
                                    aria-labelledby="domainMegaMenu">
                                    <div class="row g-0">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="menu-item-wrap p-3">
                                                <!--menu title with subtitle and icon item start-->
                                                <div class="title-with-icon-item">
                                                    <a class="title-with-icon-link" href="{{ url('/domains') }}">
                                                        <div class="d-flex align-items-center pb-1">
                                                            <i class="fas fa-copyright me-2 instagram-color"></i>
                                                            <span class="u-header__promo-title">
                                                                Domain Registration
                                                            </span>
                                                        </div>
                                                        <small class="u-header__promo-text">
                                                            Register your domain name for lifetime
                                                        </small>
                                                    </a>
                                                </div>
                                                <!--menu title with subtitle and icon item end-->
                                                <!--menu title with subtitle and icon item start-->
                                                <div class="title-with-icon-item">
                                                    <a class="title-with-icon-link"
                                                        href="{{ url('/domains-transfer') }}">
                                                        <div class="d-flex align-items-center pb-1">
                                                            <i class="fas fa-exchange-alt me-2 color-accent"></i>
                                                            <span class="u-header__promo-title">
                                                                Domain Transfer
                                                            </span>
                                                        </div>
                                                        <small class="u-header__promo-text">
                                                            Transfer your domain easily
                                                        </small>
                                                    </a>
                                                </div>
                                                <!--menu title with subtitle and icon item end-->

                                                <!--menu title with subtitle and icon item start-->
                                                <div class="title-with-icon-item">
                                                    <a class="title-with-icon-link"
                                                        href="{{ url('/whois-lookup') }}">
                                                        <div class="d-flex align-items-center pb-1">
                                                            <i class="fas fa-globe me-2 color-primary"></i>
                                                            <span class="u-header__promo-title">
                                                                WHOIS Lookup
                                                            </span>
                                                        </div>
                                                        <small class="u-header__promo-text">
                                                            Take a look at a domain's registry record
                                                        </small>
                                                    </a>
                                                </div>
                                                <!--menu title with subtitle and icon item end-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Demos - Mega Menu -->
                            </li>
                            <!--domain end-->

                            <li class="nav-item hs-has-mega-menu custom-nav-item" data-position="center">
                                <a id="homeMegaMenu" class="nav-link custom-nav-link main-link-toggle"
                                    href="javascript:void(0);" aria-haspopup="true" aria-expanded="false">
                                    Emails
                                </a>
                                <!--home mega menu start-->
                                <div class="hs-mega-menu main-sub-menu w-100" aria-labelledby="homeMegaMenu"
                                    style="width:750px !important;">
                                    <div class="row g-0">
                                        <div class="col-lg-5 col-sm-6 col-12 gray-light-bg custom-radius-left">
                                            <div class="menu-item-wrap p-4">
                                                <h6 class="main_primary_text_color">Email & Security</h6>
                                                <p>
                                                    Lorem ipsum dolor sit amet consectetur adipisicing elit. Sunt
                                                    tenetur quibusdam, illum modi
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-lg-7 col-sm-6 col-12 custom-radius-right">
                                            <div class="row no-gutters p-4">
                                                <div class="col-sm-6">
                                                    <span class="sub-menu-title main_primary_text_color">Email </span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('emails') }}">
                                                                <i class="fa-brands fa-linux me-2"></i>
                                                                Business Email
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('emails') }}">
                                                                <i class="fa-brands fa-windows me-2"></i>
                                                                Enterprise Email
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="col-sm-6">
                                                    <span
                                                        class="sub-menu-title main_primary_text_color">Security</span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('securities') }}">
                                                                <i class="fa-brands fa-wordpress-simple me-2"></i>
                                                                SSL Certificates
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('securities') }}">
                                                                <i class="fa-brands fa-drupal me-2"></i>
                                                                SITE Lock
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('securities') }}">
                                                                <i class="fa-brands fa-joomla me-2"></i>
                                                                Code Guard
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--home mega menu end-->
                            </li>

                            <li class="nav-item hs-has-mega-menu custom-nav-item" data-position="center">
                                <a id="homeMegaMenu" class="nav-link custom-nav-link main-link-toggle"
                                    href="javascript:void(0);" aria-haspopup="true" aria-expanded="false">
                                    Website Services
                                </a>
                                <!--home mega menu start-->
                                <div class="hs-mega-menu main-sub-menu w-100" aria-labelledby="homeMegaMenu"
                                    style="width:750px !important;">
                                    <div class="row g-0">
                                        <div class="col-lg-5 col-sm-6 col-12 gray-light-bg custom-radius-left">
                                            <div class="menu-item-wrap p-4">
                                                <h6 class="main_primary_text_color">Website Services</h6>
                                                <p>
                                                    Lorem ipsum dolor sit amet consectetur adipisicing elit. Sunt
                                                    tenetur quibusdam, illum modi
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-lg-7 col-sm-6 col-12 custom-radius-right">
                                            <div class="row no-gutters p-4">
                                                <div class="col-sm-6">
                                                    <span class="sub-menu-title main_primary_text_color">Website Design
                                                    </span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('website-design') }}">
                                                                <i class="fa-brands fa-linux me-2"></i>
                                                                Custom Web Design
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ url('website-builder') }}">
                                                                <i class="fa-brands fa-windows me-2"></i>
                                                                Free Website builder
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="col-sm-6">
                                                    <span class="sub-menu-title main_primary_text_color">SEO
                                                        Services</span>
                                                    <ul class="home-demo-list">
                                                        <li>
                                                            <a href="{{ url('securities') }}">
                                                                <i class="fa-brands fa-wordpress-simple me-2"></i>
                                                                SEO
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--home mega menu end-->
                            </li>

                            <li class="nav-item custom-nav-item">
                                <a class="nav-link custom-nav-link" href="{{ url('/about-us') }}">
                                    About Us
                                </a>
                            </li>

                            <!--button start-->
                            <li class="nav-item custom-nav-item">
                                <a class="nav-link custom-nav-link" href="{{ url('/contact-us') }}">
                                    Contact Us
                                </a>
                            </li>
                            <!--button end-->

                        </ul>
                    </div>
                    <!--main menu end-->
                </nav>
            </div>
        </div>
        <!--main header menu end-->

        <!--offcanvas menu start-->
        <div class="offcanvas offcanvas-start" id="offcanvasLeft" tabindex="-1">
            <div class="offcanvas-header border-bottom">
                <a class="navbar-brand" href="{{ url('/') }}">
                    <img src="assets/img/logo-dark.png" class="img img-fluid brand-logo" alt="Ihosting mart">
                </a>
                <button class="btn-close" type="button" data-bs-dismiss="offcanvas"></button>
            </div>
            <div class="offcanvas-body offcanvas-menu-wrap">
                <!--offcanvas menu list start-->
                <ul class="navbar-nav">
                    <!--home item start-->
                    <li class="nav-item">
                        <a class="nav-link" href="{{ url('/') }}">Home</a>
                    </li>
                    <!--home item end-->

                    <!--hosting item start-->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="{{ url('/hosting') }}" data-bs-toggle="dropdown">
                            Hosting
                        </a>
                        <div class="dropdown-menu p-0">
                            <div class="row g-0">
                                <div class="col-12">
                                    <div class="menu-item-wrap py-0 p-md-3 p-lg-3">
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="#">
                                                <div class="d-flex align-items-center">
                                                    <div class="menu-item-icon pe-3">
                                                        <i class="fas fa-server rounded-circle primary-bg"></i>
                                                    </div>
                                                    <div class="media-body">
                                                        <span class="u-header__promo-title">
                                                            Linux Hosting
                                                        </span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="#">
                                                <div class="d-flex align-items-center">
                                                    <div class="menu-item-icon pe-3">
                                                        <i class="fab fa-windows rounded-circle bg-success"></i>
                                                    </div>
                                                    <div class="media-body">
                                                        <span class="u-header__promo-title">
                                                            Windows Hosting
                                                        </span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="#">
                                                <div class="d-flex align-items-center">
                                                    <div class="menu-item-icon pe-3">
                                                        <i class="fas fa-database rounded-circle dribbble-bg"></i>
                                                    </div>
                                                    <div class="media-body">
                                                        <span class="u-header__promo-title">
                                                            Reseller Hosting Server Hosting
                                                        </span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <!--hosting item end-->

                    <!--domain item start-->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            Domain
                        </a>
                        <div class="dropdown-menu p-0">
                            <div class="row g-0">
                                <div class="">
                                    <div class="menu-item-wrap p-3">
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="{{ url('/domains') }}">
                                                <div class="d-flex align-items-center pb-1">
                                                    <i class="fas fa-globe me-2 color-primary"></i>
                                                    <span class="u-header__promo-title">
                                                        Domain Checker
                                                    </span>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="{{ url('/domains') }}">
                                                <div class="d-flex align-items-center pb-1">
                                                    <i class="fas fa-exchange-alt me-2 color-accent"></i>
                                                    <span class="u-header__promo-title">
                                                        Domain Transfer
                                                    </span>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                        <!--menu title with subtitle and icon item start-->
                                        <div class="title-with-icon-item">
                                            <a class="title-with-icon-link" href="{{ url('/domains') }}">
                                                <div class="d-flex align-items-center pb-1">
                                                    <i class="fas fa-copyright me-2 instagram-color"></i>
                                                    <span class="u-header__promo-title">
                                                        Domain Registration
                                                    </span>
                                                </div>
                                            </a>
                                        </div>
                                        <!--menu title with subtitle and icon item end-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <!--domain item end-->

                    <!--affiliate item start-->
                    <li class="nav-item">
                        <a class="nav-link" href="#">Affiliates</a>
                    </li>
                    <!--affiliate item end-->

                    <li class="nav-item">
                        <a class="nav-link" href="{{ url('/about-us') }}">About Us</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="{{ url('/contact-us') }}">Contact Us</a>
                    </li>

                    <!--button start-->
                    <li class="nav-item header-nav-last-item d-flex align-items-center mt-3">
                        <a class="btn btn-tertiary animated-btn" href="#" target="_blank">
                            <span class="fa fa-user pe-2"></span>
                            Log In
                        </a>
                    </li>
                    <!--button end-->
                </ul>
                <!--offcanvas menu list end-->
            </div>
        </div>
        <!--offcanvas menu end-->
    </header>
    <!--header section end-->
    <div class="main">
