<link rel="stylesheet" href="{{ url('assets/css/flipster.min.css') }}" />
<style>
    .flipster__button--prev {
        left: 0;
        background: #ff531d;
        font-size: 14px;
        padding-left: 15px;
        padding-right: 15px;
        padding-top: 10px;
        padding-bottom: 10px;
        color: #fff;
        border: 1px solid #1dff7e;
        border-radius: 100%;
        opacity: 0.8;

    }

    .flipster__button--next {
        right: 0;
        background: #ff531d;
        font-size: 14px;
        padding-left: 15px;
        padding-right: 15px;
        padding-top: 10px;
        padding-bottom: 10px;
        color: #fff;
        border: 1px solid #1dff7e;
        border-radius: 100%;
        opacity: 0.8;
    }

    .flipster__nav {
        margin: 0;
    }

    .flipster__nav__item--current .flipster__nav__child {
        display: none;
    }

    .flipster__nav__item {
        display: inline-block;
        margin: 0 0.25em;
        background: #ff531d;
        border-radius: 20px;
        color: #fff;
        margin-top: 20px;
        margin-bottom: 0px;
    }

    li.flipster__nav__item.flipster__nav__item--category.flipster__nav__item--current {
        background: #fff;
        border: 1px solid #ff531d;
        color: #ff531d;
    }

    .flipster__nav__item--current>.flipster__nav__link,
    .flipster__nav__link:hover,
    .flipster__nav__link:focus {
        color: #ff531d;
    }

    .email-services-wrapper .em-host-arrow-lg {
        top: -30px;
        left: calc(50% + 10px);
        -webkit-transform: translateX(-50%);
        transform: translateX(-50%)
    }

    .email-service-item .icon-wrapper {
        width: 70px;
        height: 70px;
        position: relative;
        z-index: 1
    }

    .email-service-item .icon-wrapper::before {
        content: "";
        position: absolute;
        left: 10px;
        bottom: -10px;
        width: 50px;
        height: 50px;
        opacity: .6;
        border-radius: 50%;
        -webkit-filter: blur(20px);
        filter: blur(20px);
        z-index: -1
    }

    .g-4,
    .gy-4 {
        --bs-gutter-y: 1.5rem;
    }

    .g-4,
    .gx-4 {
        --bs-gutter-x: 1.5rem;
    }

    .email-service-item .icon-wrapper.bg-light-red {

        font-size: 30px;
        color: #fff;
        background: #ff0766
    }

    .email-service-item .icon-wrapper.bg-light-red::before {
        background: #ff0766
    }

    .email-service-item .icon-wrapper.bg-warning {

        font-size: 30px;
        color: #fff;
        background: #ffc107
    }

    .email-service-item .icon-wrapper.bg-warning::before {

        background: #ffc107
    }

    .email-service-item .icon-wrapper.info-bg {

        font-size: 30px;
        color: #fff;
        background: #09e8e3
    }

    .email-service-item .icon-wrapper.info-bg::before {
        background: #09e8e3
    }

    @media(max-width: 1399.98px) {
        .email-service-item.mt-100 {
            margin-top: 0
        }
    }


    .product_feature_area .nine_title {
        padding-bottom: 20px;
        color: #213e6e;
        text-align: center;
    }

    .n_product_inner {
        overflow: hidden;
    }

    .n_product_inner .n_product_item {
        border: 1px solid #ebebeb;
        padding: 35px 25px 45px 25px;
        position: relative;
        margin-top: 25px;
        -webkit-box-shadow: 5px 8.66px 27px 0 rgba(0, 0, 0, .05);
        box-shadow: 5px 8.66px 27px 0 rgba(0, 0, 0, .05);
    }


    .register {
        background: #f5f7fb;
        margin-top: 3%;
        padding: 3%;
        margin-bottom: 40px;
    }

    .register-right {
        background: #f5f7fb;
    }

    .register .nav-tabs {
        margin-top: 0%;
        border: none;
        background: #ff531d;
        border-radius: 1.5rem;
        width: 20%;
        position: absolute;
    }


    .register .nav-tabs .nav-link.active {
        width: 100%;
        color: #ff531d;
        border: 2px solid #ff531d;
        border-top-left-radius: 1.5rem;
        border-bottom-left-radius: 1.5rem;
    }

    .register .nav-tabs .nav-link {
        padding: 4%;
        height: 100%;
        font-weight: 600;
        color: #fff;
        border-top-right-radius: 1.5rem;
        border-bottom-right-radius: 1.5rem;
    }

    .register-heading {
        text-align: center;
        margin-top: 3%;
        margin-bottom: -15%;
        color: #213e6e;
    }

    .register .register-form {
        padding: 40px;
    }

    .register-form .custom-radio .custom-control-label {
        margin-right: 1rem;
    }

    .register .custom-control-label {
        color: #495057;
        font-size: 16px;
        font-weight: 600;
        margin-left: 1rem;
    }

    .register-form .custom-radio .custom-control-label::before {
        top: 0;
        z-index: 1;
        cursor: pointer;
        width: 20px;
        height: 20px;
        left: -1.8rem;
    }

    .custom-control-label::after {
        position: absolute;
        top: 0.25rem;
        left: -1.5rem;
        display: block;
        width: 1rem;
        height: 1rem;
        content: "";
        background: no-repeat 50%/50% 50%;
    }

    .pricing-feature-list li {
        color: #2d2f31;
        font-size: 16px;
    }
</style>

<section class="ptb-60 dark_fade_green_color  hero-equal-height">
    <div class="container">

        <div class="row align-items-center justify-content-lg-between">
            <div class="col-md-6 col-lg-5">
                <div class="hero-content-wrap text-white position-relative">
                    <h1 class="text-white">Create Your Own Awesome Website!</h1>
                    <p class="lead">Lorem, ipsum dolor sit amet consectetur adipisicing elit. Debitis consectetur
                        aliquam tempore voluptas.</p>
                    <ul class="list-unstyled mb-2">
                        <li class="py-1"><i class="far fa-check-circle text-success pe-2"></i>All the resources of
                            a
                            server only for your website</li>
                        <li class="py-1"><i class="far fa-check-circle text-success pe-2"></i>Easy management and
                            security thanks to our control panel</li>
                        <li class="py-1"><i class="far fa-check-circle text-success pe-2"></i>Quick and proactive
                            solutions thanks to our 24/7 monitoring service</li>
                    </ul>
                    <div class="action-btns mt-4">
                        <a href="#" class="btn btn-tertiary btn-lg web_all_button_sizes ">Get
                            started now </a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6">
                <div class="img-wrap text-lg-end">
                    <img src="assets/img/hero-svg-img-2.svg" alt="email hosting" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
</section>


<section class="email-services gray-light-bg ptb-60 overflow-hidden">
    <div class="container">
        <div class="row pb-60 justify-content-center">
            <div class="col-lg-8">
                <div class="section-title text-center">
                    <h2 class="mb-3 main_secondary_text_color"><span class="main_primary_text_color">Design &
                            Launch</span> Your Dream Website in 3 Simple Steps</h2>
                    <p class="mb-0">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Iste aperiam labore
                        quos. Maiores ea eveniet facilis quia, laboriosam vel illum commodi suscipit sed ex odit
                        exercitationem nobis rerum magni. Nulla! </p>
                </div>
            </div>
        </div>
        <div class="email-services-wrapper mt-60 position-relative zindex-1">
            <div class="row g-4 justify-content-center">
                <div class="col-xl-4 col-md-6 ">
                    <div class="email-service-item text-center">
                        <span
                            class="icon-wrapper d-inline-flex align-items-center justify-content-center rounded-circle bg-light-red">
                            <i class="fa-sharp fa-solid fa-circle-check"></i>
                        </span>
                        <h5 class="mt-4 mb-3">Select Themes</h5>
                        <p class="mb-0">Select your choice of a template that fits your niche </p>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 ">
                    <div class="email-service-item text-center mt-100">
                        <span
                            class="icon-wrapper d-inline-flex align-items-center justify-content-center rounded-circle bg-warning">
                            <i class="fa-solid fa-file-invoice"></i>
                        </span>
                        <h5 class="mt-4 mb-3">Modify</h5>
                        <p class="mb-0">Customize the webpage layout, content, images, video, etc. </p>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 ">
                    <div class="email-service-item text-center">
                        <span
                            class="icon-wrapper d-inline-flex align-items-center justify-content-center rounded-circle info-bg">

                            <i class="fa-solid fa-upload"></i>
                        </span>
                        <h5 class="mt-4 mb-3">Publish</h5>
                        <p class="mb-0">Your website is ready to publish on the Internet.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="pricing-section ptb-60">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12">
                <div class="section-heading text-center mb-5">
                    <h2 class="main_primary_text_color">Managed With <span class="main_secondary_text_color">Website
                            buiders</span></h2>
                    <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Dicta perspiciatis, labore ipsum esse
                        aperiam quos voluptatibus? Itaque neque eaque impedit expedita aspernatur libero corrupti et
                        eligendi praesentium unde, similique deleniti?
                    </p>
                </div>
            </div>
        </div>
        <div class="row g-4 align-items-center justify-content-between">
            <div class="col-12">
                <div class="switch-wrap text-center mb-2">
                    <label class="form-switch">
                        <span class="beforeinput text-success">
                            Monthly
                        </span>
                        <input type="checkbox" id="js-contcheckbox">
                        <span class="switch-icon gray-light-bg"></span>
                        <span class="afterinput">
                            Yearly
                        </span>
                    </label>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-12">
                <div class="card text-center single-pricing-pack">
                    <div class="pt-5">
                        <h5 class="mb-0">Starter</h5>
                        <p>Medium traffic personal sites</p>
                    </div>
                    <div class="card-header py-4 border-0 pricing-header">
                        <div class="price text-center mb-0 monthly-price" style="display: block;">₹ 119<span>mo</span>
                        </div>
                        <div class="price text-center mb-0 yearly-price" style="display: none;">₹ 169<span>/yr</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-4 pricing-feature-list">
                            <li><span>0 <= 5 </span> Templates</li>
                            <li>no contact form addon</li>
                            <li><span> 0 <= </span> 10 Images </li>
                            <li>not recover changes History </li>
                            <li><span>Super Fast</span></li>
                            <li><span>Free</span>Light Weighted</li>
                            <li>99.95% Uptime</li>
                            <li>24/7 Phone Support</li>
                        </ul>
                        <a href="#" class="btn btn-outline-tertiary mb-3 web_all_button_sizes"
                            target="_blank">Purchase now</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-12">
                <div class="card popular-price text-center single-pricing-pack">
                    <div class="pt-5">
                        <h5 class="mb-0">Business <span class="badge main_primary_bg ms-2">Popular</span></h5>
                        <p>High traffic corporate sites</p>
                    </div>
                    <div class="card-header py-4 border-0 pricing-header">
                        <div class="price text-center mb-0 monthly-price text-white" style="display: block;">
                            ₹ 149<span>/mo</span></div>
                        <div class="price text-center mb-0 yearly-price text-white" style="display: none;">
                            ₹ 1159<span>/yr</span></div>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-4 pricing-feature-list">
                            <li><span>
                                    0 <= 15 </span> Templates</li>
                            <li> contact form addon</li>
                            <li><span>
                                    0 <= </span> 50 Images </li>
                            <li> recover changes History </li>
                            <li><span>Super Fast</span></li>
                            <li><span>Free</span>Light Weighted</li>
                            <li>99.95% Uptime</li>
                            <li>24/7 Phone Support</li>
                        </ul>
                        <a href="#" class="btn btn-tertiary mb-3 web_all_button_sizes" target="_blank">Purchase
                            now</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-12">
                <div class="card text-center single-pricing-pack">
                    <div class="pt-5">
                        <h5 class="mb-0">Enterprise</h5>
                        <p>Enterprise content management</p>
                    </div>
                    <div class="card-header py-4 border-0 pricing-header">
                        <div class="price text-center mb-0 monthly-price" style="display: block;">₹
                            169<span>/mo</span>
                        </div>
                        <div class="price text-center mb-0 yearly-price" style="display: none;">₹ 1259<span>/yr</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-4 pricing-feature-list">
                            <li><span> Unlimited </span> Templates</li>
                            <li> contact form addon</li>
                            <li><span> Unlimited </span> Images uploads</li>
                            <li> recover changes History </li>
                            <li><span>Super Fast</span></li>
                            <li><span>Free</span>Light Weighted</li>
                            <li>99.95% Uptime</li>
                            <li>24/7 Phone Support</li>
                        </ul>
                        <a href="#" class="btn btn-outline-tertiary mb-3 web_all_button_sizes"
                            target="_blank">Purchase now</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="cd-plan-table ptb-60 gray-light-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="cd-title text-center">
                    <h2 class="mb-3 main_secondary_text_color">Our Experience Boost Your <span
                            class="main_primary_text_color">Brand & Business</span></h2>
                    <p class="mb-0">Lorem ipsum dolor sit amet consectetur, adipisicing elit. Ducimus, ipsa dolor
                        in, officiis quis cum doloremque ipsam deleniti alias doloribus possimus recusandae! Magni
                        omnis nobis iste officiis! Reprehenderit, praesentium vero.</p>
                </div>
            </div>
        </div>
        <div class="my-flipster">
            <ul>
                <li data-flip-category="Wordpress">
                    <img src="assets/img/blog/1-w.jpg" alt="1">
                </li>
                <li data-flip-category="Wordpress">
                    <img src="assets/img/blog/1.jpg" alt="2">
                </li>
                <li data-flip-category="Dynamic">
                    <img src="assets/img/blog/2.jpg" alt="3">
                </li>
                <li data-flip-category="Static">
                    <img src="assets/img/blog/3.jpg" alt="4">
                </li>
                <li data-flip-category="Dynamic">
                    <img src="assets/img/blog/4.jpg" alt="5">
                </li>
                <li data-flip-category="Dynamic">
                    <img src="assets/img/blog/5.jpg" alt="6">
                </li>
                <li data-flip-category="Dynamic">
                    <img src="assets/img/blog/6.jpg" alt="7">
                </li>
            </ul>
        </div>
    </div>
</section>


<section class="product_feature_area  ptb-60  gray-light-bg " id="feature">
    <div class="container">
        <div class="nine_title center">
            <h2 class="main_secondary_text_color">Our Free <span class="main_primary_text_color">Website
                    Builder</span> Features</h2>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="row n_product_inner">
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>Customize Your Site</h4>
                            <p>Create stunning websites with hundreds of inbuilt templates. You can customize your
                                professionally designed website by adding photos, videos, forms and more.</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>750+ Themes</h4>
                            <p>Don't you have any designing skills? Be cool! Our website builder includes 750+ awesome
                                design templates to customize your needs and create your dream website.
                            </p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>100+ Widgets</h4>
                            <p>To make a website more professional, you have to add some extra features such as slider,
                                Service box etc., apart from design. Our free SitePad includes 100+ widgets to polish
                                your website.
                            </p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>Static Pages</h4>
                            <p>To boost your website performance, SitePad publishes static web pages. It includes HTML,
                                CSS, JS and more to make your website lightweight and load fast.
                            </p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>Easy to Use</h4>
                            <p>No coding skills are required! Create a free website by dragging and dropping. You can
                                customize the website with your fingertips as per your need. Easily create beautiful
                                websites without any technical skill.
                            </p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="n_product_item">
                            <h4>Powerful &amp; Flexible</h4>
                            <p>SitePad uses powerful scripting languages with that you can easily customize your
                                websites. You can customize the entire style and functionality with the flexibility of
                                these add-on features in our website builder.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<div class="container register" id="quote">
    <div class="row">
        <div class="col-12 pb-3 message-box">

            <?php
            if (Session::has('message')) {
                [$type, $message] = explode('|', Session::get('message'));
                $type = $type == 'error' ? 'danger' : 'success';
                echo sprintf('<div class="alert alert-%s alert-dismissible fade show" role="alert">%s <button type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i class="fa fa-times"></i></button></div>', $type, $message);
            }
            ?>
            @foreach ($errors->all() as $error)
                <div class="alert alert-danger alert-dismissible fade show" role="alert">{{ $error }}
                    <button type="button" class="btn btn-sm" data-bs-dismiss="alert" aria-label="Close"><i
                            class="fa fa-times"></i></button>
                </div>
            @endforeach
        </div>
        <div class="col-md-12 register-right">

            <div class="col-md-12 text-center">
                <h3 class="main_secondary_text_color">Get a Quote</h3>
                <p>Tell us your website design requirements</p>
            </div>
            <form action="{{ url('send-packages-info') }}" id="package-enquiry-form" method="POST">
                
                @csrf
                <div class="row register-form ">
                    <div class="row">
                        <div class="col-lg-4 col-md-12">
                            <div class="form-group">
                                <input type="text" name="name" class="form-control" placeholder="Full Name *"
                                    required>
                                <p style="color: #f00"></p>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12">
                            <div class="form-group">
                                <input type="tel" name="mobile" class="form-control"
                                    placeholder="Mobile Number *" required>
                                <p style="color: #f00"></p>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12">
                            <div class="form-group">
                                <input type="email" name="email" class="form-control" placeholder="Email *"
                                    required>
                                <p style="color: #f00"></p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <select class="form-select" id="select" name="budget">
                                    <option value="" class="hidden" selected="" disabled="">Select
                                        Your Budget</option>
                                    <?php foreach(WEBSITE_PACKAGES_ENQUIRY_BUDGETS as $key => $val) { ?>
                                    <option value="{{ $key }}">{{ $val }}</option>
                                    <?php } ?>
                                </select>
                                <p style="color: #f00"></p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="form-group">
                                <select class="form-select" id="pages" name="pages">
                                    <option value="" class="hidden" selected="" disabled="">Select
                                        number of pages</option>
                                    <?php foreach(WEBSITE_PACKAGES_PAGES as $pkey => $pval) { ?>
                                    <option value="{{ $pkey }}">{{ $pval }} Pages</option>
                                    <?php } ?>
                                </select>
                                <p style="color: #f00"></p>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <textarea name="message" placeholder="Share your website requirements/business idea in details*" class="form-control"
                                    cols="4" rows="6" required maxlength="1000"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <h5 class="mt-3">Select Other Requirements<span>*</span>:</h5>
                        <?php foreach(WEBSITE_PACKAGES_REQUIREMENTS as $Rkey => $Rval){ ?>
                        <div class="col-lg-3 col-md-3">
                            <input class="form-check-input packages_requirements" type="checkbox"
                                id="inlineCheckbox_{{ $Rkey }}" name="requirement[]"
                                value="{{ $Rkey }}">
                            <label class="form-check-label"
                                for="inlineCheckbox_{{ $Rkey }}">{{ $Rval }}</label>
                        </div>
                        <?php } ?>
                        <input type="hidden" value="" name="requirements">
                    </div>
                    <div class="action-btns mt-4">
                        <button type="submit" class="btn btn-tertiary form-control web_all_button_sizes">Get a
                            Quote</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<section class="pricing-section pricing-section-description ptb-40 ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12">
                <div class="section-heading text-center mb-4">
                    <h2 class="main_secondary_text_color">The Benefilts of <span
                            class="main_primary_text_color">shared web hosting</span></h2>
                    <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Cumque, exercitationem saepe vero
                        enim sunt, debitis, quisquam eaque necessitatibus voluptatibus laudantium doloremque
                        ratione. Nostrum consequuntur recusandae cumque est quaerat possimus omnis!
                        Lorem ipsum dolor sit amet consectetur adipisicing elit. Amet cum sequi aspernatur nisi
                        fugit. Beatae impedit culpa laudantium? Voluptate iusto ex consectetur perferendis facere
                        dolorum quo enim ducimus voluptatum voluptas.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="feature-section wow fadeInUp ptb-40"
    style="visibility: visible; animation-name: fadeInUp; background: rgb(231, 231, 231);">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-9 col-lg-6">
                <div class="section-heading text-center">
                    <h2 class="main_secondary_text_color">Experiencing using <span
                            class="main_primary_text_color">Shared Web Hosting</span></h2>
                    <p>These features come standard in all of our hosting plans. Dynamically extend
                        imperatives through open-source quickly niche markets.</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 col-lg-3 mt-4">
                <div class="features-box  bg-white shadow-lg p-5 ">
                    <div class="features-box-icon mb-3">
                        <span class="fas fa-gauge icon-size-md main_primary_text_color"></span>
                    </div>
                    <div class="features-box-content">
                        <h5>Up to 20K faster Turbo </h5>
                        <p>Tech veterans, geeks, and nerds are.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3 mt-4">
                <div class="features-box bg-white shadow-lg p-5 ">
                    <div class="features-box-icon mb-3">
                        <span class="fas fa-thumbs-up icon-size-md main_primary_text_color"></span>
                    </div>
                    <div class="features-box-content">
                        <h5>Guru Crew Suppourt</h5>
                        <p>Tech veterans, geeks, and nerds are.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3 mt-4">
                <div class="features-box  bg-white shadow-lg p-5 ">
                    <div class="features-box-icon mb-3">
                        <span class="fas fa-mouse icon-size-md main_primary_text_color"></span>
                    </div>
                    <div class="features-box-content">
                        <h5>Free Account Migration</h5>
                        <p>Tech veterans, geeks, and nerds are.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3 mt-4">
                <div class="features-box  bg-white shadow-lg p-5 ">
                    <div class="features-box-icon mb-3">
                        <span class="fas fa-headset  icon-size-md main_primary_text_color"></span>
                    </div>
                    <div class="features-box-content">
                        <h5>Money Back Guarantee</h5>
                        <p>Tech veterans, geeks, and nerds are.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="appliction-hosting wow fadeInUp  ptb-60 gray-light-bg"
    style="visibility: visible; animation-name: fadeInUp;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12">
                <div class="section-heading text-center mb-5">
                    <h2 class="main_secondary_text_color"><span class="main_primary_text_color">Application
                            Hosting</span> Optimised for <span class="main_primary_text_color">WordPress &amp;
                            more</span></h2>
                    <p>Our web hosting platform has been fully optimised to offer outstanding performance
                        for your web applications, delivering speeds of up to16x faster.</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="application-hosting-wrap">
                    <ul class="app-list">
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/wordpress-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/joomla-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/magento-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/opencart-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/prestashop-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                        <li><a href="#" class="main_secondary_bg text-white"><img
                                    src="assets/img/icons/drupal-icon-white.svg" alt="icon">
                                <span>WordPress</span></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="feature-section ptb-60 gray-light-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12">
                <div class="section-heading text-center mb-5">
                    <h2 class="main_secondary_text_color">All <span class="main_primary_text_color">Shared Hosting
                            Plans</span> Includes</h2>
                    <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Aperiam exercitationem ad quo vitae
                        consectetur fugiat animi </p>
                </div>
            </div>
        </div>
        <div class="row align-items-center justify-content-between">
            <div class="col-md-6 col-lg-6">
                <div class="cta-new-wrap">
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-hard-drive icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">SSD Disk Drives</h5>
                        <p>You can never go wrong with our own top-notch dedicated servers loaded Credibly network
                            leading-edge services vis-a-vis world-class niches. Seamlessly visualize end-to-end
                            web-readiness </p>
                    </div>
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-network-wired icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">100 Mb/s Network</h5>
                        <p>We can guarantee an excellent experience and loading time for your successful
                            Energistically synthesize just in time paradigms after resource-leveling e-business
                            plagiarize cross-unit information</p>
                    </div>
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-lock icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">DDoS Protection</h5>
                        <p>With full root access you will be able to take full control of your server very easy
                            Holisticly repurpose granular models and go forward schemas. Professionally scale
                            magnetic portals before </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6">
                <div class="cta-new-wrap">
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-globe-americas icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">Dedicated IP</h5>
                        <p>One of many premium features is a dedicated IP cheapest VPS hosting plan Authoritatively
                            formulate user-centric sources without emerging best practices. Monotonectally morph an
                            expanded </p>
                    </div>
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-location-pin icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">IPv6 Support</h5>
                        <p>Our VPS hosting plan is fully packed with dedicated IPv6 Internet protocol IP
                            Progressively maximize standardized catalysts for change via diverse initiatives.
                            Monotonectally underwhelm</p>
                    </div>
                    <div class="feature-feature-list py-3">
                        <span class="fas fa-credit-card icon-size-md d-block main_primary_text_color mb-3"></span>
                        <h5 class="mb-2">Money-back Guarantee</h5>
                        <p>If you’re not 100% satisfied with Hostlar, we’ll refund your payment no risk
                            Interactively administrate wireless results via cooperative mindshare. Completely
                            benchmark process-centric sources and high standards</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="container-fluid " style=" background: #e7e7e7">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <img src="assets/img/moneyBackgurantee.svg" class="mx-auto d-block my-4" alt="Money Back Guarantee">
            </div>
            <div class="col-lg-9">
                <h3 class=" mx-auto mt-4 mb-3">100% Satisfaction or 30-day Money Back
                    Guarantee</h3>
                <p class=" mx-auto">
                    Having the opportunity to experience and learn more about your new hosting provider and
                    whatever we have to offer is essential in developing a long-term partnership. If you are
                    not satisfied with us within your first 30 days, we will return your money. But we're
                    confident you'll like being a part of the iHostingMart team.
                </p>
                <div class="d-flex">
                    <a href="" class="btn btn-tertiary px-3 web_all_button_sizes">Try
                        iHostingMart (30 Days Risk-free)</a>
                </div>
            </div>
        </div>
    </div>
</div>

<section id="faq" class="ptb-60 ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12">
                <div class="section-heading text-center mb-5">
                    <h2 class="main_secondary_text_color">Frequently Asked Queries</h2>
                    <p>Efficiently productivate reliable paradigms before ubiquitous models. Continually
                        utilize frictionless expertise whereas tactical relationships. Still have questions?
                        Contact us</p>
                </div>
            </div>
        </div>
        <div class="row align-items-center">
            <div class="col-md-12 col-lg-12">
                <div class="accordion faq-wrap" id="accordionExample">

                    <!-- Item -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">If I
                                have a WordPress site hosted somewhere
                                else, can I move it to host?</button>
                        </h2>
                        <div class="accordion-collapse collapse show" id="collapseOne" aria-labelledby="headingOne"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">Credibly maximize open-source methodologies via
                                sustainable synergy. Dynamically predominate diverse architectures via
                                user-centric technologies. Credibly enable clicks-and-mortar services
                                whereas extensive services. Proactively integrate orthogonal technologies
                                whereas seamless networks. Dynamically transition intermandated communities
                                via premier mindshare.</div>
                        </div>
                    </div>

                    <!-- Item -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false"
                                aria-controls="collapseTwo">What’s the difference
                                between WordPress Hosting and shared Web Hosting?</button>
                        </h2>
                        <div class="accordion-collapse collapse" id="collapseTwo" aria-labelledby="headingTwo"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">Energistically conceptualize visionary results and
                                premier best practices. Enthusiastically innovate leveraged testing
                                procedures rather than progressive experiences. Uniquely incubate
                                bricks-and-clicks potentialities and process-centric "outside the box"
                                thinking. Dramatically recaptiualize magnetic services rather than fully
                                tested products. Appropriately productize innovative convergence before
                                superior niches.</div>
                        </div>
                    </div>

                    <!-- Item -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseThree" aria-expanded="false"
                                aria-controls="collapseThree">How do I know what
                                WordPress Hosting plan is best for me?</button>
                        </h2>
                        <div class="accordion-collapse collapse" id="collapseThree" aria-labelledby="headingThree"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">Compellingly utilize go forward portals with go
                                forward manufactured products. Continually evolve clicks-and-mortar web
                                services and just in time quality vectors. Holisticly envisioneer unique
                                technology whereas equity invested networks. Dynamically target reliable
                                services without multifunctional convergence. Seamlessly visualize
                                resource-leveling vortals after prospective partnerships.</div>
                        </div>
                    </div>

                    <!-- Item -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">Is
                                email included with
                                WordPress Hosting?</button>
                        </h2>
                        <div class="accordion-collapse collapse" id="collapseFour" aria-labelledby="headingFour"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">Professionally integrate optimal initiatives for
                                progressive "outside the box" thinking. Intrinsicly drive real-time synergy
                                with bleeding-edge growth strategies. Synergistically productize
                                mission-critical portals vis-a-vis interactive customer service.
                                Synergistically predominate B2B outsourcing for magnetic synergy.
                                Energistically optimize synergistic expertise whereas premier results.</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="ptb-80 wow fadeInLeft main_secondary_bg" style="visibility: visible; animation-name: fadeInLeft;">
    <div class="container">
        <div class="row align-items-center justify-content-between">
            <div class="col-12 col-lg-12">
                <div class="cta-content-wrap justify-content-center text-center text-white">
                    <h2 class="text-white">
                        Need Help 24/7/365 Expert Hosting Support Our Customers Love
                    </h2>
                    <p>
                        Objectively innovate high compellingly maintain progressively pursue
                        mission-critical information quality imperatives.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="promo-section pt-60  text-center mt-n-150 ">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-lg-4">
                <div class="card hosting-promo border-0 rounded-custom p-4 mt-4 shadow">
                    <div class="card-body">
                        <div class="hosting-promo-icon mb-3 justify-content-between">
                            <span class="fas fa-headset icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="hosting-promo-content">
                            <h5 class="h6">Call Us / WhatsApp</h5>
                            <p>10:00 AM to 10 PM (IST)
                                <br>
                                Touch 24/7
                            </p>
                            <a href="#" target="_blank"
                                class="btn btn-tertiary read-more-link d-inline-flex align-items-center web_all_button_sizes">
                                <span>Order Now</span> <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card hosting-promo border-0 rounded-custom p-4 mt-4 shadow">
                    <div class="card-body">
                        <div class="hosting-promo-icon mb-3 justify-content-between">
                            <span class="fas fa-comments icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="hosting-promo-content">
                            <h5 class="h6">Chat</h5>
                            <p>10:00 AM to 10 PM (IST)
                                <br>
                                Touch 24/7
                            </p>
                            <a href="#" target="_blank"
                                class="btn btn-tertiary read-more-link d-inline-flex align-items-center web_all_button_sizes">
                                <span>Order Now</span> <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card hosting-promo border-0 rounded-custom p-4 mt-4 shadow">
                    <div class="card-body">
                        <div class="hosting-promo-icon mb-3 justify-content-between">
                            <span class="fas fa-ticket icon-size-lg main_primary_text_color"></span>
                        </div>
                        <div class="hosting-promo-content">
                            <h5 class="h6">Ticket Email</h5>
                            <p>10:00 AM to 10 PM (IST)
                                <br>
                                Touch 24/7
                            </p>
                            <a href="#" target="_blank"
                                class="btn btn-tertiary read-more-link d-inline-flex align-items-center web_all_button_sizes">
                                <span>Order Now</span> <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--feature section end-->

<section class="review-section ptb-60 gray-light-bg">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 col-lg-4">
                <div class="section-heading">
                    <h2 class="main_secondary_text_color">Supporting over 100K satisfies business</h2>
                    <p>Uniquely repurpose strategic core competencies with progressive content. Assertively
                        transition ethical imperatives and collaborative manufactured products. </p>
                    <a href="#" target="_blank"
                        class="btn btn-tertiary read-more-link d-inline-flex align-items-center web_all_button_sizes">
                        <span>Read More Testimonials</span> <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                    <a href="#"
                        class="btn btn-tertiary d-inline-flex align-items-center read-more-link web_all_button_sizes">View
                        All Plans <i class="fas fa-arrow-right ms-2"></i></a>
                </div>
            </div>
            <div class="col-md-6 col-lg-8">
                <div
                    class="owl-carousel owl-theme client-testimonial-2 dot-bottom-center custom-dot owl-loaded owl-drag">
                    <div class="owl-stage-outer">
                        <div class="owl-stage"
                            style="transform: translate3d(-2549px, 0px, 0px); transition: all 0.25s ease 0s; width: 5100px;">
                            <div class="owl-item cloned" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Uniquely mesh flexible</h5>
                                            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit.
                                                Error totam rerum natus voluptate ab unde commodi.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-4.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Amazing template</h5>
                                            <p>Distinctively foster maintainable metrics whereas
                                                multidisciplinary process improvements. Objectively
                                                implement strategic niches through.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-2.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Best template for app</h5>
                                            <p>Efficiently innovate customized growth strategies whereas
                                                error-free paradigms. Monotonectally enhance stand-alone
                                                data with prospective innovation.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-1.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Tony Roy</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Efficiently innovate app</h5>
                                            <p>Continually redefine sticky channels whereas extensive
                                                "outside the box" thinking. Rapidiously supply focused
                                                schemas vis-a-vis optimal users.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-3.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item active" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Uniquely mesh flexible</h5>
                                            <p>Phosfluorescently optimize intermandated platforms without
                                                integrated infrastructures. Proactively redefine granular
                                                thinking before.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-4.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item active" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Uniquely mesh flexible</h5>
                                            <p>Phosfluorescently optimize intermandated platforms without
                                                integrated infrastructures. Proactively redefine granular
                                                thinking before.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-1.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="owl-item" style="width: 424.993px;">
                                <div class="item">
                                    <div class="border single-review-wrap bg-white p-4 m-3">
                                        <div class="review-body">
                                            <h5>Holisticly reintermediate</h5>
                                            <p>Collaboratively reintermediate out-of-the-box e-business via
                                                economically sound supply chains. Dynamically target
                                                client-based holistic information.</p>
                                        </div>
                                        <div class="review-author d-flex align-items-center">
                                            <div class="author-avatar">
                                                <img src="assets/img/client-2.jpg" width="64" alt="author"
                                                    class="rounded-circle shadow-sm img-fluid mr-3">
                                                <span>“</span>
                                            </div>
                                            <div class="review-info">
                                                <h6 class="mb-0">Ana Joly</h6>
                                                <span>BizBite</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<script src="{{ url('assets/js/vendors/flipster.min.js') }}"></script>

<script>
    $(function() {
        $('.my-flipster').flipster({
            style: 'flat',
            loop: true,
            fadeIn: 400,
            autoplay: false,
            spacing: -0.35,
            pauseOnHover: true,
            keyboard: false,
            scrollwheel: false,
            touch: true,
            click: true,
            nav: true,
            buttons: true,
        });
    });
</script>


<script src="{{ url('assets/admin/vendor/jquery/jquery.validate.min.js') }}"></script>
<script>
    $(document).ready(function() {
        $('#package-enquiry-form').validate({
            ignore: '',
            rules: {
                name: {
                    required: true,
                    minlength: 3,
                    maxlength: 50,
                },
                mobile: {
                    required: true,
                    digits: true,
                    minlength: 6,
                    maxlength: 20,
                },
                email: {
                    required: true,
                    email: true,
                },
                budget: {
                    required: true,
                },
                pages: {
                    required: true,
                },
                message: {
                    required: true,
                    minlength: 10,
                    maxlength: 1000,
                },
                requirements: {
                    required: function() {
                        if ($('.packages_requirements:checked').length > 0) {
                            return false;
                        } else {
                            return true;
                        }
                    }
                }
            },
            messages: {
                name: {
                    required: "Name must be required",
                    minlength: "Name must be minimum 3 character",
                    maxlength: "Name must be maximum 50 character",
                },
                mobile: {
                    required: "Mobile Number must be required",
                    digits: "Mobile Number must be digits",
                },
                email: {
                    required: "Email Address Must be required",
                    email: "Email Address Must be Valid",
                },
                budget: {
                    required: "Budget Must be required",
                },
                pages: {
                    required: "Pages Must be required",
                },
                message: {
                    required: "Message must be required",
                    minlength: "Message must be minimum 10 character",
                    maxlength: "Message must be maximum 1000 character",
                },
                requirements: {
                    required: "At least one Requirements required",
                }
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });
</script>
