<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\indexController;
use App\Http\Controllers\ajaxController;
use App\Http\Controllers\aboutController;
use App\Http\Controllers\contactusController;
use App\Http\Controllers\domainsController;
use App\Http\Controllers\emailController;
use App\Http\Controllers\hostingController;
use App\Http\Controllers\securityController;
use App\Http\Controllers\websitesController;
use App\Http\Controllers\pageNotFoundController;
use App\http\Controllers\admin\authController as adminAuthorizeController;
use App\http\Controllers\admin\profileController as adminProfileController;
use App\http\Controllers\admin\logoutController as adminLogoutController;
use App\http\Controllers\admin\dashboardController as adminDashboardController;
use App\Http\Controllers\admin\enquariesController as adminEnquariesController;
use App\Http\Controllers\admin\sitemenuController as adminSiteMenuController;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [indexController::class, 'index']);
Route::get('/about-us', [aboutController::class, 'index']);
Route::get('/contact-us', [contactusController::class, 'index']);
Route::get('/hosting', [hostingController::class, 'index']);
Route::get('/hosting-details', [hostingController::class, 'details']);
Route::get('/compare-plans', [hostingController::class, 'comparePlans']);
Route::get('/domains', [domainsController::class, 'index']);
Route::get('/domains-search-results', [domainsController::class, 'details']);
Route::get('/domains-transfer', [domainsController::class, 'transfer']);
Route::get('/whois-lookup', [domainsController::class, 'whoisLookup']);
Route::get('/emails', [emailController::class, 'index']);
Route::get('/securities', [securityController::class, 'index']);
Route::get('/website-design', [websitesController::class, 'index']);
Route::get('/website-builder', [websitesController::class, 'builder']);

//send enquiries information routes request
Route::post('/send-contact-info', [contactusController::class, 'sendDetails']);
Route::post('/send-packages-info', [contactusController::class, 'sendPackageDetails']);
//ajax admin request 
Route::post('/check-admin-mobile-email', [ajaxController::class, 'checkAdminMobileAndEmail']);
Route::post('/check-admin-user-slug', [ajaxController::class, 'checkAdminUserSlug']);

Route::get('/page-not-found', [pageNotFoundController::class, 'index']);

Route::middleware('is_admin_logged')->group(function () {
    Route::prefix('admin')->group(function () {
        Route::get('/login', [adminAuthorizeController::class, 'index']);
        Route::post('/auth', [adminAuthorizeController::class, 'auth']);
        Route::get('/forget-password', [adminAuthorizeController::class, 'forgetPassword']);
        Route::post('/reset-password', [adminAuthorizeController::class, 'resetPassword']);
        Route::post('/change-password', [adminAuthorizeController::class, 'changePassword']);
    });
});

Route::middleware('is_admin')->group(function () {
    Route::prefix('admin')->group(function () {
        Route::get('/', [adminDashboardController::class, 'index']);
        Route::get('/dashboard', [adminDashboardController::class, 'index']);

        Route::get('/site-menu-settings', [adminSiteMenuController::class, 'index']);
        Route::get('/add-site-menu-settings/{id?}', [adminSiteMenuController::class, 'SiteMenu']);
        Route::post('/save-site-menu-settings', [adminSiteMenuController::class, 'saveSiteMenu']);
        Route::get('/view-site-menu-settings/{id}', [adminSiteMenuController::class, 'viewSiteMenu']);
        Route::get('/delete-site-menu-settings/{id}', [adminSiteMenuController::class, 'deleteSiteMenu']);
        Route::get('/restore-site-menu-settings/{id}', [adminSiteMenuController::class, 'restoreSiteMenu']);

        Route::get('/contacts-enquiry', [adminEnquariesController::class, 'index']);
        Route::get('/delete-contacts-enquiry/{id}', [adminEnquariesController::class, 'deleteContactsEnquiries']);
        Route::get('/restore-contacts-enquiry/{id}', [adminEnquariesController::class, 'restoreContactsEnquiries']);
        Route::get('/delete-permanent-contacts-enquiry/{id}', [adminEnquariesController::class, 'deletePermanentContactsEnquiries']);

        Route::get('/packages-enquiry', [adminEnquariesController::class, 'packagesEnquiries']);
        Route::get('/delete-packages-enquiry/{id}', [adminEnquariesController::class, 'deletePackagesEnquiries']);
        Route::get('/restore-packages-enquiry/{id}', [adminEnquariesController::class, 'restorePackagesEnquiries']);
        Route::get('/delete-permanent-packages-enquiry/{id}', [adminEnquariesController::class, 'deletePermanentPackagesEnquiries']);

        Route::get('/admins-list', [adminProfileController::class, 'adminList']);
        Route::get('/profile-details/{id?}', [adminProfileController::class, 'index']);
        Route::post('/save-profile-details', [adminProfileController::class, 'saveProfile']);
        Route::get('/change-password/{id}', [adminProfileController::class, 'changePassword']);
        Route::post('/save-profile-password', [adminProfileController::class, 'savePassword']);
        Route::get('/view-profile-details/{id}', [adminProfileController::class, 'viewProfile']);
        Route::get('/delete-profile-details/{id}', [adminProfileController::class, 'deleteProfile']);
        Route::get('/restore-profile-details/{id}', [adminProfileController::class, 'restoreProfile']);

        Route::get('/logout', [adminLogoutController::class, 'index']);
    });
});

Route::get('/update-app', function()
{
    Artisan::call('dump-autoload');
    echo 'dump-autoload complete';
});

Route::fallback(function () {
    return redirect('/page-not-found');
});
