<?php
/*
* Package : https://github.com/tijsverkoyen/CssToInlineStyles
*
* CssToInlineStyles is a class that enables you to convert HTML-pages/files into HTML-pages/files with inline styles. 
* This is very useful when you're sending emails.
*/ 

require_once(dirname(dirname(__FILE__)) . '/vendor/autoload.php');
use TijsVerkoyen\CssToInlineStyles\CssToInlineStyles;

function CssToInlineStylesIEM($html,$styles=[]) {
	
  
   $cssToInlineStyles = new CssToInlineStyles();
     	 
	// Convert CSS styles to inline HTML
	if(!empty($styles)) {
		foreach ($styles as $css) {
			$css = $css ?? '';
			if(file_exists($css)) {
				$html = $cssToInlineStyles->convert($html, file_get_contents($css));
			}
		}
	}
				
	return  $html; 

} 