<?php

// an array of tables that are created.
// we need this so if the addon is uninstalled, we know what we need to clean up.
$tables = ['list_tags', 'dynamic_content_tags', 'dynamic_content_block'];

// the actual queries we're going to run.
$queries = [];

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%dynamic_content_tags (
  tagid INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(255) NOT NULL,
  createdate INT(11) UNSIGNED NOT NULL,
  ownerid INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY(tagid)
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%dynamic_content_block (
  blockid INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  tagid INT(11) UNSIGNED NOT NULL,
  name VARCHAR(255) NOT NULL,
  rules LONGTEXT NOT NULL,
  jsonbody longtext default NULL,
  activated CHAR(1) NULL,
  sortorder INTEGER(4) UNSIGNED NOT NULL,
  PRIMARY KEY(blockid)
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';

$queries[] = 'CREATE TABLE %%TABLEPREFIX%%list_tags (
  tagid INT(11) UNSIGNED NOT NULL,
  listid INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (tagid, listid)
) CHARACTER SET=utf8mb4 ENGINE=INNODB
';
