<?php
/**
* This file is part of the upgrade process.
*
* @package SendStudio
*/

/**
* Do a sanity check to make sure the upgrade api has been included.
*/
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
* add_webhook_logs_table
*
* @see Upgrade_API
*
* @package SendStudio
*/
class add_webhook_logs_table extends Upgrade_API
{
	/**
	* RunUpgrade
	* Runs the add_user_credit_summary_table upgrade
	*
	* @return boolean Returns TRUE if successful, FALSE otherwise
	*/
	function RunUpgrade($upgrade = false)
	{
		if ($this->TableExists('webhook_logs')) {
			return true;
		}

		$query = "
			CREATE TABLE IF NOT EXISTS " . SENDSTUDIO_TABLEPREFIX . "webhook_logs (
				  logid 					int(11) 		NOT NULL AUTO_INCREMENT,
				  webhook_type_id 			int(11) 		NOT NULL,
				  webhook_event_type_id  	int(11)			NOT NULL,
				  logmsg 					text 			NOT NULL,
				  webhook_response			VARCHAR(255)	NULL,
				  logdate 					int(11)			DEFAULT 0,
				  PRIMARY KEY (logid)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";

		$result = $this->Db->Query($query);
		return $result;
	}
}
