// Home Page JavaScript

document.addEventListener("DOMContentLoaded", function () {
    // Initialize Hero Slider
    $(".hero-slider").slick({
        dots: true,
        infinite: true,
        speed: 1000,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 5000,
        fade: true,
        cssEase: "linear",
        arrows: true,
        pauseOnHover: false,
        pauseOnFocus: false,
    });

    // Initialize Epicure Slider
    $(".epicure-slider").slick({
        dots: true,
        infinite: true,
        speed: 800,
        slidesToShow: 3,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        arrows: true,
        pauseOnHover: true,
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                },
            },
        ],
    });

    // Mobile Menu Toggle
    const menuToggle = document.querySelector(".mobile-menu-toggle");
    const navMenu = document.querySelector(".nav-menu");

    if (menuToggle) {
        menuToggle.addEventListener("click", function () {
            navMenu.classList.toggle("active");
            this.textContent = navMenu.classList.contains("active") ? "✕" : "☰";
        });
    }

    // Close mobile menu when clicking outside
    document.addEventListener("click", function (event) {
        if (navMenu && navMenu.classList.contains("active")) {
            if (
                !event.target.closest(".nav-menu") &&
                !event.target.closest(".mobile-menu-toggle")
            ) {
                navMenu.classList.remove("active");
                if (menuToggle) {
                    menuToggle.textContent = "☰";
                }
            }
        }
    });

    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach((anchor) => {
        anchor.addEventListener("click", function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute("href"));
            if (target) {
                target.scrollIntoView({
                    behavior: "smooth",
                    block: "start",
                });

                // Close mobile menu if open
                if (navMenu && navMenu.classList.contains("active")) {
                    navMenu.classList.remove("active");
                    if (menuToggle) {
                        menuToggle.textContent = "☰";
                    }
                }
            }
        });
    });

    // Add scroll effect to header
    let lastScroll = 0;
    const header = document.querySelector(".main-header");

    window.addEventListener("scroll", function () {
        const currentScroll = window.pageYOffset;

        if (currentScroll > 100) {
            header.style.background = "rgba(26, 26, 26, 0.95)";
            header.style.backdropFilter = "blur(10px)";
        } else {
            header.style.background =
                "linear-gradient(to bottom, rgba(0,0,0,0.8), transparent)";
            header.style.backdropFilter = "none";
        }

        lastScroll = currentScroll;
    });

    // Animate elements on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: "0px 0px -100px 0px",
    };

    const observer = new IntersectionObserver(function (entries) {
        entries.forEach((entry) => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = "1";
                entry.target.style.transform = "translateY(0)";
            }
        });
    }, observerOptions);

    // Observe elements for animation
    document
        .querySelectorAll(
            ".feature-section, .membership-section, .events-section, .venues-section"
        )
        .forEach((section) => {
            section.style.opacity = "0";
            section.style.transform = "translateY(30px)";
            section.style.transition = "opacity 0.6s ease, transform 0.6s ease";
            observer.observe(section);
        });
});
