@extends('layouts.admin')

@section('title', 'Pages')
@section('page-title', 'Pages')

@section('page-actions')
    <a href="{{ route('admin.pages.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Create New Page
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">All Pages</h5>
            </div>
            <div class="col-auto">
                <form method="GET" action="{{ route('admin.pages.index') }}" class="row g-2">
                    <div class="col-auto">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Search..." value="{{ request('search') }}">
                    </div>
                    <div class="col-auto">
                        <select name="status" class="form-select form-select-sm">
                            <option value="">All Status</option>
                            <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                            <option value="published" {{ request('status') == 'published' ? 'selected' : '' }}>Published</option>
                            <option value="private" {{ request('status') == 'private' ? 'selected' : '' }}>Private</option>
                        </select>
                    </div>
                    <div class="col-auto">
                        <select name="is_featured" class="form-select form-select-sm">
                            <option value="">All Pages</option>
                            <option value="1" {{ request('is_featured') == '1' ? 'selected' : '' }}>Featured</option>
                            <option value="0" {{ request('is_featured') == '0' ? 'selected' : '' }}>Not Featured</option>
                        </select>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                        <a href="{{ route('admin.pages.index') }}" class="btn btn-sm btn-secondary">Clear</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Status</th>
                        <th>Featured</th>
                        <th>Sort Order</th>
                        <th>Author</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($pages as $page)
                        <tr>
                            <td>{{ $page->id }}</td>
                            <td>
                                <strong>{{ $page->title }}</strong>
                                @if($page->excerpt)
                                    <br><small class="text-muted">{{ Str::limit($page->excerpt, 50) }}</small>
                                @endif
                            </td>
                            <td><code>{{ $page->slug }}</code></td>
                            <td>
                                @if($page->status == 'published')
                                    <span class="badge bg-success">Published</span>
                                @elseif($page->status == 'draft')
                                    <span class="badge bg-warning">Draft</span>
                                @else
                                    <span class="badge bg-secondary">Private</span>
                                @endif
                            </td>
                            <td>
                                @if($page->is_featured)
                                    <i class="bi bi-star-fill text-warning"></i>
                                @else
                                    <i class="bi bi-star text-muted"></i>
                                @endif
                            </td>
                            <td>{{ $page->sort_order }}</td>
                            <td>
                                @if($page->author)
                                    {{ $page->author->name }}
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </td>
                            <td>{{ $page->created_at->format('M d, Y') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.pages.edit', $page) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form method="POST" action="{{ route('admin.pages.destroy', $page) }}" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this page?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <p class="text-muted mb-0">No pages found.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($pages->hasPages())
        <div class="card-footer">
            {{ $pages->links() }}
        </div>
    @endif
</div>
@endsection
