@extends('layouts.admin')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="alert alert-success" role="alert">
            <h4 class="alert-heading">Welcome!</h4>
            <p class="mb-0">You're logged in! Use the sidebar to navigate through the admin panel.</p>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title text-white-50 mb-1">Total Pages</h6>
                        <h2 class="mb-0">{{ \App\Models\Page::count() }}</h2>
                    </div>
                    <div>
                        <i class="bi bi-file-earmark-text" style="font-size: 3rem; opacity: 0.5;"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-primary bg-opacity-75 border-0">
                <a href="{{ route('admin.pages.index') }}" class="text-white text-decoration-none">
                    View all pages <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title text-white-50 mb-1">Published</h6>
                        <h2 class="mb-0">{{ \App\Models\Page::where('status', 'published')->count() }}</h2>
                    </div>
                    <div>
                        <i class="bi bi-check-circle" style="font-size: 3rem; opacity: 0.5;"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-success bg-opacity-75 border-0">
                <a href="{{ route('admin.pages.index', ['status' => 'published']) }}" class="text-white text-decoration-none">
                    View published <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-title text-white-50 mb-1">Drafts</h6>
                        <h2 class="mb-0">{{ \App\Models\Page::where('status', 'draft')->count() }}</h2>
                    </div>
                    <div>
                        <i class="bi bi-pencil-square" style="font-size: 3rem; opacity: 0.5;"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-warning bg-opacity-75 border-0">
                <a href="{{ route('admin.pages.index', ['status' => 'draft']) }}" class="text-white text-decoration-none">
                    View drafts <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Recent Pages</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Title</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse(\App\Models\Page::latest()->take(5)->get() as $page)
                                <tr>
                                    <td>
                                        <strong>{{ $page->title }}</strong>
                                    </td>
                                    <td>
                                        @if($page->status == 'published')
                                            <span class="badge bg-success">Published</span>
                                        @elseif($page->status == 'draft')
                                            <span class="badge bg-warning">Draft</span>
                                        @else
                                            <span class="badge bg-secondary">Private</span>
                                        @endif
                                    </td>
                                    <td>{{ $page->created_at->diffForHumans() }}</td>
                                    <td>
                                        <a href="{{ route('admin.pages.edit', $page) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-pencil"></i> Edit
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center py-3 text-muted">
                                        No pages yet. <a href="{{ route('admin.pages.create') }}">Create your first page</a>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.pages.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create New Page
                    </a>
                    <a href="{{ route('admin.pages.index') }}" class="btn btn-outline-primary">
                        <i class="bi bi-list"></i> View All Pages
                    </a>
                    <a href="{{ route('admin.pages.index', ['is_featured' => '1']) }}" class="btn btn-outline-warning">
                        <i class="bi bi-star"></i> Featured Pages
                    </a>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">System Info</h5>
            </div>
            <div class="card-body">
                <p class="mb-2"><strong>Laravel Version:</strong> {{ app()->version() }}</p>
                <p class="mb-2"><strong>PHP Version:</strong> {{ phpversion() }}</p>
                <p class="mb-0"><strong>Environment:</strong> {{ app()->environment() }}</p>
            </div>
        </div>
    </div>
</div>
@endsection
