<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>The Hotel Dining Club - Exclusive Dining Experiences</title>

  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link
    href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@300;400;500;600;700&family=Lato:wght@300;400;700&display=swap"
    rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- Slick Slider CSS -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
  <link rel="stylesheet" type="text/css"
    href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css" />

  <!-- Custom CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/home.css')); ?>">
</head>

<body>
  <!-- Header -->
  <header class="main-header">
    <div class="header-container">
      <div class="logo">
        <h1>THE LALIT<br>DINING CLUB</h1>
      </div>
      <nav>
        <ul class="nav-menu">
          <li><a href="#home">HOME</a></li>
          <li><a href="#home">BENEFITS</a></li>
          <li><a href="#membership">MEMBERS OFFERS</a></li>
          <li><a href="#events">Hotel & Resort</a></li>
          <li><a href="#venues">Restaurants, Bars & Spas</a></li>
        </ul>
        <button class="mobile-menu-toggle">☰</button>
      </nav>
    </div>
  </header>

  <!-- Hero Section -->
  <section class="hero-section" id="home">
    <div class="hero-slider">
      <div class="hero-slide"
        style="background-image: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('https://images.unsplash.com/photo-1414235077428-338989a2e8c0?q=80&w=2070');">
      </div>
      <div class="hero-slide"
        style="background-image: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('https://images.unsplash.com/photo-1551632436-cbf8dd35adfa?q=80&w=2071');">
      </div>
      <div class="hero-slide"
        style="background-image: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?q=80&w=2070');">
      </div>
      <div class="hero-slide"
        style="background-image: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('https://images.unsplash.com/photo-1550966871-3ed3cdb5ed0c?q=80&w=2070');">
      </div>
    </div>
    <div class="hero-content">
      <h2>Elevate Your Palate.<br>Exclusive Dining<br>Experiences Await</h2>
    </div>
  </section>

  <!-- Epicure Rewards Section -->
  <section class="epicure-section">
    <div class="epicure-container">
      <div class="epicure-header">
        <h2>EPICURE - REWARD YOURSELF</h2>
        <p>Enjoy an array of unparalleled privileges and elevate your lifestyle like never before with Epicure
          memberships. Crafted for sheer indulgence, experience a diverse range of exceptional stays, unique dining
          options, wellness therapies and more.</p>
      </div>
      <div class="epicure-slider">
        <div class="epicure-card">
          <div class="epicure-image">
            <img src="https://images.unsplash.com/photo-1611892440504-42a792e24d32?q=80&w=1470" alt="One Night Stay">
          </div>
          <div class="epicure-content">
            <h3>ONE NIGHT STAY WITH BREAKFAST</h3>
            <p>Voucher for one-night stay, in base category rooms, including breakfast</p>
          </div>
        </div>
        <div class="epicure-card">
          <div class="epicure-image">
            <img src="https://images.unsplash.com/photo-1414235077428-338989a2e8c0?q=80&w=2070" alt="Set Meal">
          </div>
          <div class="epicure-content">
            <h3>SET MEAL FOR TWO</h3>
            <p>Vouchers for use at select All-Day Dining Restaurants across properties</p>
          </div>
        </div>
        <div class="epicure-card">
          <div class="epicure-image">
            <img src="https://images.unsplash.com/photo-1611892440504-42a792e24d32?q=80&w=1470" alt="Food & Beverage">
          </div>
          <div class="epicure-content">
            <h3>25% SAVINGS ON FOOD & BEVERAGE</h3>
            <p>For up to ten people on dine-in, in-room dining and takeaway at select properties</p>
          </div>
        </div>
        <div class="epicure-card">
          <div class="epicure-image">
            <img src="https://images.unsplash.com/photo-1544025162-d76694265947?q=80&w=1469" alt="Spa Services">
          </div>
          <div class="epicure-content">
            <h3>COMPLIMENTARY SPA SERVICES</h3>
            <p>Exclusive wellness therapies and spa treatments at luxury properties</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Membership Section -->
  <section class="membership-section" id="membership">
    <div class="membership-container">
      <div class="membership-card">
        <div class="membership-icon">
          <i class="fas fa-utensils"></i>
        </div>
        <h3>FOUNDERS' CIRCLE<br>MEMBERSHIP</h3>
        <p>Priority Reservations | Private Concierge | Complimentary Tastings | Annual Gala Invite</p>
      </div>
      <div class="membership-content">
        <h2>Unlock Unparalleled Access</h2>
        <p>Discover a world of culinary privilege. Our members enjoy bespoke dining journeys, exclusive chef's table
          events, and global hotel partnerships. Join a community of discerning connoisseurs.</p>
        <button class="btn-primary">EXPLORE MEMBERSHIP</button>
      </div>
    </div>
  </section>

  <!-- Lifestyle Benefits Section -->
  <section class="lifestyle-benefits-section">
    <div class="lifestyle-container">
      <div class="lifestyle-left">
        <span class="lifestyle-label">EXCLUSIVE BENEFITS</span>
        <h2>ELEVATE YOUR <em>EXPERIENCE</em></h2>
        <p>and unlock member benefits across participating hotels in India.</p>
      </div>
      <div class="lifestyle-right">
        <div class="lifestyle-image">
          <img src="https://images.unsplash.com/photo-1521017432531-fbd92d768814?q=80&w=2070" alt="Lifestyle Benefits">
        </div>
        <div class="lifestyle-content-box">
          <h3>LIFESTYLE BENEFITS</h3>
          <p>A membership to complement your lifestyle across 40+ hotels and 150+ restaurants and bars.</p>
          <button class="btn-orange">LEARN MORE</button>
        </div>
        <div class="lifestyle-nav">
          <button class="nav-btn nav-up"><i class="fas fa-chevron-up"></i></button>
          <button class="nav-btn nav-down"><i class="fas fa-chevron-down"></i></button>
        </div>
      </div>
    </div>
  </section>

  <!-- Elevate Experience Section -->
  <section class="elevate-section">
    <div class="elevate-overlay"></div>
    <div class="elevate-content">
      <h2>ELEVATE EVERY<br><em>EXPERIENCE</em></h2>
      <p>From intimate dinners to family getaways, enjoy exclusive offers and tailored benefits that transform every
        occasion into something extraordinary across Hyatt hotels in India.</p>
      <button class="btn-orange">JOIN NOW</button>
    </div>
  </section>

  <!-- Events Section -->
  <section class="events-section" id="events">
    <div class="events-container reverse">
      <div class="feature-image">
        <img src="https://images.unsplash.com/photo-1511795409834-ef04bbd61622?q=80&w=1469" alt="Dining Event">
      </div>
      <div class="feature-content">
        <h2>Curated Events &<br>Tasting Journeys</h2>
        <p>From intimate wine pairings with renowned sommeliers to themed culinary festivals, our calendar is filled
          with exclusive gatherings designed to delight.</p>
        <button class="btn-primary">SEE EVENTS CALENDAR</button>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer class="main-footer" id="contact">
    <div class="footer-container">
      <div class="footer-newsletter">
        <h4>STAY IN TOUCH.</h4>
        <p>Subscribe to our newsletter to stay updated on events, promotions and offers</p>
        <form class="newsletter-form">
          <input type="email" placeholder="ENTER YOUR EMAIL ID" required>
          <input type="text" placeholder="SELECT YOUR CITY">
          <div class="newsletter-checkbox">
            <input type="checkbox" id="agree-promo" required>
            <label for="agree-promo">I agree to receive promotions and updates on my email ID.</label>
          </div>
          <button type="submit" class="btn-subscribe">SUBSCRIBE</button>
        </form>
      </div>
      <div class="footer-links">
        <h4>PROGRAMME</h4>
        <ul>
          <li><a href="#">FAQs</a></li>
          <li><a href="#">Contact Us</a></li>
          <li><a href="#">Terms and Conditions</a></li>
          <li><a href="#">Privacy Policy</a></li>
          <li><a href="#">Cookie Policy</a></li>
          <li><a href="#">Sitemap</a></li>
        </ul>
      </div>
      <div class="footer-links">
        <h4>USEFUL LINKS</h4>
        <ul>
          <li><a href="#">Benefits</a></li>
          <li><a href="#">Member Offers</a></li>
          <li><a href="#">Hotels & Resorts</a></li>
          <li><a href="#">Restaurants, Bars & Spas</a></li>
        </ul>
      </div>
      <div class="footer-social">
        <h4>FIND US</h4>
        <div class="social-icons">
          <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
          <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
        </div>
      </div>
    </div>
  </footer>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- Slick Slider JS -->
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

  <!-- Custom JS -->
  <script src="<?php echo e(asset('assets/js/home.js')); ?>"></script>
</body>

</html><?php /**PATH D:\projects\lalitdiningclub\resources\views/home.blade.php ENDPATH**/ ?>