

<?php $__env->startSection('title', 'Pages'); ?>
<?php $__env->startSection('page-title', 'Pages'); ?>

<?php $__env->startSection('page-actions'); ?>
    <a href="<?php echo e(route('admin.pages.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Create New Page
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">All Pages</h5>
            </div>
            <div class="col-auto">
                <form method="GET" action="<?php echo e(route('admin.pages.index')); ?>" class="row g-2">
                    <div class="col-auto">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Search..." value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-auto">
                        <select name="status" class="form-select form-select-sm">
                            <option value="">All Status</option>
                            <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                            <option value="published" <?php echo e(request('status') == 'published' ? 'selected' : ''); ?>>Published</option>
                            <option value="private" <?php echo e(request('status') == 'private' ? 'selected' : ''); ?>>Private</option>
                        </select>
                    </div>
                    <div class="col-auto">
                        <select name="is_featured" class="form-select form-select-sm">
                            <option value="">All Pages</option>
                            <option value="1" <?php echo e(request('is_featured') == '1' ? 'selected' : ''); ?>>Featured</option>
                            <option value="0" <?php echo e(request('is_featured') == '0' ? 'selected' : ''); ?>>Not Featured</option>
                        </select>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                        <a href="<?php echo e(route('admin.pages.index')); ?>" class="btn btn-sm btn-secondary">Clear</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Status</th>
                        <th>Featured</th>
                        <th>Sort Order</th>
                        <th>Author</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($page->id); ?></td>
                            <td>
                                <strong><?php echo e($page->title); ?></strong>
                                <?php if($page->excerpt): ?>
                                    <br><small class="text-muted"><?php echo e(Str::limit($page->excerpt, 50)); ?></small>
                                <?php endif; ?>
                            </td>
                            <td><code><?php echo e($page->slug); ?></code></td>
                            <td>
                                <?php if($page->status == 'published'): ?>
                                    <span class="badge bg-success">Published</span>
                                <?php elseif($page->status == 'draft'): ?>
                                    <span class="badge bg-warning">Draft</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Private</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($page->is_featured): ?>
                                    <i class="bi bi-star-fill text-warning"></i>
                                <?php else: ?>
                                    <i class="bi bi-star text-muted"></i>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($page->sort_order); ?></td>
                            <td>
                                <?php if($page->author): ?>
                                    <?php echo e($page->author->name); ?>

                                <?php else: ?>
                                    <span class="text-muted">N/A</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($page->created_at->format('M d, Y')); ?></td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.pages.edit', $page)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form method="POST" action="<?php echo e(route('admin.pages.destroy', $page)); ?>" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this page?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <p class="text-muted mb-0">No pages found.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($pages->hasPages()): ?>
        <div class="card-footer">
            <?php echo e($pages->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\lalitdiningclub\resources\views/admin/pages/index.blade.php ENDPATH**/ ?>