<?php

namespace App\Http\Controllers;

use App\Models\Slide;
use App\Models\ManageHome;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $slides = Slide::active()->ordered()->get();
        
        // Fetch the active home sections and banner
        $homeData = ManageHome::active()->first();
        
        // If no home data exists, create a default one
        if (!$homeData) {
            $homeData = ManageHome::create([
                'section_1' => null,
                'section_2' => null,
                'section_3' => null,
                'section_4' => null,
                'section_5' => null,
                'banner_img' => null,
                'status' => true,
            ]);
        }
        
        return view('home', compact('slides', 'homeData'));
    }
}
