<?php

namespace App\Http\Controllers;

use App\Models\Benefit;
use App\Models\ManageHome;
use App\Models\PackageDetail;
use App\Models\Page;
use App\Models\Point;
use App\Models\Reward;
use App\Models\Tier;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class PublicPageController extends Controller {

    /**
     * Display the specified page by slug (public view).
     */
    public function showBySlug(string $slug) {
        $page = Page::where('slug', $slug)
                ->where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->firstOrFail();

        return view('pages', compact('page'));
    }

    public function homestatic() {
        // get home management data for banner
        $homeData = ManageHome::active()->first();

        // get benefits data
        $benefits = Benefit::where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->orderBy('sort_order')
                ->get();

        // get rewards data
        $rewards = Reward::where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->orderBy('sort_order')
                ->get();

        // get tiers data
        $tiers = Tier::where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->orderBy('sort_order')
                ->get();

        // get points data
        $points = Point::where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->orderBy('sort_order')
                ->get();

        return view('homestatic', compact('rewards', 'tiers', 'points', 'homeData', 'benefits'));
    }

    public function packageDetails() {
        $packageDetail = PackageDetail::active()->first();

        if (!$packageDetail) {
            abort(404, 'Package details not found or inactive.');
        }

        return view('package-details', compact('packageDetail'));
    }

    public function contact() {
        $page = Page::where('slug', 'contact-us')
                ->where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->firstOrFail();

        return view('contact', compact('page'));
    }

    public function sitemap() {
        $pages = Page::where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->orderBy('sort_order')
                ->get();

        return response()->view('sitemap', compact('pages'))
                        ->header('Content-Type', 'application/xml');
    }

    public function rewards(string $slug) {
        $reward = Reward::where('slug', $slug)
                ->where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->firstOrFail();

        return view('rewards', compact('reward'));
    }

    public function points(string $slug) {
        $point = Point::where('slug', $slug)
                ->where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->firstOrFail();

        return view('points', compact('point'));
    }

    public function tiers(string $slug) {
        $tier = Tier::where('slug', $slug)
                ->where('status', 'published')
                ->where(function ($query) {
                    $query->whereNull('published_at')
                            ->orWhere('published_at', '<=', now());
                })
                ->firstOrFail();

        return view('tiers', compact('tier'));
    }
}
