<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'The LaLiT Hotels')</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Optional Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}"/>
    <style>
        /* Primary Navigation Menu */
        .site-header {
            position: relative;
            z-index: 1030;
            width: 100%;
        }
        
        .carousel-nav-menu {
            background-color: #f5f0eb;
            padding: 0.75rem 1rem;
        }
        
        /* Secondary Navigation Styles */
        .secondary-nav {
            border-top: 1px solid rgba(0,0,0,0.05);
        }
        
        .secondary-nav-links .nav-link {
            color: #212322;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
        }
        
        .secondary-nav-links .nav-link:hover,
        .secondary-nav-links .nav-link:focus {
            color: #c6aa76;
        }
        
        /* For better visibility on mobile */
        @media (max-width: 768px) {
            .carousel-nav-menu {
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
                padding: 0.5rem;
            }
            
            .site-header {
                position: sticky;
                top: 0;
                z-index: 1030;
            }
            
            .logo img {
                max-height: 40px !important;
            }
            
            .hero-container {
                width: 100%;
                overflow: hidden;
                position: relative;
            }
            
            h1.page-title {
                font-size: 1.75rem;
                margin-top: 1rem;
                margin-bottom: 1rem;
                text-align: center;
                color: #212322;
                font-weight: 600;
            }
        }
        
        /* Sticky Navigation Styles */
        #sticky-page-nav {
            transition: all 0.3s ease;
            z-index: 1020;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        #sticky-page-nav .container-fluid {
            background-color: rgba(255, 255, 255, 0.97) !important;
            backdrop-filter: blur(10px);
        }
        
        #sticky-page-nav .sticky-logo img {
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link {
            color: #444;
            font-size: 0.9rem;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
            margin: 0 0.2rem;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link:hover {
            color: #c6aa76;
        }
        
        #sticky-page-nav .secondary-navigation .nav-link.active {
            color: #c6aa76;
            font-weight: 600;
            background-color: transparent;
        }
        

        
        #sticky-page-nav .btn-primary {
            background-color: #c6aa76;
            border-color: #c6aa76;
            padding: 0.375rem 1rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        #sticky-page-nav .btn-primary:hover {
            background-color: #b09762;
            border-color: #b09762;
            transform: translateY(-2px);
        }
        
        @media (max-width: 991px) {
            #sticky-page-nav .secondary-navigation {
                display: none !important;
            }
            
            #sticky-page-nav .nav-action {
                margin-left: auto;
            }
        }
        
        @media (max-width: 768px) {
            #sticky-page-nav .sticky-logo img {
                height: 32px;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body class="page-layout font-sans antialiased bg-gray-50 dark:bg-gray-900">
    <header class="site-header">
        <!-- Primary Navigation Header -->
        <div class="carousel-nav-menu px-3" style="background-color: #f5f0eb;">
            <div class="d-flex justify-content-between align-items-center py-2">
                <!-- Left Side - Toggle Button for Mobile / Empty space for Desktop -->
                <div class="nav-left">
                    <button class="btn btn-outline-dark d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasMenu">
                        ☰
                    </button>
                    <!-- Empty space for desktop to balance layout -->
                    <div class="d-none d-lg-block" style="width: 200px;"></div>
                </div>
                
                <!-- Center Logo -->
                <div class="logo">
                    <a href="/">
                        <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid">
                    </a>
                </div>

                <!-- Right Side - Desktop Menu / Mobile Login -->
                <div class="nav-right">                    
                  <!-- Desktop Menu -->
                    <ul class="nav nav-pills d-none d-lg-flex">
                        <li class="nav-item">
                            <a href="https://thelalitloyalty.in" class="nav-link">
                                Login
                            </a>
                        </li>
                        <li class="nav-item"><a class="nav-link" href="https://www.thelalit.com/">Book your stay</a></li>
                    </ul>

                    <!-- Login Button for Mobile (visible only on mobile) -->
                    <div class="d-lg-none">
                        <a target="_blank" href="https://thelalitloyalty.in" class="btn btn-outline-dark btn-sm">
                            Login
                        </a>
                    </div>
                </div>
            </div>

            <!-- Secondary Navigation Header -->
            <div class="secondary-nav">
                <div class="container-fluid px-3">
                    <div class="d-flex justify-content-center align-items-center h-100">
                        <!-- Secondary Navigation Links -->                        
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/')}}#membership-tier">Membership Tiers</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/')}}#rewards">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/about-us')}}">About</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/contact-us')}}">Contact</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Offcanvas Menu -->
        <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title">The Lalit</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
            </div>            
            <div class="offcanvas-body d-flex flex-column">                
                <ul class="nav nav-pills flex-column">
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="{{url('/')}}">Home</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="{{url('/')}}#membership-tier">Membership Tiers</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="{{url('/')}}#rewards">Rewards</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="{{url('/about-us')}}">About</a></li>
                  <li class="nav-item"><a class="nav-link mobile-nav-link" href="{{url('/contact-us')}}">Contact</a></li>
                </ul>
                  <!-- Mobile Menu Footer -->
                <div class="mt-auto pt-4 border-top">
                    <div class="d-flex flex-column gap-2">
                        <a href="https://thelalitloyalty.in" class="btn btn-primary btn-sm mobile-nav-link">Join Now</a>
                        <a href="https://thelalitloyalty.in" target="_blank" class="btn btn-outline-primary btn-sm mobile-nav-link">Login</a>
                        <a href="https://www.thelalit.com/" target="_blank" class="btn btn-primary btn-sm mobile-nav-link">Book Your Stay</a>
                    </div>
                </div>
            </div>
        </div>

        @hasSection('hero')
            <div class="hero-container">
                @yield('hero')
            </div>
        @endif
    </header>

    <!-- Sticky Page Navigation -->
    <div id="sticky-page-nav" class="sticky-top">
        <div class="container-fluid py-2 bg-white border-bottom shadow-sm">
            <div class="container">
                <!-- Main Navigation Row -->
                <div class="d-flex justify-content-between align-items-center">
                    <!-- Logo instead of page title -->
                    <div class="sticky-logo">
                        <a href="{{ route('homestatic') }}">
                            <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid" style="height: 40px;">
                        </a>
                    </div>
                    
                    <!-- Secondary Navigation Links -->
                    <nav class="secondary-navigation d-none d-lg-block">
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/')}}#membership-tier">Membership Tiers</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/')}}#rewards">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/about-us')}}">About</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{url('/contact-us')}}">Contact</a></li>
                        </ul>
                    </nav>
                    
                    <div class="nav-action">
                        <a href="https://thelalitloyalty.in" class="btn btn-sm btn-primary">Join Now</a>
                    </div>
                </div>
                

            </div>
        </div>
    </div>

    <!-- Page Title Section - Will be shown on mobile views -->
    @hasSection('page_title')
        <div class="page-title-container d-md-none bg-white py-3">
            <div class="container">
                <h1 class="page-title">@yield('page_title')</h1>
            </div>
        </div>
    @endif

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="py-5" style="background-color: #f5f0eb;">
        <div class="container">
            <div class="row">
                <!-- Links Sections -->
                <div class="col-lg-8 mb-4">
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6 mb-4">
                            <h5 class="mb-3" style="color: #212322;">Quick Links</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/about-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">About The LaLit Loyalty</a></li>
                                <li class="mb-2"><a href="/contact-us" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Contact Us</a></li>
                                <li class="mb-2"><a href="/faqs" class="text-decoration-none" style="color: #212322; opacity: 0.7;">FAQs</a></li>
                                <li class="mb-2"><a href="/terms-condition" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Terms & Conditions</a></li>
                                <li class="mb-2"><a href="/privacy-policy" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Privacy Policy</a></li>
                            </ul>
                        </div>
                        
                        <!-- Second Column -->
                        <div class="col-md-6 mb-4">
                            <ul class="list-unstyled">
                            </ul>
                        </div>
                    </div>
                </div>
                
                <!-- Social Media Section -->
                {{-- <div class="col-lg-4 mb-4">
                    <h5 class="mb-3" style="color: #212322;">Let's stay in touch</h5>                    
                    <div class="connect-newsletter-cta">
                        <a href="/newsletter-sign-up" class="btn btn-lg px-2 py-1" style="background-color: #000; color: #fff; border-color: #000;">
                            Newsletter sign-up
                        </a>
                    </div>

                    <p class="mb-4" style="color: #212322; opacity: 0.7;">Follow us on social media for the latest updates and exclusive offers.</p>
                    <div class="d-flex gap-3">
                        <a href="#" class="social-link" style="color: #212322; opacity: 0.7;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 4.557c-.883.392-1.832.656-2.828.775 1.017-.609 1.798-1.574 2.165-2.724-.951.564-2.005.974-3.127 1.195-.897-.957-2.178-1.555-3.594-1.555-3.179 0-5.515 2.966-4.797 6.045-4.091-.205-7.719-2.165-10.148-5.144-1.29 2.213-.669 5.108 1.523 6.574-.806-.026-1.566-.247-2.229-.616-.054 2.281 1.581 4.415 3.949 4.89-.693.188-1.452.232-2.224.084.626 1.956 2.444 3.379 4.6 3.419-2.07 1.623-4.678 2.348-7.29 2.04 2.179 1.397 4.768 2.212 7.548 2.212 9.142 0 14.307-7.721 13.995-14.646.962-.695 1.797-1.562 2.457-2.549z"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link" style="color: #212322; opacity: 0.7;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M22.46 6c-.77.35-1.6.58-2.46.69.88-.53 1.56-1.37 1.88-2.38-.83.5-1.75.85-2.72 1.05C18.37 4.5 17.26 4 16 4c-2.35 0-4.27 1.92-4.27 4.29 0 .34.04.67.11.98C8.28 9.09 5.11 7.38 3 4.79c-.37.63-.58 1.37-.58 2.15 0 1.49.75 2.81 1.91 3.56-.71 0-1.37-.2-1.95-.5v.03c0 2.08 1.48 3.82 3.44 4.21a4.22 4.22 0 0 1-1.93.07 4.28 4.28 0 0 0 4 2.98 8.521 8.521 0 0 1-5.33 1.84c-.34 0-.68-.02-1.02-.06C3.44 20.29 5.7 21 8.12 21 16 21 20.33 14.46 20.33 8.79c0-.19 0-.37-.01-.56.84-.6 1.56-1.36 2.14-2.23z"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link" style="color: #212322; opacity: 0.7;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.748-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001.012.001z"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link" style="color: #212322; opacity: 0.7;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        <a href="#" class="social-link" style="color: #212322; opacity: 0.7;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                            </svg>
                        </a>
                    </div>
                </div> --}}
            </div>
            
            <!-- Copyright Section -->
            <hr class="my-4 border-secondary">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0" style="color: #212322; opacity: 0.7;">&copy; {{ date('Y') }} The LaLiT Hotels. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid" style="max-height: 100px;">
                </div>
            </div>        
          </div>
    </footer>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">            <div class="modal-content" style="border-radius: 12px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">                <div class="modal-header text-center position-relative" style="background-color: #f5f0eb; border-bottom: 1px solid #e5e5e5; border-radius: 12px 12px 0 0; padding: 1.5rem 1.5rem;">
                    <button type="button" class="btn-close position-absolute top-0 end-0 mt-3 me-3" data-bs-dismiss="modal" aria-label="Close"></button>
                    <h5 class="modal-title fw-semibold mb-0 w-100" style="color: #212322;">Sign in to your LaLiT account</h5>
                </div>
                <div class="modal-body p-4" style="background-color: #fff;">
                    
                    <form id="loginForm" action="#" method="POST">
                        <div class="mb-3">
                            <label for="loginEmail" class="form-label fw-semibold" style="color: #212322;">Email Address</label>
                            <input type="email" class="form-control form-control-lg" id="loginEmail" placeholder="Enter your email address" style="border: 2px solid #e5e5e5; border-radius: 8px; padding: 12px 16px;">
                        </div>
                        
                        <div class="mb-4">
                            <label for="loginPassword" class="form-label fw-semibold" style="color: #212322;">Password</label>
                            <input type="password" class="form-control form-control-lg" id="loginPassword" placeholder="Enter your password" style="border: 2px solid #e5e5e5; border-radius: 8px; padding: 12px 16px;">
                        </div>
                          <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-lg fw-semibold" style="background-color: #212322; color: #fff; border: none; border-radius: 8px; padding: 8px 24px; transition: all 0.3s ease;">
                                Sign In
                            </button>
                            
                            <button type="button" class="btn btn-outline-dark btn-lg fw-semibold" style="border: 2px solid #c6aa76; color: #c6aa76; border-radius: 8px; padding: 8px 24px; transition: all 0.3s ease;">
                                Join Now
                            </button>
                        </div>
                        
                        <div class="text-center mt-4">
                            <a href="#" class="text-muted text-decoration-none small">Forgot your password?</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @stack('scripts')
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const header = document.querySelector('header');
        const stickyNav = document.getElementById('sticky-page-nav');
        const navLinks = document.querySelectorAll('#sticky-page-nav .nav-link');
        
        // Fix for mobile navigation links in off-canvas menu
        const mobileNavLinks = document.querySelectorAll('.mobile-nav-link');
        const offcanvasMenu = document.getElementById('offcanvasMenu');
        
        mobileNavLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const href = this.getAttribute('href');
                const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasMenu);
                
                // If it's a hash link, handle special navigation
                if (href.startsWith('#')) {
                    e.preventDefault();
                    
                    // Close the offcanvas menu
                    if (bsOffcanvas) {
                        bsOffcanvas.hide();
                        
                        // Wait for offcanvas to close before scrolling
                        offcanvasMenu.addEventListener('hidden.bs.offcanvas', function scrollToTarget() {
                            const targetElement = document.querySelector(href);
                            if (targetElement) {
                                setTimeout(() => {
                                    window.scrollTo({
                                        top: targetElement.offsetTop - 100,
                                        behavior: 'smooth'
                                    });
                                }, 150);
                            }
                            // Remove event listener to avoid multiple executions
                            offcanvasMenu.removeEventListener('hidden.bs.offcanvas', scrollToTarget);
                        });
                    }
                } else {
                    // For non-hash links, just close the menu (default navigation will happen)
                    if (bsOffcanvas) {
                        bsOffcanvas.hide();
                    }
                }
            });
        });
        
        // Handle scrolling events to show/hide sticky menu
        window.addEventListener('scroll', function() {
            if (!header) return;
            
            const headerBottom = header.getBoundingClientRect().bottom;
            
            // Show sticky nav when scrolled past header
            if (headerBottom <= 0) {
                stickyNav.classList.remove('d-none');
            } else {
                stickyNav.classList.add('d-none');
            }
        });
        
        // Handle navigation link clicks for smooth scrolling
        navLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const targetId = this.getAttribute('href');
                if (targetId && targetId.startsWith('#')) {
                    e.preventDefault();
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        // Calculate offset with sticky nav height
                        const stickyNavHeight = stickyNav.offsetHeight;
                        const targetPosition = targetElement.getBoundingClientRect().top + window.scrollY - stickyNavHeight;
                        
                        // Smooth scroll to target position
                        window.scrollTo({
                            top: targetPosition,
                            behavior: 'smooth'
                        });
                        
                        // Update active state for secondary navigation only
                        navLinks.forEach(link => link.classList.remove('active'));
                        this.classList.add('active');
                    }
                }
            });
        });
        
        // No need for section-based active link detection now that we've removed section navigation
        
    });
    </script>
</body>
</html>
