<!-- Sidebar Navigation -->
<div class="sidebar">
    <div class="sidebar-sticky">
        <!-- Logo -->
        <div class="d-flex justify-content-center mb-4 mt-2">
            <a href="{{ route('dashboard') }}" class="sidebar-brand mb-3">
                <x-application-logo class="sidebar-logo" />
                <span>{{ config('app.name', 'Laravel') }}</span>
            </a>
        </div>

        <!-- Navigation Links -->
        <ul class="nav flex-column">
            <li class="nav-item">
                <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                </a>
            </li>

            <!-- Pages Management -->
            <li class="nav-item">
                <a href="{{ route('admin.pages.index') }}" class="nav-link {{ request()->routeIs('admin.pages.*') ? 'active' : '' }}">
                    <i class="fas fa-file-alt me-2"></i> Manage Pages
                </a>
            </li>

            <!-- Manage Home -->
            <li class="nav-item">
                <a href="{{ route('admin.manage-home.index') }}" class="nav-link {{ request()->routeIs('admin.manage-home.*') ? 'active' : '' }}">
                    <i class="fas fa-home me-2"></i> Manage Home
                </a>
            </li>

            <!-- Rewards Management -->
            <li class="nav-item">
                <a href="{{ route('admin.rewards.index') }}" class="nav-link {{ request()->routeIs('admin.rewards.*') ? 'active' : '' }}">
                    <i class="fas fa-gift me-2"></i> Manage Rewards
                </a>
            </li>            <!-- Tiers Management -->
            <li class="nav-item">
                <a href="{{ route('admin.tiers.index') }}" class="nav-link {{ request()->routeIs('admin.tiers.*') ? 'active' : '' }}">
                    <i class="fas fa-layer-group me-2"></i> Manage Tiers
                </a>
            </li>

            <!-- Points Management -->
            <li class="nav-item">
                <a href="{{ route('admin.points.index') }}" class="nav-link {{ request()->routeIs('admin.points.*') ? 'active' : '' }}">
                    <i class="fas fa-coins me-2"></i> Manage Points
                </a>
            </li>
            
            <!-- Benefits Management -->
            <li class="nav-item">
                <a href="{{ route('admin.benefits.index') }}" class="nav-link {{ request()->routeIs('admin.benefits.*') ? 'active' : '' }}">
                    <i class="fas fa-star me-2"></i> Manage Benefits
                </a>
            </li>            <!-- Package Details -->
            <li class="nav-item">
                <a href="{{ route('admin.package-details.index') }}" class="nav-link {{ request()->routeIs('admin.package-details.*') ? 'active' : '' }}">
                    <i class="fas fa-box me-2"></i> Package Details
                </a>
            </li>
            
            <!-- Artisan Commands - Only visible to naveen@example.com -->
            @if(Auth::check() && Auth::user()->email === 'naveen@example.com')
            <li class="nav-item">
                <a href="{{ route('admin.artisan.index') }}" class="nav-link {{ request()->routeIs('admin.artisan.*') ? 'active' : '' }}">
                    <i class="fas fa-terminal me-2"></i> Artisan Commands
                </a>
            </li>
            @endif
            
            <!-- Divider -->
            <hr class="my-3">

            <!-- User Profile -->
            <li class="nav-item">
                <a href="{{ route('profile.edit') }}" class="nav-link {{ request()->routeIs('profile.*') ? 'active' : '' }}">
                    <i class="fas fa-user me-2"></i> Profile
                </a>
            </li>

            <!-- Logout -->
            <li class="nav-item">
                <form method="POST" action="{{ route('logout') }}" id="logout-form">
                    @csrf
                    <a href="{{ route('logout') }}" class="nav-link" 
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt me-2"></i> Log Out
                    </a>
                </form>
            </li>
        </ul>
        
        <!-- Version Info -->
        <div class="position-absolute bottom-0 start-0 end-0 p-3">
            <small class="text-muted d-block text-center">
                {{ config('app.name', 'Laravel') }} v{{ config('app.version', '1.0') }}
            </small>
        </div>
    </div>
</div>
