<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Benefit: <?php echo e($benefit->title); ?></h1>
                    <div>
                        <a href="<?php echo e(route('admin.benefits.edit', $benefit)); ?>" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.benefits.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Benefits
                        </a>
                    </div>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="row mb-4">
                    <div class="col-md-8">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <span>Benefit Details</span>
                                <span class="badge <?php echo e($benefit->status == 'published' ? 'bg-success' : ($benefit->status == 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                                    <?php echo e(ucfirst($benefit->status)); ?>

                                </span>
                            </div>
                            <div class="card-body">
                                <?php if($benefit->featured_image || $benefit->banner_image): ?>
                                <div class="row mb-4">
                                    <?php if($benefit->featured_image): ?>
                                    <div class="col-md-6 mb-3">
                                        <h5>Featured Image</h5>
                                        <img src="<?php echo e(Storage::url($benefit->featured_image)); ?>" class="img-fluid rounded" 
                                            alt="<?php echo e($benefit->featured_image_alt); ?>">
                                        <?php if($benefit->featured_image_caption): ?>
                                        <p class="mt-2 text-muted"><?php echo e($benefit->featured_image_caption); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if($benefit->banner_image): ?>
                                    <div class="col-md-6 mb-3">
                                        <h5>Banner Image</h5>
                                        <img src="<?php echo e(Storage::url($benefit->banner_image)); ?>" class="img-fluid rounded" 
                                            alt="<?php echo e($benefit->banner_image_alt); ?>">
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <hr>
                                <?php endif; ?>

                                <h2><?php echo e($benefit->title); ?></h2>
                                
                                <?php if($benefit->custom_link): ?>
                                <div class="alert alert-info mb-4">
                                    <h6><i class="fas fa-link"></i> Custom Link</h6>
                                    <a href="<?php echo e($benefit->custom_link); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                        <?php echo e($benefit->custom_link); ?> <i class="fas fa-external-link-alt"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                                
                                <?php if($benefit->excerpt): ?>
                                <div class="card bg-light mb-4">
                                    <div class="card-body">
                                        <h5>Excerpt</h5>
                                        <p class="mb-0"><?php echo e($benefit->excerpt); ?></p>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="mt-4">
                                    <h5>Content</h5>
                                    <div class="content-preview">
                                        <?php echo $benefit->content; ?>

                                    </div>
                                </div>

                                <div class="mt-4">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h6>Slug</h6>
                                            <p><code><?php echo e($benefit->slug); ?></code></p>
                                        </div>
                                        <div class="col-md-6">
                                            <h6>Sort Order</h6>
                                            <p><?php echo e($benefit->sort_order); ?></p>
                                        </div>
                                    </div>
                                </div>

                                <?php if($benefit->is_featured): ?>
                                <div class="mt-3">
                                    <span class="badge bg-primary">Featured Benefit</span>
                                </div>
                                <?php endif; ?>

                                <div class="mt-4">
                                    <small class="text-muted">
                                        Created: <?php echo e($benefit->created_at->format('d M Y, h:i A')); ?> | 
                                        Last Updated: <?php echo e($benefit->updated_at->format('d M Y, h:i A')); ?>

                                        <?php if($benefit->author): ?>
                                        | Author: <?php echo e($benefit->author->name); ?>

                                        <?php endif; ?>
                                        <?php if($benefit->updatedBy): ?>
                                        | Updated by: <?php echo e($benefit->updatedBy->name); ?>

                                        <?php endif; ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Meta Information -->
                        <?php if($benefit->meta_title || $benefit->meta_description || $benefit->meta_keywords): ?>
                        <div class="card mb-4">
                            <div class="card-header">SEO Information</div>
                            <div class="card-body">
                                <?php if($benefit->meta_title): ?>
                                <div class="mb-3">
                                    <h6>Meta Title</h6>
                                    <p class="mb-0"><?php echo e($benefit->meta_title); ?></p>
                                </div>
                                <?php endif; ?>

                                <?php if($benefit->meta_description): ?>
                                <div class="mb-3">
                                    <h6>Meta Description</h6>
                                    <p class="mb-0"><?php echo e($benefit->meta_description); ?></p>
                                </div>
                                <?php endif; ?>

                                <?php if($benefit->meta_keywords): ?>
                                <div class="mb-3">
                                    <h6>Meta Keywords</h6>
                                    <p class="mb-0"><?php echo e($benefit->meta_keywords); ?></p>
                                </div>
                                <?php endif; ?>

                                <?php if($benefit->meta_robots): ?>
                                <div class="mb-3">
                                    <h6>Meta Robots</h6>
                                    <p class="mb-0"><?php echo e($benefit->meta_robots); ?></p>
                                </div>
                                <?php endif; ?>

                                <?php if($benefit->canonical_url): ?>
                                <div class="mb-3">
                                    <h6>Canonical URL</h6>
                                    <p class="mb-0"><a href="<?php echo e($benefit->canonical_url); ?>" target="_blank"><?php echo e($benefit->canonical_url); ?></a></p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Publishing Information -->
                        <div class="card">
                            <div class="card-header">Publishing Information</div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <h6>Status</h6>
                                    <span class="badge <?php echo e($benefit->status == 'published' ? 'bg-success' : ($benefit->status == 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                                        <?php echo e(ucfirst($benefit->status)); ?>

                                    </span>
                                </div>

                                <?php if($benefit->published_at): ?>
                                <div class="mb-3">
                                    <h6>Published Date</h6>
                                    <p class="mb-0"><?php echo e($benefit->published_at->format('d M Y, h:i A')); ?></p>
                                </div>
                                <?php endif; ?>

                                <div class="mb-3">
                                    <h6>Sort Order</h6>
                                    <p class="mb-0"><?php echo e($benefit->sort_order); ?></p>
                                </div>

                                <?php if($benefit->is_featured): ?>
                                <div class="mb-3">
                                    <h6>Featured</h6>
                                    <span class="badge bg-primary">Yes</span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
.content-preview {
    border: 1px solid #e9ecef;
    padding: 1rem;
    border-radius: 0.375rem;
    background-color: #f8f9fa;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/benefits/show.blade.php ENDPATH**/ ?>