<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Points</h1>
                    <a href="<?php echo e(route('admin.points.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Points
                    </a>
                </div>

                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <?php if($points->isEmpty()): ?>
                <div class="alert alert-info" role="alert">
                    No points found. Click the "Create Points" button to add one.
                </div>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>                                    
                                <th>Title</th>
                                <th>Status</th>
                                <th>Sort Order</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($point->id); ?></td>                                        <td>
                                    <a href="<?php echo e(route('admin.points.edit', $point)); ?>" class="text-decoration-none">
                                        <?php echo e($point->title); ?>

                                    </a>
                                </td>
                                <td>
                                    <span class="badge <?php echo e($point->status === 'published' ? 'bg-success' : ($point->status === 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                                        <?php echo e(ucfirst($point->status)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($point->sort_order); ?></td>
                                <td><?php echo e($point->updated_at->format('M d, Y H:i')); ?></td>
                                <td>
                                    <div class="d-flex gap-2">
                                        <a href="<?php echo e(route('admin.points.show', $point)); ?>" class="btn btn-sm btn-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.points.edit', $point)); ?>" class="btn btn-sm btn-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.points.destroy', $point)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this point?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    <?php echo e($points->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/points/index.blade.php ENDPATH**/ ?>