<?php $__env->startSection('title', $packageDetail->heading . ' - The LaLiT Hotels'); ?>

<?php
use Illuminate\Support\Facades\Storage;
?>

<?php $__env->startSection('content'); ?>
<div class="container my-5 pt-4">
    <!-- Header Section -->
    <section class="text-center mb-5 pt-lg-3 pt-md-4">
        <h1 class="display-4 fw-bold" style="margin-top:4rem"><?php echo e($packageDetail->heading); ?></h1>
        <?php if($packageDetail->excerpt): ?>
        <div class="lead mt-3 mb-5 w-75 mx-auto">
            <?php echo e($packageDetail->excerpt); ?>

        </div>
        <?php endif; ?>
        
        <?php if($packageDetail->featured_image && Storage::disk('public')->exists($packageDetail->featured_image)): ?>
        <div class="featured-image-container text-center mt-4 mb-5">
            <img src="<?php echo e(Storage::url($packageDetail->featured_image)); ?>" 
                 alt="<?php echo e($packageDetail->heading); ?>" 
                 class="img-fluid rounded shadow">
        </div>
        <?php endif; ?>
    </section>
    
    <!-- Package Details Section -->
    <section class="package-details mb-5 page-header" id="package-details">
        <div class="text-center mb-5">
            <h2 class="section-title">Member Tier Benefits</h2>
            <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
        </div>
        
        <!-- Package Content -->
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <?php if($packageDetail->content): ?>
                <div class="package-content mb-5">
                    <?php echo $packageDetail->content; ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Package Image - Full Width -->
        <?php if($packageDetail->package_image && Storage::disk('public')->exists($packageDetail->package_image)): ?>
        <div class="row">
            <div class="col-12">
                <div class="additional-image-container text-center mt-4 mb-5">
                    <img src="<?php echo e(Storage::url($packageDetail->package_image)); ?>" 
                         class="img-fluid rounded shadow" 
                         alt="<?php echo e($packageDetail->heading); ?> Package Image">
                </div>
            </div>
        </div>
        <?php endif; ?>
    </section>
    
    <!-- Terms and Conditions Section -->
<!--    <section class="mb-5">
        <div id="package-terms" class="terms-section mb-5 py-5 px-4 bg-light rounded shadow-sm">
            
            <div class="terms-container">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <div class="package-info-content">
                            <div class="d-flex flex-column align-items-center">
                                <div class="mb-4 text-center">
                                    <h5 class="mb-3"><?php echo e($packageDetail->heading); ?></h5>
                                    <?php if($packageDetail->excerpt): ?>
                                    <p><?php echo e($packageDetail->excerpt); ?></p>
                                    <?php endif; ?>
                                </div>
                                
                                <?php if($packageDetail->link): ?>
                                <div class="mt-3 mb-4">
                                    <a href="<?php echo e($packageDetail->link); ?>" target="_blank" class="btn btn-primary btn-lg">
                                        Book This Package <i class="fas fa-external-link-alt ms-2"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                                
                                <div class="mt-3 text-center">
                                    <p class="mb-2">
                                        <i class="fas fa-phone me-1"></i>
                                        For booking assistance, contact our reservations team
                                    </p>
                                    <a href="<?php echo e(url('/contact-us')); ?>" class="btn btn-outline-secondary mt-2">
                                        <i class="fas fa-envelope me-2"></i>Contact Us
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>-->

    <!-- Call to Action Section -->
    <section class="py-5 text-center">
        <h3 class="section-title mb-3">Ready to Experience Luxury?</h3>
        <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
        <p class="section-subtitle mb-4">
            Book your stay with The LaLiT Hotels and discover unparalleled hospitality and comfort.
        </p>
        <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
            <?php if($packageDetail->link): ?>
            <a href="<?php echo e($packageDetail->link); ?>" target="_blank" class="btn btn-lg ct-btn-white">
                Book This Package
            </a>
            <?php endif; ?>
            <a href="https://www.thelalit.com" target="_blank" class="btn btn-lg ct-btn-white">
                Explore All Hotels
            </a>
        </div>
    </section>
</div>

<?php $__env->stopSection(); ?>

<style>
    /* Featured Image Container - Center Image */
    .featured-image-container {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }
    
    .featured-image-container img {
        max-width: 80%;
        max-height: 500px;
        object-fit: cover;
        display: block;
        margin: 0 auto;
    }
    
    /* Additional Image Container */
    .additional-image-container {
        width: 100%;
    }
    
    .additional-image-container img {
        width: 100%;
        max-height: 600px;
        margin: 0 auto;
    }
    
    /* Section Styles */
    .section-title {
        position: relative;
        padding-bottom: 0.75rem;
        margin-bottom: 1.5rem;
    }
    
    /* Package Content Styles */
    .package-content {
        line-height: 1.7;
    }
    
    .package-content h1,
    .package-content h2,
    .package-content h3,
    .package-content h4,
    .package-content h5,
    .package-content h6 {
        margin-top: 2rem;
        margin-bottom: 1rem;
        color: #333;
    }
    
    .package-content p {
        margin-bottom: 1rem;
    }
    
    .package-content ul,
    .package-content ol {
        margin-bottom: 1rem;
        padding-left: 2rem;
    }
    
    .package-content img {
        max-width: 100%;
        height: auto;
        border-radius: 0.375rem;
        margin: 1rem 0;
    }
    
    /* Terms and Conditions */
    .terms-container {
        background-color: #f9f9f9;
        border-radius: 8px;
        padding: 2rem;
    }
    
    .terms-section {
        background-color: #f8f9fa;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .header-title-line {
        width: 60px;
        height: 3px;
        background-color: #c6aa76;
        margin: 0 auto 30px;
    }
    
    /* Ensure content isn't hidden under sticky nav */
    @media (max-width: 767.98px) {
        .container.my-5.pt-4 {
            padding-top: 4rem !important;
        }
    }
    
    /* Proper spacing on different screen sizes */
    @media (min-width: 768px) {
        .pt-md-4 {
            padding-top: 2rem !important;
        }
    }
    
    @media (min-width: 992px) {
        .pt-lg-3 {
            padding-top: 3rem !important;
        }
    }
</style>
<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/package-details.blade.php ENDPATH**/ ?>