

<?php $__env->startSection('title', 'Contact Us - The LaLiT Hotels'); ?>

<?php $__env->startSection('nav-contact', 'active'); ?>

<?php $__env->startSection('content'); ?>
<!-- Contact Hero Section -->
<section class="py-5" style="background-color: #f5f0eb;">
    <div class="container">
        <div class="row justify-content-center text-center">
            <div class="col-lg-8">
                <h1 class="section-title mb-3">Contact Us</h1>
                <div class="header-title-line mx-auto"></div>
                <p class="section-subtitle mt-3 mb-0">
                    We're here to help make your stay extraordinary. Get in touch with our dedicated team.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Contact Information Section -->
<section class="py-5">
    <div class="container">
        <div class="row g-5">
            <!-- Contact Form -->
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h3 class="section-title mb-4">Send us a Message</h3>
                        <form>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label for="firstName" class="form-label">First Name *</label>
                                    <input type="text" class="form-control" id="firstName" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="lastName" class="form-label">Last Name *</label>
                                    <input type="text" class="form-control" id="lastName" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">Email Address *</label>
                                    <input type="email" class="form-control" id="email" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="phone" class="form-label">Phone Number</label>
                                    <input type="tel" class="form-control" id="phone">
                                </div>
                                <div class="col-12">
                                    <label for="subject" class="form-label">Subject *</label>
                                    <select class="form-select" id="subject" required>
                                        <option value="">Select a subject</option>
                                        <option value="reservation">Reservation Inquiry</option>
                                        <option value="event">Event Planning</option>
                                        <option value="dining">Dining Reservations</option>
                                        <option value="spa">Spa Services</option>
                                        <option value="feedback">Feedback</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                                <div class="col-12">
                                    <label for="message" class="form-label">Message *</label>
                                    <textarea class="form-control" id="message" rows="5" required placeholder="Please share your inquiry or message..."></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-lg px-4 py-2" style="background-color: #000; color: #fff; border-color: #000;">
                                        Send Message
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="col-lg-4">
                <div class="contact-info">
                    <h3 class="section-title mb-4">Get in Touch</h3>
                    
                    <div class="contact-item mb-4">
                        <h5 style="color: #c6aa76;">📍 Address</h5>
                        <p class="mb-0">
                            The LaLiT Hotels<br>
                            Luxury Hotel Complex<br>
                            New Delhi, India
                        </p>
                    </div>

                    <div class="contact-item mb-4">
                        <h5 style="color: #c6aa76;">📞 Phone</h5>
                        <p class="mb-0">
                            Reservations: +91 11 4444 7777<br>
                            General Inquiries: +91 11 4444 8888
                        </p>
                    </div>

                    <div class="contact-item mb-4">
                        <h5 style="color: #c6aa76;">✉️ Email</h5>
                        <p class="mb-0">
                            reservations@thelalit.com<br>
                            info@thelalit.com
                        </p>
                    </div>

                    <div class="contact-item mb-4">
                        <h5 style="color: #c6aa76;">🕐 Hours</h5>
                        <p class="mb-0">
                            24/7 Concierge Service<br>
                            Reception: Always Open
                        </p>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="quick-actions mt-5">
                    <h4 class="mb-3">Quick Actions</h4>
                    <div class="d-grid gap-2">
                        <a href="#" class="btn btn-outline-dark">Make a Reservation</a>
                        <a href="<?php echo e(route('services')); ?>" class="btn btn-outline-dark">View Services</a>
                        <a href="#" class="btn btn-outline-dark">Event Planning</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section (Placeholder) -->
<section class="py-5" style="background-color: #f5f0eb;">
    <div class="container">
        <div class="row justify-content-center text-center mb-4">
            <div class="col-lg-8">
                <h2 class="section-title mb-3">Find Us</h2>
                <div class="header-title-line mx-auto"></div>
                <p class="section-subtitle mt-3">
                    Located in the heart of the city, easily accessible from major transportation hubs.
                </p>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="map-placeholder text-center p-5 bg-light rounded">
                    <h5 class="text-muted mb-3">Interactive Map</h5>
                    <p class="text-muted">Map integration would be placed here</p>
                    <small class="text-muted">Google Maps / OpenStreetMap integration</small>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-5">
    <div class="container">
        <div class="row justify-content-center text-center mb-5">
            <div class="col-lg-8">
                <h2 class="section-title mb-3">Frequently Asked Questions</h2>
                <div class="header-title-line mx-auto"></div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                What are your check-in and check-out times?
                            </button>
                        </h2>
                        <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Check-in is from 3:00 PM and check-out is until 12:00 PM. Early check-in and late check-out may be available upon request and subject to availability.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                Do you offer airport transportation?
                            </button>
                        </h2>
                        <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Yes, we provide luxury airport transfers. Please contact our concierge team to arrange your transportation in advance.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                What dining options are available?
                            </button>
                        </h2>
                        <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                We offer multiple dining venues including fine dining restaurants, casual cafes, and 24-hour room service. Please visit our Services page for more details.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/contact.blade.php ENDPATH**/ ?>