<?php $__env->startSection('title', $tier->meta_title ?? $tier->title); ?>

<?php $__env->startSection('meta_description', $tier->meta_description); ?>
<?php $__env->startSection('meta_keywords', $tier->meta_keywords); ?>
<?php $__env->startSection('meta_robots', $tier->meta_robots); ?>
<?php $__env->startSection('canonical_url', $tier->canonical_url); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-5">
    <!-- Header Section -->
    <section class="text-center mb-5">
        <h1 class="display-4 fw-bold"><?php echo e($tier->title); ?></h1>
        <?php if($tier->excerpt): ?>
        <div class="lead mt-3 mb-5 w-75 mx-auto">
            <?php echo e($tier->excerpt); ?>

        </div>
        <?php endif; ?>
          <?php if($tier->featured_image): ?>
        <div class="featured-image-container text-center mt-4 mb-5">
            <img src="<?php echo e(asset('storage/' . $tier->featured_image)); ?>" alt="<?php echo e($tier->featured_image_alt ?? $tier->title); ?>" class="img-fluid rounded shadow">
            <?php if($tier->featured_image_caption): ?>
            <div class="image-caption text-muted mt-2">
                <?php echo e($tier->featured_image_caption); ?>

            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </section>
    
    <!-- Member Tier Benefits Section -->
    <section class="member-benefits mb-5">
        <div class="text-center mb-5">
            <h2 class="section-title">Member Tier Benefits</h2>
            <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
            <p class="lead">Collect more points and greater privileges throughout your Jumeirah One journey from Member to Platinum.</p>
        </div>
          <!-- Tiers Plan Images Section -->
        
       
          <!-- Terms and Conditions Section -->
        <section class="mb-5">
            <div id="tier-terms" class="terms-section mb-5 py-5 px-4 bg-light rounded shadow-sm">
                <div class="terms-header text-center">
                    <h3 class="fw-semibold mb-3">Terms and Conditions</h3>
                    <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
                </div>                  <div class="terms-container">
                    <p class="text-center mb-4">Please review the following terms and conditions carefully:</p>
                    <div class="terms-content">
                        <div class="terms-full" style="display: none;">
                            <ul class="terms-list">
                                <li>Tier status is determined by the number of qualifying points earned during a calendar year.</li>
                                <li>Tier status is valid for one year from the date of qualification.</li>
                                <li>Tier benefits are subject to availability and may be changed or withdrawn at any time without notice.</li>
                                <li>Members must present their membership card or provide their membership number to avail tier benefits.</li>
                                <li>Tier benefits cannot be transferred to another member's account.</li>
                                <li>Tier benefits cannot be combined with other promotions or offers unless explicitly stated.</li>
                                <li>The LaLiT Loyalty program reserves the right to verify member identity before providing tier benefits.</li>
                                <li>Members must comply with all rules and regulations of The LaLiT Loyalty program.</li>
                                <li>The LaLiT Hotels and its affiliates are not responsible for any loss, injury, or damages arising from the use of tier benefits.</li>
                                <li>Additional terms and conditions may apply to specific tier benefits.</li>
                                <li>In case of any dispute, the decision of The LaLiT Hotels will be final and binding.</li>
                            </ul>
                        </div>
                        <div class="text-center mt-3">
                            <button id="btn-toggle-terms" class="btn btn-toggle-terms">Show More</button>
                        </div>
                    </div>
                </div>
            </div>
        </section>
</div>

<style>
    /* Featured Image Container - Center Image */
    .featured-image-container {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }
    
    .featured-image-container img {
        max-width: 80%;
        max-height: 400px;
        object-fit: cover;
        display: block;
        margin: 0 auto;
    }
    
    /* Tier Plans Image - Center and Full Width */
    .tier-plans-image {
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
    }
    
    .tier-plans-image img {
        width: 100%;
        object-fit: contain;
        margin: 0 auto;
    }
    
    /* Section Styles */
    .section-title {
        position: relative;
        padding-bottom: 0.75rem;
        margin-bottom: 1.5rem;
    }
    
    .section-title:after {
        content: '';
        position: absolute;
        left: 0;
        bottom: 0;
        width: 60px;
        height: 3px;
        background-color: #c6aa76;
    }
    
    /* Benefits Cards */
    .icon-wrapper {
        height: 80px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .icon-wrapper i {
        color: #c6aa76;
    }
    
    /* Qualification Steps */
    .qualification-step {
        display: flex;
        align-items: flex-start;
    }
    
    .step-number {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #c6aa76;
        color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        margin-right: 1rem;
        flex-shrink: 0;
    }
      /* Terms and Conditions */
    .terms-container {
        background-color: #f9f9f9;
        border-radius: 8px;
        padding: 2rem;
    }
    
    /* Terms and Conditions Styles */
    .terms-section {
        background-color: #f8f9fa;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .header-title-line {
        width: 60px;
        height: 3px;
        background-color: #c6aa76;
        margin: 0 auto 30px;
    }
      .terms-list {
        padding-left: 0;
        list-style-type: none;
    }
    
    .terms-list li {
        margin-bottom: 10px;
        line-height: 1.6;
    }
    
    .btn-toggle-terms {
        background-color: transparent;
        color: #c6aa76;
        border: 1px solid #c6aa76;
        padding: 8px 16px;
        border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-toggle-terms:hover {
        background-color: #c6aa76;
        color: white;
    }
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Bootstrap components if needed
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Terms and conditions show more/less toggle
        const btnToggleTerms = document.getElementById('btn-toggle-terms');
        const termsPreview = document.querySelector('.terms-preview');
        const termsFull = document.querySelector('.terms-full');
        
        if (btnToggleTerms) {
            btnToggleTerms.addEventListener('click', function() {
                if (termsFull.style.display === 'none') {
                    termsFull.style.display = 'block';
                    termsPreview.style.display = 'none';
                    btnToggleTerms.textContent = 'Show Less';
                } else {
                    termsFull.style.display = 'none';
                    termsPreview.style.display = 'block';
                    btnToggleTerms.textContent = 'Show More';
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tier', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/tiers.blade.php ENDPATH**/ ?>