<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">View Points</h1>
                    <div>
                        <a href="<?php echo e(route('admin.points.edit', $point)); ?>" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.points.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Points Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <th style="width: 200px;">Title:</th>
                                            <td><?php echo e($point->title); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Slug:</th>
                                            <td><?php echo e($point->slug); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Points Value:</th>
                                            <td><?php echo e($point->points_value); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Points Type:</th>
                                            <td><?php echo e($point->points_type); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Status:</th>
                                            <td>
                                                <span class="badge <?php echo e($point->status === 'published' ? 'bg-success' : ($point->status === 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                                                    <?php echo e(ucfirst($point->status)); ?>

                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Featured:</th>
                                            <td><?php echo e($point->is_featured ? 'Yes' : 'No'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Sort Order:</th>
                                            <td><?php echo e($point->sort_order); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Publish Date:</th>
                                            <td><?php echo e($point->published_at ? $point->published_at->format('M d, Y H:i') : 'Immediately'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Created:</th>
                                            <td><?php echo e($point->created_at->format('M d, Y H:i')); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Last Updated:</th>
                                            <td><?php echo e($point->updated_at->format('M d, Y H:i')); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-4">
                                <?php if($point->featured_image): ?>
                                    <div class="card mb-3">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Featured Image</h6>
                                        </div>
                                        <div class="card-body text-center">
                                            <img src="<?php echo e(asset('storage/' . $point->featured_image)); ?>" alt="<?php echo e($point->featured_image_alt ?? $point->title); ?>" class="img-fluid rounded" style="max-height: 200px;">
                                            <?php if($point->featured_image_caption): ?>
                                                <p class="text-muted mt-2 small"><?php echo e($point->featured_image_caption); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if($point->banner_image): ?>
                                    <div class="card">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Banner Image</h6>
                                        </div>
                                        <div class="card-body text-center">
                                            <img src="<?php echo e(asset('storage/' . $point->banner_image)); ?>" alt="<?php echo e($point->banner_image_alt ?? $point->title); ?>" class="img-fluid rounded" style="max-height: 200px;">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($point->excerpt): ?>
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h5 class="mb-0">Excerpt</h5>
                        </div>
                        <div class="card-body">
                            <p><?php echo e($point->excerpt); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Content</h5>
                    </div>
                    <div class="card-body">
                        <?php echo $point->content; ?>

                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">SEO Information</h5>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th style="width: 200px;">Meta Title:</th>
                                    <td><?php echo e($point->meta_title ?? $point->title); ?></td>
                                </tr>
                                <tr>
                                    <th>Meta Description:</th>
                                    <td><?php echo e($point->meta_description ?? $point->excerpt); ?></td>
                                </tr>
                                <tr>
                                    <th>Meta Keywords:</th>
                                    <td><?php echo e($point->meta_keywords); ?></td>
                                </tr>
                                <tr>
                                    <th>Meta Robots:</th>
                                    <td><?php echo e($point->meta_robots ?? 'index, follow'); ?></td>
                                </tr>
                                <tr>
                                    <th>Canonical URL:</th>
                                    <td><?php echo e($point->canonical_url ?? route('pages.points', $point->slug)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <div>
                        <?php if($point->author): ?>
                            <span class="text-muted">Created by: <?php echo e($point->author->name); ?></span>
                        <?php endif; ?>
                    </div>
                    <div>
                        <form action="<?php echo e(route('admin.points.destroy', $point)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this point? This action cannot be undone.');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .table th {
        background-color: #f8f9fa;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mwsserverco/public_html/loyalitylalit.mwsserver.co.in/resources/views/admin/points/show.blade.php ENDPATH**/ ?>