<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;

class ArtisanController extends Controller
{
    /**
     * Show the artisan commands interface
     */
    public function index()
    {
        return view('admin.artisan.index');
    }

    /**
     * Clear application cache
     */
    public function clearCache()
    {
        try {
            Artisan::call('cache:clear');
            $output = Artisan::output();
            
            return back()->with('success', 'Application cache cleared successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to clear cache: ' . $e->getMessage());
            return back()->with('error', 'Failed to clear cache: ' . $e->getMessage());
        }
    }

    /**
     * Clear config cache
     */
    public function clearConfig()
    {
        try {
            Artisan::call('config:clear');
            $output = Artisan::output();
            
            return back()->with('success', 'Configuration cache cleared successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to clear config cache: ' . $e->getMessage());
            return back()->with('error', 'Failed to clear config cache: ' . $e->getMessage());
        }
    }

    /**
     * Clear route cache
     */
    public function clearRoute()
    {
        try {
            Artisan::call('route:clear');
            $output = Artisan::output();
            
            return back()->with('success', 'Route cache cleared successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to clear route cache: ' . $e->getMessage());
            return back()->with('error', 'Failed to clear route cache: ' . $e->getMessage());
        }
    }

    /**
     * Clear view cache
     */
    public function clearView()
    {
        try {
            Artisan::call('view:clear');
            $output = Artisan::output();
            
            return back()->with('success', 'View cache cleared successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to clear view cache: ' . $e->getMessage());
            return back()->with('error', 'Failed to clear view cache: ' . $e->getMessage());
        }
    }

    /**
     * Create storage link
     */
    public function storageLink()
    {
        try {
            Artisan::call('storage:link');
            $output = Artisan::output();
            
            return back()->with('success', 'Storage link created successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to create storage link: ' . $e->getMessage());
            return back()->with('error', 'Failed to create storage link: ' . $e->getMessage());
        }
    }

    /**
     * Cache config
     */
    public function cacheConfig()
    {
        try {
            Artisan::call('config:cache');
            $output = Artisan::output();
            
            return back()->with('success', 'Configuration cached successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to cache config: ' . $e->getMessage());
            return back()->with('error', 'Failed to cache config: ' . $e->getMessage());
        }
    }

    /**
     * Cache routes
     */
    public function cacheRoute()
    {
        try {
            Artisan::call('route:cache');
            $output = Artisan::output();
            
            return back()->with('success', 'Routes cached successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to cache routes: ' . $e->getMessage());
            return back()->with('error', 'Failed to cache routes: ' . $e->getMessage());
        }
    }

    /**
     * Run migrations
     */
    public function migrate()
    {
        try {
            Artisan::call('migrate', ['--force' => true]);
            $output = Artisan::output();
            
            return back()->with('success', 'Database migrations run successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to run migrations: ' . $e->getMessage());
            return back()->with('error', 'Failed to run migrations: ' . $e->getMessage());
        }
    }

    /**
     * Optimize application
     */
    public function optimize()
    {
        try {
            Artisan::call('optimize');
            $output = Artisan::output();
            
            return back()->with('success', 'Application optimized successfully!')
                        ->with('output', $output);
        } catch (\Exception $e) {
            Log::error('Failed to optimize application: ' . $e->getMessage());
            return back()->with('error', 'Failed to optimize application: ' . $e->getMessage());
        }
    }

    /**
     * Clear all caches (combined command)
     */
    public function clearAll()
    {
        try {
            $commands = [
                'cache:clear',
                'config:clear',
                'route:clear',
                'view:clear'
            ];

            $outputs = [];
            foreach ($commands as $command) {
                Artisan::call($command);
                $outputs[] = $command . ': ' . trim(Artisan::output());
            }
            
            return back()->with('success', 'All caches cleared successfully!')
                        ->with('output', implode("\n", $outputs));
        } catch (\Exception $e) {
            Log::error('Failed to clear all caches: ' . $e->getMessage());
            return back()->with('error', 'Failed to clear all caches: ' . $e->getMessage());
        }
    }
}
