<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Member;
use Illuminate\Http\Request;

class MemberController extends Controller
{
    /**
     * Display a listing of members.
     */
    public function index(Request $request)
    {
        $query = Member::query();

        // Search functionality
        if ($request->has('search') && $request->search) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('first_name', 'like', "%{$search}%")
                  ->orWhere('last_name', 'like', "%{$search}%")
                  ->orWhere('email', 'like', "%{$search}%")
                  ->orWhere('member_number', 'like', "%{$search}%")
                  ->orWhere('mobile', 'like', "%{$search}%");
            });
        }

        // Filter by status
        if ($request->has('status') && $request->status) {
            $query->where('status', $request->status);
        }

        // Filter by tier
        if ($request->has('tier') && $request->tier) {
            $query->where('tier', $request->tier);
        }

        // Order by latest
        $members = $query->orderBy('created_at', 'desc')->paginate(20);

        // Get unique tiers for filter
        $tiers = Member::distinct()->pluck('tier')->filter();

        return view('admin.members.index', compact('members', 'tiers'));
    }

    /**
     * Display the specified member.
     */
    public function show(Member $member)
    {
        return view('admin.members.show', compact('member'));
    }

    /**
     * Remove the specified member from storage.
     */
    public function destroy(Member $member)
    {
        $memberName = $member->full_name;
        $member->delete();

        return redirect()->route('admin.members.index')
            ->with('success', "Member '{$memberName}' has been deleted successfully.");
    }
}
