<?php

namespace App\Http\Controllers\Membership;

use App\Http\Controllers\Controller;
use App\Models\Member;
use Illuminate\Support\Facades\Session;

class ManageCardController extends Controller
{
  public function showManageCard()
  {
    // Get member ID from session
    $memberId = Session::get('member_id');
    $memberNumber = Session::get('member_number');
    $memberName = Session::get('member_name');
    
    // Initialize member data
    $membershipUser = [
      'membership_number' => $memberNumber ?? 'N/A',
      'name' => $memberName ?? 'Member',
      'tier' => 'BLUE',
      'tier_data' => []
    ];
    
    // Fetch member data from database if available
    if ($memberId) {
      $member = Member::find($memberId);
      if ($member) {
        $membershipUser = [
          'membership_number' => $member->member_number ?? $memberNumber,
          'name' => $member->full_name ?? $memberName,
          'tier' => $member->tier ?? 'BLUE',
          'tier_data' => $member->tier_data ?? []
        ];
      }
    }
    
    return view('membership.manage-card', compact('membershipUser'));
  }
}