<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DonationImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'asset_image_id',
        'url',
        'fileName',
        'contentType',
        'size',
        'image_width',
        'image_height',
    ];

    /**
     * Indicates if the model should be timestamped.
     */
    public $timestamps = false;

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * Get the donation that owns this image.
     */
    public function donation()
    {
        return $this->belongsTo(Donation::class, 'asset_image_id', 'image');
    }
}
