<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ManageHome extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'section_1',
        'section_2',
        'section_3',
        'section_4',
        'section_5',
        'banner_img',
        'status',
    ];

    /**
     * The attributes that should be cast.
     * 
     * @var array<string, string>
     */
    protected $casts = [
        'section_1' => 'array',
        'section_2' => 'array',
        'section_3' => 'array',
        'section_4' => 'array',
        'section_5' => 'array',
        'status' => 'boolean',
    ];

    /**
     * Scope a query to only include active records.
     */
    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    /**
     * Scope a query to only include inactive records.
     */
    public function scopeInactive($query)
    {
        return $query->where('status', false);
    }
}
