<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Membership API Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for third-party membership API integration
    | Used for login, registration, points management, etc.
    |
    */
    'membership_api' => [
        'base_url' => env('MEMBERSHIP_API_URL', 'https://api.membership-service.com/v1'),
        'key' => env('MEMBERSHIP_API_KEY'),
        'secret' => env('MEMBERSHIP_API_SECRET'),
        'timeout' => env('MEMBERSHIP_API_TIMEOUT', 30),
        'retry_attempts' => env('MEMBERSHIP_API_RETRY_ATTEMPTS', 3),
        'cache_ttl' => env('MEMBERSHIP_API_CACHE_TTL', 300), // 5 minutes
    ],

];
