<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->text('hotel_stays_content')->nullable()->after('content');
            $table->text('dining_content')->nullable()->after('hotel_stays_content');
            $table->text('spa_content')->nullable()->after('dining_content');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn(['hotel_stays_content', 'dining_content', 'spa_content']);
        });
    }
};
