<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->string('hotel_stays_link')->nullable()->after('hotel_stays_content');
            $table->string('dining_link')->nullable()->after('dining_content');
            $table->string('spa_link')->nullable()->after('spa_content');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn(['hotel_stays_link', 'dining_link', 'spa_link']);
        });
    }
};
