<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('membership_api_tokens', function (Blueprint $table) {
            $table->id();
            $table->string('token_type')->default('Bearer'); // Token type (Bearer, etc.)
            $table->text('access_token'); // The actual token
            $table->text('refresh_token')->nullable(); // Refresh token if available
            $table->integer('expires_in'); // Expiration time in seconds
            $table->timestamp('expires_at'); // Calculated expiration timestamp
            $table->string('scope')->nullable(); // Token scope/permissions
            $table->json('metadata')->nullable(); // Additional token metadata
            $table->boolean('is_active')->default(true); // Whether token is currently active
            $table->timestamp('last_used_at')->nullable(); // When token was last used
            $table->timestamps();
            
            // Index for faster token lookups
            $table->index(['is_active', 'expires_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('membership_api_tokens');
    }
};
