@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">{{ $charity->name }}</h1>
                    <div>
                        <a href="{{ route('admin.charities.edit', $charity) }}" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.charities.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Charities
                        </a>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <!-- Basic Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Basic Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Name:</strong></div>
                                    <div class="col-sm-9">{{ $charity->name }}</div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Slug:</strong></div>
                                    <div class="col-sm-9">{{ $charity->slug }}</div>
                                </div>
                                @if($charity->description)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Description:</strong></div>
                                    <div class="col-sm-9">{{ $charity->description }}</div>
                                </div>
                                @endif
                                @if($charity->website_url)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Website:</strong></div>
                                    <div class="col-sm-9">
                                        <a href="{{ $charity->website_url }}" target="_blank" rel="noopener" class="btn btn-sm btn-outline-primary">
                                            {{ $charity->website_url }} <i class="fas fa-external-link-alt ms-1"></i>
                                        </a>
                                    </div>
                                </div>
                                @endif
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Status:</strong></div>
                                    <div class="col-sm-9">
                                        <span class="badge bg-{{ $charity->status === 'active' ? 'success' : 'secondary' }}">
                                            {{ ucfirst($charity->status) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Sort Order:</strong></div>
                                    <div class="col-sm-9">{{ $charity->sort_order }}</div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Featured:</strong></div>
                                    <div class="col-sm-9">
                                        @if($charity->is_featured)
                                            <span class="badge bg-warning">Yes</span>
                                        @else
                                            <span class="text-muted">No</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Created:</strong></div>
                                    <div class="col-sm-9">{{ $charity->created_at->format('F j, Y \a\t g:i A') }}</div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Last Updated:</strong></div>
                                    <div class="col-sm-9">{{ $charity->updated_at->format('F j, Y \a\t g:i A') }}</div>
                                </div>
                            </div>
                        </div>

                        <!-- SEO Information -->
                        @if($charity->meta_title || $charity->meta_description || $charity->meta_keywords || $charity->canonical_url)
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">SEO Information</h5>
                            </div>
                            <div class="card-body">
                                @if($charity->meta_title)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Meta Title:</strong></div>
                                    <div class="col-sm-9">{{ $charity->meta_title }}</div>
                                </div>
                                @endif
                                @if($charity->meta_description)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Meta Description:</strong></div>
                                    <div class="col-sm-9">{{ $charity->meta_description }}</div>
                                </div>
                                @endif
                                @if($charity->meta_keywords)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Meta Keywords:</strong></div>
                                    <div class="col-sm-9">{{ $charity->meta_keywords }}</div>
                                </div>
                                @endif
                                @if($charity->canonical_url)
                                <div class="row mb-3">
                                    <div class="col-sm-3"><strong>Canonical URL:</strong></div>
                                    <div class="col-sm-9">
                                        <a href="{{ $charity->canonical_url }}" target="_blank" rel="noopener">
                                            {{ $charity->canonical_url }}
                                        </a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        @endif
                    </div>

                    <div class="col-md-4">
                        <!-- Logo -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Logo</h5>
                            </div>
                            <div class="card-body text-center">
                                @if($charity->logo && Storage::disk('public')->exists($charity->logo))
                                    <img src="{{ Storage::url($charity->logo) }}" 
                                         alt="{{ $charity->logo_alt ?? $charity->name }}" 
                                         class="img-fluid rounded shadow" 
                                         style="max-width: 100%;">
                                    @if($charity->logo_alt)
                                    <div class="mt-2">
                                        <small class="text-muted">Alt Text: {{ $charity->logo_alt }}</small>
                                    </div>
                                    @endif
                                @else
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="height: 200px;">
                                        <div class="text-center">
                                            <i class="fas fa-heart fa-3x text-muted mb-2"></i>
                                            <p class="text-muted mb-0">No logo uploaded</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Actions</h5>
                            </div>
                            <div class="card-body">
                                <a href="{{ route('charity.show', $charity) }}" 
                                   class="btn btn-success w-100 mb-2" 
                                   target="_blank" rel="noopener">
                                    <i class="fas fa-eye"></i> View on Frontend
                                </a>
                                <a href="{{ route('admin.charities.edit', $charity) }}" 
                                   class="btn btn-primary w-100 mb-2">
                                    <i class="fas fa-edit"></i> Edit Charity
                                </a>
                                <form action="{{ route('admin.charities.destroy', $charity) }}" 
                                      method="POST" 
                                      onsubmit="return confirm('Are you sure you want to delete this charity?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="fas fa-trash"></i> Delete Charity
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
