@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Members</h1>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <!-- Search and Filters -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.members.index') }}" class="row g-3">
                            <div class="col-md-4">
                                <label for="search" class="form-label">Search</label>
                                <input type="text" class="form-control" id="search" name="search" 
                                       value="{{ request('search') }}" 
                                       placeholder="Name, email, member number, mobile...">
                            </div>
                            <div class="col-md-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="">All Statuses</option>
                                    <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    <option value="suspended" {{ request('status') === 'suspended' ? 'selected' : '' }}>Suspended</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="tier" class="form-label">Tier</label>
                                <select class="form-select" id="tier" name="tier">
                                    <option value="">All Tiers</option>
                                    @foreach($tiers as $tier)
                                        @if($tier)
                                            <option value="{{ $tier }}" {{ request('tier') === $tier ? 'selected' : '' }}>
                                                {{ ucfirst($tier) }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                            </div>
                        </form>
                        @if(request()->hasAny(['search', 'status', 'tier']))
                            <div class="mt-2">
                                <a href="{{ route('admin.members.index') }}" class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-times"></i> Clear Filters
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Members Count -->
                <div class="mb-3">
                    <p class="text-muted">
                        <strong>Total Members:</strong> {{ $members->total() }}
                        @if(request()->hasAny(['search', 'status', 'tier']))
                            (filtered)
                        @endif
                    </p>
                </div>

                @if($members->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Member #</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Mobile</th>
                                    <th>Tier</th>
                                    <th>Status</th>
                                    <th>Joined</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($members as $member)
                                <tr>
                                    <td>
                                        <code>{{ $member->member_number ?? 'N/A' }}</code>
                                    </td>
                                    <td>
                                        <strong>{{ $member->full_name }}</strong>
                                        @if($member->email_verified)
                                            <i class="fas fa-check-circle text-success ms-1" title="Email Verified"></i>
                                        @endif
                                    </td>
                                    <td>
                                        <small>{{ $member->email }}</small>
                                    </td>
                                    <td>
                                        <small>{{ $member->mobile ?? 'N/A' }}</small>
                                    </td>
                                    <td>
                                        @if($member->tier)
                                            <span class="badge bg-info">{{ ucfirst($member->tier) }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($member->status === 'active')
                                            <span class="badge bg-success">Active</span>
                                        @elseif($member->status === 'inactive')
                                            <span class="badge bg-secondary">Inactive</span>
                                        @elseif($member->status === 'suspended')
                                            <span class="badge bg-danger">Suspended</span>
                                        @else
                                            <span class="badge bg-secondary">{{ ucfirst($member->status) }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small>{{ $member->created_at->format('M d, Y') }}</small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.members.show', $member) }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <form action="{{ route('admin.members.destroy', $member) }}" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('Are you sure you want to delete this member? This action cannot be undone.')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-danger" 
                                                        title="Delete Member">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $members->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5>No Members Found</h5>
                        <p class="text-muted">
                            @if(request()->hasAny(['search', 'status', 'tier']))
                                No members match your search criteria. Try adjusting your filters.
                            @else
                                There are no members registered yet.
                            @endif
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    .table td {
        vertical-align: middle;
    }
    code {
        background-color: #f8f9fa;
        padding: 2px 6px;
        border-radius: 3px;
        color: #d63384;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@endpush
