@extends('layouts.admin')

@section('content')
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">
                        <i class="fas fa-key me-2"></i>Membership API Tokens
                    </h1>
                    <div>
                        <form method="POST" action="{{ route('admin.membership-api-tokens.generate') }}" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-primary me-2" 
                                    onclick="return confirm('Generate a new API token? This will deactivate all existing tokens.')">
                                <i class="fas fa-plus me-1"></i>Generate New Token
                            </button>
                        </form>
                        <form method="POST" action="{{ route('admin.membership-api-tokens.cleanup') }}" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-outline-secondary" 
                                    onclick="return confirm('Clean up all expired tokens?')">
                                <i class="fas fa-trash-alt me-1"></i>Cleanup Expired
                            </button>
                        </form>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <!-- Current Active Token -->
                @if($currentToken)
                    <div class="card mb-4 border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-check-circle me-2"></i>Current Active Token
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-2">
                                        <strong>Token Type:</strong> 
                                        <span class="badge bg-primary">{{ $currentToken->token_type }}</span>
                                    </p>
                                    <p class="mb-2">
                                        <strong>Access Token:</strong>
                                        <code class="text-break">{{ substr($currentToken->access_token, 0, 50) }}...</code>
                                    </p>
                                    @if($currentToken->refresh_token)
                                        <p class="mb-2">
                                            <strong>Has Refresh Token:</strong> 
                                            <span class="badge bg-info">Yes</span>
                                        </p>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-2">
                                        <strong>Created:</strong> {{ $currentToken->created_at->format('M d, Y h:i A') }}
                                    </p>
                                    <p class="mb-2">
                                        <strong>Expires:</strong> 
                                        <span class="{{ $currentToken->expires_at->isFuture() ? 'text-success' : 'text-danger' }}">
                                            {{ $currentToken->expires_at->format('M d, Y h:i A') }}
                                            ({{ $currentToken->expires_at->diffForHumans() }})
                                        </span>
                                    </p>
                                    @if($currentToken->last_used_at)
                                        <p class="mb-2">
                                            <strong>Last Used:</strong> {{ $currentToken->last_used_at->diffForHumans() }}
                                        </p>
                                    @endif
                                    <p class="mb-0">
                                        <strong>Status:</strong>
                                        <span class="badge {{ $currentToken->isValid() ? 'bg-success' : 'bg-danger' }}">
                                            {{ $currentToken->isValid() ? 'Valid' : 'Expired' }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <div class="mt-3">
                                <form method="POST" action="{{ route('admin.membership-api-tokens.refresh') }}" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-warning" 
                                            onclick="return confirm('Refresh the current token?')">
                                        <i class="fas fa-sync-alt me-1"></i>Refresh Token
                                    </button>
                                </form>
                                <form method="POST" action="{{ route('admin.membership-api-tokens.deactivate', $currentToken->id) }}" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-danger" 
                                            onclick="return confirm('Deactivate this token?')">
                                        <i class="fas fa-ban me-1"></i>Deactivate
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="alert alert-warning" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>No active token found.</strong> Click "Generate New Token" to create one.
                    </div>
                @endif

                <!-- Token History -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-history me-2"></i>Token History
                        </h5>
                    </div>
                    <div class="card-body">
                        @if($tokens->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Token Type</th>
                                            <th>Access Token</th>
                                            <th>Created</th>
                                            <th>Expires</th>
                                            <th>Last Used</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($tokens as $token)
                                            <tr class="{{ $token->is_active && !$token->isExpired() ? 'table-success' : '' }}">
                                                <td>{{ $token->id }}</td>
                                                <td>
                                                    <span class="badge bg-secondary">{{ $token->token_type }}</span>
                                                </td>
                                                <td>
                                                    <code class="text-break" style="font-size: 0.85rem;">
                                                        {{ substr($token->access_token, 0, 30) }}...
                                                    </code>
                                                </td>
                                                <td>{{ $token->created_at->format('M d, Y h:i A') }}</td>
                                                <td>
                                                    <span class="{{ $token->expires_at->isFuture() ? 'text-success' : 'text-danger' }}">
                                                        {{ $token->expires_at->format('M d, Y h:i A') }}
                                                    </span>
                                                </td>
                                                <td>
                                                    @if($token->last_used_at)
                                                        {{ $token->last_used_at->diffForHumans() }}
                                                    @else
                                                        <span class="text-muted">Never</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($token->is_active)
                                                        @if($token->isExpired())
                                                            <span class="badge bg-warning">Active (Expired)</span>
                                                        @else
                                                            <span class="badge bg-success">Active</span>
                                                        @endif
                                                    @else
                                                        <span class="badge bg-secondary">Inactive</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($token->is_active)
                                                        <form method="POST" action="{{ route('admin.membership-api-tokens.deactivate', $token->id) }}" class="d-inline">
                                                            @csrf
                                                            <button type="submit" class="btn btn-sm btn-danger" 
                                                                    onclick="return confirm('Deactivate this token?')">
                                                                <i class="fas fa-ban"></i>
                                                            </button>
                                                        </form>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <!-- Pagination -->
                            <div class="mt-3">
                                {{ $tokens->links() }}
                            </div>
                        @else
                            <div class="alert alert-info mb-0">
                                <i class="fas fa-info-circle me-2"></i>No tokens found in the database.
                            </div>
                        @endif
                    </div>
                </div>

                <!-- API Configuration Info -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-cog me-2"></i>API Configuration
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-2">
                                    <strong>Base URL:</strong> 
                                    <code>{{ config('membership_api.base_url') }}</code>
                                </p>
                                <p class="mb-2">
                                    <strong>Timeout:</strong> 
                                    <code>{{ config('membership_api.timeout') }} seconds</code>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-2">
                                    <strong>Username:</strong> 
                                    <code>{{ config('membership_api.username') ? '***' : 'Not set' }}</code>
                                </p>
                                <p class="mb-2">
                                    <strong>API Key:</strong> 
                                    <code>{{ config('membership_api.key') ? '***' : 'Not set' }}</code>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
