<!-- Name -->
<div class="mb-3">
    <label for="name" class="form-label">Slide Name <span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $slide->name ?? '') }}" required>
    @error('name')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Description -->
<div class="mb-3">
    <label for="description" class="form-label">Description</label>
    <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $slide->description ?? '') }}</textarea>
    <div class="form-text">A short description that will appear with the slide (optional)</div>
    @error('description')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Image Upload -->
<div class="mb-3">
    <label for="image" class="form-label">
        Slide Image {{ isset($slide) ? '(leave empty to keep current)' : '' }} <span class="text-danger">{{ !isset($slide) ? '*' : '' }}</span>
    </label>
    <input type="file" class="form-control" id="image" name="image" accept="image/*" {{ !isset($slide) ? 'required' : '' }}>
    <div class="form-text">Accepted formats: JPEG, PNG, JPG, GIF, WebP. Max size: 2MB. Recommended size: 1920x700px</div>
    @error('image')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Image Alt Text -->
<div class="mb-3">
    <label for="image_alt" class="form-label">Image Alt Text</label>
    <input type="text" class="form-control" id="image_alt" name="image_alt" value="{{ old('image_alt', $slide->image_alt ?? '') }}">
    <div class="form-text">Describe the image for accessibility (for screen readers)</div>
    @error('image_alt')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Link Section -->
<hr>
<h5 class="mb-3">Link Settings (Optional)</h5>

<!-- Link URL -->
<div class="mb-3">
    <label for="link_url" class="form-label">Link URL</label>
    <input type="url" class="form-control" id="link_url" name="link_url" value="{{ old('link_url', $slide->link_url ?? '') }}">
    <div class="form-text">Optional URL if you want this slide to link somewhere</div>
    @error('link_url')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Link Text -->
<div class="mb-3">
    <label for="link_text" class="form-label">Link Text</label>
    <input type="text" class="form-control" id="link_text" name="link_text" value="{{ old('link_text', $slide->link_text ?? '') }}">
    <div class="form-text">Text to display on the button (required if URL is provided)</div>
    @error('link_text')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<!-- Open in New Tab -->
<div class="mb-3 form-check">
    <input type="checkbox" class="form-check-input" id="link_new_tab" name="link_new_tab" value="1" 
           {{ old('link_new_tab', $slide->link_new_tab ?? false) ? 'checked' : '' }}>
    <label class="form-check-label" for="link_new_tab">Open link in new tab</label>
    @error('link_new_tab')
        <div class="text-danger mt-1">{{ $message }}</div>
    @enderror
</div>

<hr class="my-4">

<div class="row">
    <!-- Status -->
    <div class="col-md-6 mb-3">
        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
        <select class="form-select" id="status" name="status" required>
            <option value="active" {{ old('status', $slide->status ?? 'active') == 'active' ? 'selected' : '' }}>Active</option>
            <option value="inactive" {{ old('status', $slide->status ?? '') == 'inactive' ? 'selected' : '' }}>Inactive</option>
        </select>
        @error('status')
            <div class="text-danger mt-1">{{ $message }}</div>
        @enderror
    </div>

    <!-- Sort Order -->
    <div class="col-md-6 mb-3">
        <label for="sort_order" class="form-label">Sort Order <span class="text-danger">*</span></label>
        <input type="number" class="form-control" id="sort_order" name="sort_order" 
               value="{{ old('sort_order', $slide->sort_order ?? 0) }}" min="0" required>
        <div class="form-text">Lower numbers appear first in the slider</div>
        @error('sort_order')
            <div class="text-danger mt-1">{{ $message }}</div>
        @enderror
    </div>
</div>
