@extends('layouts.admin')

@section('content')
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h1 class="h3 mb-0">View Slide: {{ $slide->name }}</h1>
                        <div>
                            <a href="{{ route('admin.slides.edit', $slide) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <a href="{{ route('admin.slides.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to Slides
                            </a>
                        </div>
                    </div>

                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card mb-4">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <span>Slide Details</span>
                                    <span class="badge {{ $slide->status == 'active' ? 'bg-success' : 'bg-secondary' }}">
                                        {{ ucfirst($slide->status) }}
                                    </span>
                                </div>
                                <div class="card-body">
                                    <!-- Slide Preview -->
                                    <div class="mb-4">
                                        <h5>Preview</h5>
                                        <div class="position-relative">
                                            <img src="{{ $slide->image_url }}" alt="{{ $slide->image_alt ?: $slide->name }}"
                                                class="img-fluid rounded">
                                            @if ($slide->link_url && $slide->link_text)
                                                <div class="position-absolute bottom-0 start-0 p-3">
                                                    <span class="bg-dark bg-opacity-75 text-white px-3 py-2 rounded">
                                                        {{ $slide->link_text }}
                                                    </span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <h5>Basic Information</h5>
                                            <table class="table table-striped">
                                                <tbody>
                                                    <tr>
                                                        <th>Name</th>
                                                        <td>{{ $slide->name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Description</th>
                                                        <td>{{ $slide->description ?: 'No description provided' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Image Alt Text</th>
                                                        <td>{{ $slide->image_alt ?: 'No alt text provided' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Status</th>
                                                        <td>
                                                            <span
                                                                class="badge {{ $slide->status === 'active' ? 'bg-success' : 'bg-secondary' }}">
                                                                {{ ucfirst($slide->status) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Sort Order</th>
                                                        <td>{{ $slide->sort_order }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                        <div class="col-md-6">
                                            <h5>Link Information</h5>
                                            <table class="table table-striped">
                                                <tbody>
                                                    <tr>
                                                        <th>Link URL</th>
                                                        <td>
                                                            @if ($slide->link_url)
                                                                <a href="{{ $slide->link_url }}"
                                                                    target="{{ $slide->link_target }}"
                                                                    class="text-primary">
                                                                    {{ $slide->link_url }}
                                                                </a>
                                                            @else
                                                                <span class="text-muted">No link URL provided</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Link Text</th>
                                                        <td>{{ $slide->link_text ?: 'No link text provided' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Open in New Tab</th>
                                                        <td>{{ $slide->link_new_tab ? 'Yes' : 'No' }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <hr class="my-4">

                                    <div class="row">
                                        <div class="col-12">
                                            <h5>Timestamps</h5>
                                            <table class="table table-sm">
                                                <tbody>
                                                    <tr>
                                                        <th style="width: 150px;">Created</th>
                                                        <td>{{ $slide->created_at->format('F j, Y g:i A') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>Last Updated</th>
                                                        <td>{{ $slide->updated_at->format('F j, Y g:i A') }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <form method="POST" action="{{ route('admin.slides.destroy', $slide) }}"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger"
                                            onclick="return confirm('Are you sure you want to delete this slide?')">
                                            <i class="fas fa-trash"></i> Delete Slide
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <span>Quick Actions</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('admin.slides.edit', $slide) }}" class="btn btn-primary">
                                            <i class="fas fa-edit"></i> Edit Slide
                                        </a>
                                        <a href="{{ route('admin.slides.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-list"></i> All Slides
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
@endpush
