@extends('layouts.pages')

@section('title', 'Home - The LaLiT Hotels')

@section('nav-home', 'active')

@php
use Illuminate\Support\Facades\Storage;
// Helper function to clean content
function cleanContent($content)
{
if (!$content) {
return '';
}

// Remove Quill's syntax highlighting wrapper if present
$content = preg_replace('/<pre class="ql-syntax"[^>]*>(.*?)<\/pre>/s', '$1', $content);
    // Decode HTML entities that might have been escaped
    $content = html_entity_decode($content, ENT_QUOTES, 'UTF-8');
    // Remove excessive empty paragraphs
    $content = preg_replace('/<p><br><\/p>/', '', $content);
    $content = preg_replace('/<p><\/p>/', '', $content);

        return $content;
    }
@endphp

@section('hero')
    <!-- Hero Banner -->
    <div class="hero-banner position-relative">
        <div class="hero-image">
            @if ($homeData->banner_img)
                <img src="{{ Storage::url($homeData->banner_img) }}" class="w-100" alt="Hero Background"
                    style="height: 38.563rem; object-fit: cover;">
            @else
                <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_hero-image.jpg?h=823&w=1920&revision=1c3520c3-04aa-43f6-a8ef-f4e5ec988a4b"
                    class="w-100" alt="Hero Background" style="height: 38.563rem; object-fit: cover;">
            @endif
        </div>
        <!-- Hero Overlay -->
        <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100"
            style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.6) 100%);">
        </div>
    </div>
@endsection

@section('content')
    <!-- Start Benefits of Being a Member Section -->
    <section class="py-5 text-center">
        <div class="container">
            @if ($homeData && $homeData->section_1 && isset($homeData->section_1['content']))
                {!! cleanContent($homeData->section_1['content']) !!}

                <div class="mt-4">
                    <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
                        <a href="#" class="btn btn-lg px-2 py-1"
                            style="background-color: #000; color: #fff; border-color: #000;">Join Now</a>
                        <a href="{{ route('login') }}" class="btn btn-lg px-2 py-1"
                            style="background-color: #000; color: #fff; border-color: #000;">Already a member - Sign in</a>
                    </div>
                </div>
            @else
                <h2 class="section-title mb-3">Unlock Exclusive Benefits as a Member</h2>
                <div class="header-title-line tagline-line"></div>
                <p class="section-subtitle mb-5 mt-3">
                    As a member of The LaLiT Loyalty program, you'll enjoy a world of exclusive privileges designed to
                    enhance your lifestyle. From priority access to personalized services, rewarding stays, and
                    unforgettable hospitality, every moment with us becomes more special.
                </p>

                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_collect-points-with-every-stay.jpg?h=1280&w=960&revision=3ca4a1f1-6e46-4735-816f-c843e40fb6bd"
                                    alt="Pool" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h5>EARN POINTS</h5>
                            <p>Collect points for every spend from your first day as a member.</p>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-homememberonly-offers960x1280desktop.jpg?h=1280&w=960&revision=65ad2f2a-6273-4284-9944-9378375666e9"
                                    alt="Food" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h5>MEMBER ONLY OFFERS</h5>
                            <p>Discover specially curated offers and privileges designed only for the members.</p>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_exchange-points-across-the-globe.jpg?h=1280&w=960&revision=faf02a36-34fb-41b6-8afb-ea1057bf6268"
                                    alt="Relaxing" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h5>REDEEM POINTS</h5>
                            <p>Use your points for stays, dining, spa treatments and more.</p>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
                        <a href="#" class="ct-btn btn-lg">Join Now</a>
                        <a href="{{ route('login') }}" class="ct-btn btn-lg">Already a member - Sign in</a>
                    </div>
                </div>
            @endif
        </div>
    </section>
    <!-- End Benefits of Being a Member Section -->

    <!-- Start The LaLiT Loyalty Section -->
    <section class="py-5 text-center mt-5">
        <div class="container">
            @if ($homeData && $homeData->section_2 && isset($homeData->section_2['content']))
                <div class="section-2">
                    {!! cleanContent($homeData->section_2['content']) !!}
                </div>
            @else
                <h2 class="section-title mb-3">The LaLiT Rewards mage</h2>
                <div class="header-title-line tagline-line"></div>
                <p class="section-subtitle mb-5 mt-3">
                    One Program, Endless Possibilities
                </p>

                <div class="row g-4">
                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="/images/sub-1.png" alt="Luxury Suite" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>ACCOMMODATION</h6>
                            <p>Experience unparalleled comfort in our meticulously designed suites and rooms with
                                breathtaking views.</p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="/images/sub-2.png" alt="Fine Dining" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>DINING</h6>
                            <p>Savor exceptional culinary experiences crafted by renowned chefs in our award-winning
                                restaurants.</p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="/images/sub-3.png" alt="Spa Wellness" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>WELLNESS</h6>
                            <p>Rejuvenate your mind and body with our comprehensive wellness treatments and spa facilities.
                            </p>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="/images/sub-4.png" alt="Private Beach" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>RECREATION</h6>
                            <p>Enjoy premium recreational facilities including private beach access and personalized
                                experiences.</p>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <a href="#" class="ct-btn btn-lg">Discover More</a>
                </div>
            @endif
        </div>
    </section>
    <!-- End The LaLiT Loyalty Section -->

    <!-- Start Donate Points Section -->
    <section class="py-5">
        <div class="container">
            @if ($homeData && $homeData->section_4 && isset($homeData->section_4['content']))
                <div class="section-4">
                    {!! cleanContent($homeData->section_4['content']) !!}
                </div>
            @else
                <div class="row align-items-center g-5">
                    <div class="col-lg-8">
                        <div class="image-wrapper">
                            <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_collecting-points.jpg?h=960&w=1280&revision=4cc47f86-e4df-46da-8f11-dc6b631e9d7e"
                                alt="Luxury Hotel Experience" class="img-fluid rounded shadow-lg">
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="content-wrapper">
                            <h2 class="section-title mb-4">Earn points</h2>
                            <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                            <p class="mb-4">
                                Start earning The LaLiT Loyalty points when you enroll as a member. Earn points on any
                                eligible spend at any of our Hotels, Resorts and Palaces.
                            </p>
                            <div class="mt-4">
                                <a href="#" class="ct-btn btn-lg">
                                    More Details
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
    <!-- End Donate Points Section -->

    <section class="py-5">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4">Redeem points</h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            Redeem points for luxury experiences or donate to make a real-world difference. With us, loyalty
                            is not just rewarding – it is meaningful.
                        </p>
                        <div class="mt-4">
                            <a href="#" class="ct-btn btn-lg">
                                More Details
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_collecting-points.jpg?h=960&w=1280&revision=4cc47f86-e4df-46da-8f11-dc6b631e9d7e"
                            alt="Luxury Hotel Experience" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_collecting-points.jpg?h=960&w=1280&revision=4cc47f86-e4df-46da-8f11-dc6b631e9d7e"
                            alt="Luxury Hotel Experience" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4">Donate points</h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            Share the joy. Use your points to make a difference.
                        </p>
                        <div class="mt-4">
                            <a href="#" class="ct-btn btn-lg">
                                More Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Start Membership Tiers Section -->
    <section class="py-5 text-center" style="background-color: #f5f0eb;">
        <div class="container">
            @if ($homeData && $homeData->section_3 && isset($homeData->section_3['content']))
                <div class="section-3">
                    {!! cleanContent($homeData->section_3['content']) !!}
                </div>
            @else
                <h2 class="section-title mb-3">The Lalit Loyalty Membership Tiers </h2>
                <div class="header-title-line tagline-line"></div>
                <p class="section-subtitle mb-5 mt-3">
                    Discover exclusive privileges to make every moment with The Lalit even more memorable.
                </p>

                <div class="row g-4">
                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://placehold.co/660x660" alt="Fine Dining" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>Blue</h6>
                            <p>Begin your journey with coveted benefits</p>
                            <ul class="mt-3 mb-3">
                                <li>Annual spend of upto INR 50,000</li>
                            </ul>
                            <div class="mt-3">
                                <a href="#" class="ct-btn btn-lg">
                                    Explore BLUE
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://placehold.co/660x660" alt="Spa Services" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>Silver</h6>
                            <p>Enjoy elevated service and curated experiences.</p>
                            <ul class="mt-3 mb-3">
                                <li>Annual spend of INR 50,001 upto INR 1,50,000</li>
                            </ul>
                            <div class="mt-3">
                                <a href="#" class="ct-btn btn-lg">
                                    Explore Silver
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://placehold.co/660x660" alt="Activities" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>Gold</h6>
                            <p>Experience seamless luxury with personalized touches.</p>
                            <ul class="mt-3 mb-3">
                                <li>Annual spend of INR 1,50,001 upto INR 4,00,000</li>
                            </ul>
                            <div class="mt-3">
                                <a href="#" class="ct-btn btn-lg">
                                    Explore Gold
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <div class="benefit-card">
                            <div class="image-wrapper mb-3">
                                <img src="https://placehold.co/660x660" alt="Events" class="img-fluid">
                            </div>
                            <div class="border-anima"></div>
                            <h6>Platinum</h6>
                            <p>Unlock bespoke experiences tailored to your preferences.</p>
                            <ul class="mt-3 mb-3">
                                <li>Annual spend of INR 4,00,001 and above</li>
                            </ul>
                            <div class="mt-3">
                                <a href="#" class="ct-btn btn-lg">
                                    Explore Platinum
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
    <!-- End Membership Tiers Section -->

    <!-- Start Discover The Lalit Loyality Section -->
    <section class="py-5">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="https://cdn.jumeirah.com/-/mediadh/dh/hospitality/jumeirah/global-pages/jone-home/jone-home_collecting-points.jpg?h=960&w=1280&revision=4cc47f86-e4df-46da-8f11-dc6b631e9d7e"
                            alt="Luxury Hotel Experience" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4">Discover The LaLiT Loyalty</h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            Unlock exclusive rates, privileged access, and tailor-made experiences designed just for you.
                        </p>
                        <div class="mt-4">
                            <a href="#" class="ct-btn btn-lg">
                                Join Now
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Discover The Lalit Loyality Section -->

    <!-- Start Help and Support Section -->
    <section class="py-5 text-center">
        <div class="container">
            @if ($homeData && $homeData->section_5 && isset($homeData->section_5['content']))
                <div class="section-5">
                    {!! cleanContent($homeData->section_5['content']) !!}
                </div>
            @else
                <h2 class="section-title mb-3">Help & Support</h2>
                <div class="header-title-line"></div>
                <p class="section-subtitle mb-4 mt-3">
                    For assistance with your membership of The LaLiT Loyalty program, please reach out to our member helpdesk.
                </p>
                <div class="mt-4 d-flex justify-content-center gap-3">
                    <a href="tel:+918000000000" class="ct-btn btn-lg">
                        <i class="fa-solid fa-phone"></i> Call Us
                    </a>
                    <a href="mailto:support@lalitloyalty.com" class="ct-btn btn-lg">
                        <i class="fa-solid fa-envelope"></i> Email Us
                    </a>
                </div>
            @endif
        </div>
    </section>
    <!-- End Help and Support Section -->

    <!-- Start About Us Section -->
    <section class="py-5 text-center">
        <div class="container">
            <h2 class="section-title mb-3">About the Program</h2>
            <div class="header-title-line"></div>
            <p class="section-subtitle mb-4 mt-3">
              The LaLiT Loyalty program is an extension of the ethos of The Lalit brand—personal, inclusive, heartfelt and memorable. It is not just about points and rewards; it is about recognizing the trust our guests place in us and deepening that bond with every stay, visit and time they spend with us.
            </p>
            <p>
              The LaLiT Loyalty program is an initiative to make the members a part of a larger mission. It is a step towards supporting meaningful causes and making an impact.
            </p>
            <p>
              This is unlike any other loyalty programs due to our partnership with Points for Good. This collaboration allows members to donate their points for social impact—supporting causes ranging from planting a tree to skilling of LGBTQIA+ individuals, educating a child to environmental sustainability.  
            </p>
            <p>
              The program aligns perfectly with The LaLiT's commitment to inclusivity, community upliftment and responsible tourism.
            </p>
        </div>
    </section>
    <!-- End About Us Section -->

@endsection
