@extends('layouts.home')

@section('title', 'Home - The LaLiT Hotels')

@section('nav-home', 'active')
@php
use Illuminate\Support\Facades\Storage;
@endphp
@section('hero')
<!-- Hero Banner Slider -->
<div id="heroSlider" class="carousel slide" data-bs-ride="carousel">
    <!-- Indicators removed as per requirement -->
    
    <!-- Slides -->
    <div class="carousel-inner">
        @forelse($slides as $index => $slide)
            <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                <div class="hero-banner position-relative">
                    @if($slide->link_url)
                        <a href="{{ $slide->link_url }}" target="{{ $slide->link_target }}" class="d-block">
                    @endif
                    <div class="hero-image">
                        <img src="{{ $slide->image_url }}" class="d-block w-100" alt="{{ $slide->image_alt ?: $slide->name }}">
                    </div>
                    <!-- Hero Overlay -->
                    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100" >
                    </div>
                    @if($slide->link_url)
                        </a>
                    @endif
                    
                    @if($slide->description)
                        <div class="carousel-caption">
                            <p>{{ $slide->description }}</p>
                        </div>
                    @endif
                </div>
            </div>
        @empty
            <!-- Fallback if no slides -->
            <div class="carousel-item active">
                <div class="hero-banner position-relative">
                    <div class="hero-image">
                        @if($homeData && $homeData->banner_img && Storage::disk('public')->exists($homeData->banner_img))
                            <img src="{{ Storage::url($homeData->banner_img) }}" class="d-block w-100" alt="Hero Background">
                        @else
                            <img src="{{ asset('assets/images/hero-bg.avif') }}" class="d-block w-100" alt="Hero Background">
                        @endif
                    </div>
                    <!-- Hero Overlay -->
                    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100"
                        style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.6) 100%);">
                    </div>
                </div>
            </div>
        @endforelse
    </div>
    
    <!-- Controls -->
    @if($slides->count() > 1)
        <button class="carousel-control-prev" type="button" data-bs-target="#heroSlider" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#heroSlider" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    @endif
</div>
@endsection

@section('content')

<!-- Section for Benefits of Being a Member -->
<section class="text-center">
    <div class="container">
        <h2 class="section-title my-3">Be A LaLiT Loyalist</h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            @if ($homeData && $homeData->section_1 && isset($homeData->section_1['content']))
                {{$homeData->section_1['content']}}
            @endif
        </p>

        <div class="row g-4">
            @if($benefits->count() > 0)
                @foreach($benefits->take(3) as $benefit)
                <div class="col-md-4">
                    <div class="benefit-card">
                        <div class="image-wrapper mb-3">
                            @if($benefit->featured_image && Storage::disk('public')->exists($benefit->featured_image))
                                <img src="{{ Storage::url($benefit->featured_image) }}"
                                     alt="{{ $benefit->featured_image_alt ?: $benefit->title }}" class="img-fluid">
                            @else
                                <img src="{{ asset('assets/images/member-' . ($loop->index + 1) . '.avif') }}"
                                     alt="{{ $benefit->title }}" class="img-fluid">
                            @endif
                        </div>
                        <div class="border-anima"></div>
                        @if($benefit->custom_link)
                            <a href="{{ $benefit->custom_link }}" class="text-decoration-none text-dark">
                                <h5>{{ strtoupper($benefit->title) }}</h5>
                            </a>
                        @else
                            <h5>{{ strtoupper($benefit->title) }}</h5>
                        @endif
                        <p>{{ $benefit->excerpt ?: strip_tags($benefit->content) }}</p>
                    </div>
                </div>
                @endforeach
            @else
                <!-- Fallback to static content if no benefits are published -->
                <p>Please add benefits from admin.</p>
            @endif
        </div>
        <div class="mt-4">
            <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
                <a href="#" data-bs-toggle="modal" data-bs-target="#signupModal" class="btn-lg ct-btn-white">Join Now</a>
                <a href="#" data-bs-toggle="modal" data-bs-target="#loginModal" class="btn-lg ct-btn-white">Already a member - Sign in</a>
            </div>
        </div>
    </div>
</section>
<!-- Benefits of being a Member Section -->

<!-- Start The LaLiT Exclusive Rewards Section -->
<section id="rewards" class="py-5 text-center">
    <div class="container">
        <h2 class="section-title mb-3">The LaLiT Exclusive Rewards</h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            @if ($homeData && $homeData->section_2 && isset($homeData->section_2['content']))
                {{$homeData->section_2['content']}}
            @endif
        </p>

        <!-- Rewards Carousel -->
        <div id="rewardsCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-wrap="true">
            <div class="carousel-inner">
                @php
                    $rewardsArr = $rewards->all();
                    $total = count($rewardsArr);
                    $perSlide = 4;
                    $numSlides = $total > 0 ? ceil($total / $perSlide) : 0;
                @endphp
                @for($slide = 0; $slide < $numSlides; $slide++)
                <div class="carousel-item {{ $slide == 0 ? 'active' : '' }}">
                    <div class="row g-4">
                        @for($i = 0; $i < $perSlide; $i++)
                            @php
                                $rewardIndex = ($slide * $perSlide + $i) % $total;
                                $reward = $rewardsArr[$rewardIndex];
                            @endphp
                            <div class="col-lg-3 col-md-6">
                                <div class="benefit-card">
                                    <div class="image-wrapper mb-3">
                                        <img src="{{ Storage::url($reward->featured_image) }}" alt="{{ $reward->title }}"
                                             class="img-fluid">
                                    </div>
                                    <div class="border-anima"></div>
                                    <h6><a class="text-decoration-none text-dark fw-bold" href="{{ route('pages.rewards', $reward->slug) }}">{{ strtoupper($reward->title) }}</a></h6>
                                    <p>{{ $reward->excerpt }}</p>
                                </div>
                            </div>
                        @endfor
                    </div>
                </div>
                @endfor
            </div>
            
            <!-- Carousel Controls -->
            @if($numSlides > 1)
            <button class="carousel-control-prev" type="button" data-bs-target="#rewardsCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#rewardsCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
            @endif
            
            <!-- Carousel Indicators -->
            @if($numSlides > 1)
            <div class="carousel-indicators">
                @for($index = 0; $index < $numSlides; $index++)
                <button type="button" data-bs-target="#rewardsCarousel" data-bs-slide-to="{{ $index }}" 
                        class="{{ $index == 0 ? 'active' : '' }}" aria-current="{{ $index == 0 ? 'true' : 'false' }}" 
                        aria-label="Slide {{ $index + 1 }}"></button>
                @endfor
            </div>
            @endif
        </div>
        {{-- <div class="text-center mt-4">
            <a href="#" class="ct-btn-white btn-lg d-inline-block">Discover More</a>
        </div> --}}
    </div>
</section>
<!-- End The LaLiT Loyalty Section -->

<!-- Start Points Section -->
@php
    $i = 0;
@endphp
@foreach ($points as $point)
    @if ($i++ % 2 == 0)
        <section class="py-3">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="{{ Storage::url($point->featured_image) }}"
                            alt="{{ $point->title }}" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4">{{ $point->title }}</h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            {{ $point->excerpt }}
                        </p>
                        <div class="mt-4">
                            <a href="{{ route('pages.points', $point->slug) }}" class="ct-btn-white btn-lg d-inline-block text-center">
                                More Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @else 
    <section class="py-3">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-4">
                    <div class="content-wrapper">
                        <h2 class="section-title mb-4">{{ $point->title }}</h2>
                        <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                        <p class="mb-4">
                            {{ $point->excerpt }}
                        </p>
                        <div class="mt-4">
                            <a href="{{ route('pages.points', $point->slug) }}" class="ct-btn-white btn-lg d-inline-block text-center">
                                More Details
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="image-wrapper">
                        <img src="{{ Storage::url($point->featured_image) }}"
                            alt="{{ $point->title }}" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif
@endforeach
<!-- End Donate Points Section -->

<!-- Start Membership Tiers Section -->
<section id="membership-tier" class="py-5 text-center" style="background-color: #f5f0eb;">
    <div class="container">
        <h2 class="section-title mb-3">The LaLiT Loyalty Membership Tiers </h2>
        <div class="header-title-line tagline-line"></div>
        <p class="section-subtitle mb-5 mt-3">
            @if ($homeData && $homeData->section_3 && isset($homeData->section_3['content']))
                {{$homeData->section_3['content']}}
            @endif
        </p>

        <div class="row g-4">
            @foreach($tiers as $tier)
            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="{{ Storage::url($tier->featured_image) }}" alt="Fine Dining" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <div class="content">
                        <h6 class="font-bold">{{ $tier->title }}</h6>
                        <p>{{ $tier->excerpt }}</p>
                        <div class="content-tier">{!! $tier->content !!}</div>
                    </div>
                    <div class="mt-3">
                        <a href="/package-details" class="ct-btn-white btn-lg d-inline-block text-center">
                            Explore {{ $tier->title }}
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
            {{-- <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="{{ asset('assets/images/member.png') }}" alt="Fine Dining" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <h6>Blue</h6>
                    <p>Begin your journey with coveted benefits</p>
                    <ul class="mt-3 mb-3">
                        <li>Annual spend of upto INR 50,000</li>
                    </ul>
                    <div class="mt-3">
                        <a href="#" class="ct-btn btn-lg">
                            Explore BLUE
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="{{ asset('assets/images/silver.png') }}" alt="Spa Services" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <h6>Silver</h6>
                    <p>Enjoy elevated service and curated experiences.</p>
                    <ul class="mt-3 mb-3">
                        <li>Annual spend of INR 50,001 upto INR 1,50,000</li>
                    </ul>
                    <div class="mt-3">
                        <a href="#" class="ct-btn btn-lg">
                            Explore Silver
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="{{ asset('assets/images/gold.png') }}" alt="Activities" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <h6>Gold</h6>
                    <p>Experience seamless luxury with personalized touches.</p>
                    <ul class="mt-3 mb-3">
                        <li>Annual spend of INR 1,50,001 upto INR 4,00,000</li>
                    </ul>
                    <div class="mt-3">
                        <a href="#" class="ct-btn btn-lg">
                            Explore Gold
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="benefit-card">
                    <div class="image-wrapper mb-3">
                        <img src="{{ asset('assets/images/platinum.png') }}" alt="Events" class="img-fluid">
                    </div>
                    <div class="border-anima"></div>
                    <h6>Platinum</h6>
                    <p>Unlock bespoke experiences tailored to your preferences.</p>
                    <ul class="mt-3 mb-3">
                        <li>Annual spend of INR 4,00,001 and above</li>
                    </ul>
                    <div class="mt-3">
                        <a href="#" class="ct-btn btn-lg">
                            Explore Platinum
                        </a>
                    </div>
                </div>
            </div> --}}
        </div>
    </div>
</section>
<!-- End Membership Tiers Section -->

<!-- Start Discover The Lalit Loyality Section -->
<section class="py-5">
    <div class="container">
        <div class="row align-items-center g-5">
            <div class="col-lg-8">
                <div class="image-wrapper">
                    @if($homeData && isset($homeData->section_5['image']) && Storage::disk('public')->exists($homeData->section_5['image']))
                        <img src="{{ Storage::url($homeData->section_5['image']) }}"
                             alt="Discover The LaLiT Loyalty" class="img-fluid rounded shadow-lg">
                    @endif
                </div>
            </div>
            <div class="col-lg-4">
                <div class="content-wrapper">
                    <h2 class="section-title mb-4">Discover The LaLiT Loyalty</h2>
                    <div class="header-title-line mb-4" style="margin-left: 0; width: 5.875rem;"></div>

                    @if ($homeData && $homeData->section_5 && isset($homeData->section_5['content']))
                        {!! $homeData->section_5['content'] !!}
                    @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End Discover The Lalit Loyality Section -->

<!-- Start Help and Support Section -->
<section class="py-5 text-center">
    <div class="container">
        <h2 class="section-title mb-3">Help & Support</h2>
        <div class="header-title-line"></div>
        <p class="section-subtitle mb-4 mt-3">
            @if ($homeData && $homeData->section_4 && isset($homeData->section_4['content']))
                {{$homeData->section_4['content']}}
            @endif
        </p>
        <div class="mt-4 d-flex flex-column flex-md-row justify-content-center gap-3">
          <a href="tel:18002024911" class="ct-btn-white btn-lg">
              <i class="fa-solid fa-phone"></i> Call Us
          </a>
          <a href="mailto:reachus@thelalitloyalty.com" class="ct-btn-white btn-lg">
              <i class="fa-solid fa-envelope"></i> Email Us
          </a>
        </div>
    </div>
</section>
<!-- End Help and Support Section -->

<!-- Start About Us Section -->
{{-- <section class="py-5 text-center">
    <div class="container">
        <h2 class="section-title mb-3">About the Program</h2>
        <div class="header-title-line"></div>
        @if ($homeData && $homeData->section_5 && isset($homeData->section_5['content']))
                {!! $homeData->section_5['content'] !!}
        @endif
    </div>
</section> --}}
<!-- End About Us Section -->

@endsection
@push('styles')
<style>
  #rewardsCarousel .carousel-control-prev,
  #rewardsCarousel .carousel-control-next {
    background-color: #000;
    width: 6vh;
    height: 6vh;
    border-radius: 50%;
    top: 30%;
    transform: translateY(-50%);
  }
</style>
@endpush