<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }} - Admin</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        
        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        
        <!-- Bootstrap 5 CDN -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        
        <!-- jQuery (required for many plugins) -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
        
        <!-- Admin Layout CSS -->
        <style>
             ol  {
                list-style: auto;
            }
            ul {
                list-style: disc;
            }
            .sidebar {
                position: fixed;
                top: 0;
                bottom: 0;
                left: 0;
                z-index: 100;
                padding: 48px 0 0;
                box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
                background-color: #f8f9fa;
                width: 280px;
                transition: all 0.3s;
            }
            
            .sidebar-sticky {
                position: relative;
                top: 0;
                height: calc(100vh - 48px);
                padding-top: .5rem;
                overflow-x: hidden;
                overflow-y: auto;
            }
            
            .sidebar .nav-link {
                font-weight: 500;
                color: #333;
                padding: .75rem 1.25rem;
                border-left: 4px solid transparent;
            }
            
            .sidebar .nav-link:hover {
                color: #007bff;
            }
            
            .sidebar .nav-link.active {
                color: #007bff;
                border-left-color: #007bff;
                background-color: rgba(0, 123, 255, 0.1);
            }
            
            .sidebar .nav-link i {
                margin-right: 10px;
                width: 20px;
                text-align: center;
            }
            
            .sidebar-heading {
                font-size: .75rem;
                text-transform: uppercase;
                padding: 1rem 1.25rem;
                color: #6c757d;
            }
            
            .navbar-brand {
                padding-top: .75rem;
                padding-bottom: .75rem;
                font-size: 1rem;
                background-color: rgba(0, 0, 0, .25);
                box-shadow: inset -1px 0 0 rgba(0, 0, 0, .25);
            }
            
            .content-wrapper {
                margin-left: 280px;
                transition: all 0.3s;
                width: calc(100% - 280px);
            }
            
            .navbar {
                padding: 0 1rem;
                background-color: #fff;
                box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            }
            
            .navbar-toggler {
                padding: .25rem .75rem;
                font-size: 1.25rem;
                border: 1px solid #ddd;
            }
            
            @media (max-width: 768px) {
                .sidebar {
                    width: 100%;
                    transform: translateX(-100%);
                }
                
                .content-wrapper {
                    margin-left: 0;
                    width: 100%;
                }
                
                .sidebar.show {
                    transform: translateX(0);
                }
            }
            
            .sidebar-logo {
                height: 32px;
                margin-right: 10px;
            }
            
            .sidebar-brand {
                font-size: 1.2rem;
                font-weight: 600;
                padding: 1rem 1.25rem;
                display: flex;
                align-items: center;
                color: #333;
                text-decoration: none;
            }
            
            .dropdown-menu {
                right: 0;
                left: auto;
            }
        </style>
        
        <!-- Styles Stack -->
        @stack('styles')
    </head>
    <body class="font-sans antialiased">
        <div class="d-flex">
            <!-- Include Common Sidebar Navigation -->
            @include('layouts.sidebar-navigation')
                    </ul>
                </div>
            </aside>

            <!-- Content area -->
            <div class="content-wrapper">
                <!-- Top Navigation Bar -->
                <nav class="navbar navbar-expand-md navbar-light sticky-top">
                    <div class="container-fluid">
                        <button class="navbar-toggler d-md-none" type="button" id="sidebarToggle">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        
                        <div class="ms-auto">
                            <!-- Settings Dropdown -->
                            <div class="dropdown">
                                <button class="btn dropdown-toggle d-flex align-items-center" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                    <span class="me-2">{{ Auth::user()->name }}</span>
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <li>
                                        <a class="dropdown-item" href="{{ route('profile.edit') }}">                                            Profile
                                        </a>
                                    </li>
                                    <li>
                                        <hr class="dropdown-divider">
                                    </li>
                                    <li>
                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <button type="submit" class="dropdown-item">
                                                Log Out
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </nav>

                <!-- Page Heading -->
                @hasSection('header')
                    <header class="bg-white shadow">
                        <div class="container-fluid py-3 px-4">
                            @yield('header')
                        </div>
                    </header>
                @endif

                <!-- Page Content -->
                <main class="py-4">
                    @yield('content')
                </main>
            </div>
        </div>
        
        <!-- Sidebar Toggle Script -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const sidebarToggle = document.getElementById('sidebarToggle');
                const sidebar = document.querySelector('.sidebar');
                const contentWrapper = document.querySelector('.content-wrapper');
                
                if (sidebarToggle) {
                    sidebarToggle.addEventListener('click', function() {
                        sidebar.classList.toggle('show');
                    });
                }
                
                // Close sidebar when clicking outside on mobile
                document.addEventListener('click', function(event) {
                    const isClickInside = sidebar.contains(event.target) || sidebarToggle.contains(event.target);
                    if (!isClickInside && window.innerWidth < 768 && sidebar.classList.contains('show')) {
                        sidebar.classList.remove('show');
                    }
                });
            });
        </script>
        
        <!-- Scripts Stack -->
        @stack('scripts')
    </body>
</html>
