<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'The LaLiT Hotels')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Optional Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/membership.css') }}" />

    <style>
    /* Mobile Offcanvas Menu Styles */
    .offcanvas {
      width: 300px !important;
      background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    }

    .offcanvas-header {
      background-color: #c6aa76;
      color: white;
      padding: 1.5rem;
      border-bottom: 3px solid #b39968;
    }

    .offcanvas-title {
      font-size: 1.5rem;
      font-weight: 700;
      letter-spacing: 0.5px;
      color: white;
    }

    .offcanvas .btn-close {
      filter: brightness(0) invert(1);
      opacity: 1;
    }

    .offcanvas-body {
      padding: 1.5rem 1rem;
    }

    /* Mobile Navigation Links */
    .offcanvas .nav-link {
      color: #212322 !important;
      font-weight: 500;
      font-size: 1rem;
      padding: 0.875rem 1.25rem !important;
      margin-bottom: 0.5rem;
      border-radius: 8px;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      background-color: transparent;
    }

    .offcanvas .nav-link:hover,
    .offcanvas .nav-link:focus {
      color: #c6aa76 !important;
      background-color: rgba(198, 170, 118, 0.1);
      transform: translateX(5px);
    }

    .offcanvas .nav-link::before {
      content: "▸";
      margin-right: 0.75rem;
      color: #c6aa76;
      font-size: 1.1rem;
      transition: transform 0.3s ease;
    }

    .offcanvas .nav-link:hover::before {
      transform: translateX(3px);
    }

    /* Mobile Menu Footer */
    .offcanvas .mt-auto {
      border-top: 2px solid #e9ecef !important;
      padding-top: 1.5rem !important;
      margin-top: 1.5rem !important;
    }

    .offcanvas .ct-btn {
      padding: 0.875rem 1.25rem;
      font-weight: 700;
      border-radius: 10px;
      transition: all 0.3s ease;
      text-transform: uppercase;
      font-size: 0.8rem;
      letter-spacing: 1px;
      border: none;
      background: linear-gradient(135deg, #212322 0%, #000000 100%);
      color: white;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
      text-decoration: none;
      display: block;
      position: relative;
      overflow: hidden;
    }

    .offcanvas .ct-btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, #c6aa76 0%, #b39968 100%);
      transition: left 0.4s ease;
      z-index: 0;
    }

    .offcanvas .ct-btn:hover::before {
      left: 0;
    }

    .offcanvas .ct-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 6px 20px rgba(198, 170, 118, 0.4);
    }

    .offcanvas .ct-btn span,
    .offcanvas .ct-btn:not(:has(span)) {
      position: relative;
      z-index: 1;
    }

    /* Special styling for Book Your Stay button */
    .offcanvas .ct-btn:last-child {
      background: linear-gradient(135deg, #c6aa76 0%, #b39968 100%);
    }

    .offcanvas .ct-btn:last-child::before {
      background: linear-gradient(135deg, #212322 0%, #000000 100%);
    }

    .offcanvas .gap-2 {
      gap: 0.75rem !important;
    }
    /* Mobile responsive for login tabs */
    @media (max-width: 576px) {
      #offcanvasFooter .ct-btn {
        height: auto;
      }
    }
    </style>

    @stack('styles')
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-GTG6Q4XPMZ"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'G-GTG6Q4XPMZ');
    </script>
</head>

<body class="page-layout font-sans antialiased bg-gray-50 dark:bg-gray-900">
    <header class="site-header">
        <!-- Primary Navigation Header -->
        <div class="carousel-nav-menu px-3" style="background-color: #f5f0eb;">
            <div class="d-flex justify-content-between align-items-center py-2">
                <!-- Left Side - Toggle Button for Mobile / Empty space for Desktop -->
                <div class="nav-left">
                    <button class="btn btn-outline-dark d-lg-none" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasMenu">
                        ☰
                    </button>
                    <!-- Empty space for desktop to balance layout -->
                    <div class="d-none d-lg-block" style="width: 200px;"></div>
                </div>

                <!-- Center Logo -->
                <div class="logo">
                    <a href="/">
                        <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid">
                    </a>
                </div>

                <!-- Right Side - Desktop Menu -->
                <div class="nav-right">
                    <!-- Desktop Menu -->
                    <ul class="nav nav-pills d-none d-lg-flex">
                        <li class="nav-item">
                            <a href="{{url('/')}}" class="nav-link">
                                Home
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#" class="nav-link" id="logoutBtn">
                                Logout
                            </a>
                        </li>
                        <li class="nav-item"><a class="nav-link" href="https://www.thelalit.com/">Book your stay</a>
                        </li>
                    </ul>

                    <!-- Logout Button for Mobile (visible only on mobile) -->
                    <div class="d-lg-none">
                        <a href="{{url('/')}}" class="btn btn-outline-dark btn-sm me-2">
                            Home
                        </a>
                        <a href="#" class="btn btn-outline-dark btn-sm" id="mobileLogoutBtn">
                            Logout
                        </a>
                    </div>
                </div>
            </div>

            <!-- Secondary Navigation Header -->
            <div class="secondary-nav">
                <div class="container-fluid px-3">
                    <div class="d-flex justify-content-center align-items-center">
                        <!-- Secondary Navigation Links -->
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="{{url('/membership/dashboard')}}">Overview</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ route('membership.offers') }}">Member Offers</a></li>
                            {{-- <li class="nav-item"><a class="nav-link" href="#">Collect</a></li> --}}
                            <li class="nav-item"><a class="nav-link" href="{{ route('membership.participating-hotels') }}">Participating Hotels</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/membership/rewards') }}">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/package-details') }}">Tier Benefits</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/membership/donations') }}">Donation</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Offcanvas Menu -->
        <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title">The LaLiT Loyalty</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body d-flex flex-column">
                <nav>
                    <ul class="nav flex-column">
                        <li class="nav-item"><a class="nav-link" href="{{url('/membership/dashboard')}}">Overview</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('membership.offers') }}">Member Offers</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('membership.participating-hotels') }}">Participating Hotels</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ url('/membership/rewards') }}">Rewards</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ url('/package-details') }}">Tier Benefits</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ url('/membership/donations') }}">Donation</a></li>
                    </ul>
                </nav>
                <!-- Mobile Menu Footer -->
                <div class="mt-auto" id="offcanvasFooter">
                    <div class="d-flex flex-column gap-2">
                        <a href="{{url('/')}}" class="ct-btn text-center" data-bs-dismiss="offcanvas"><i class="fas fa-home me-2"></i>Home</a>
                        <a href="#" class="ct-btn text-center" id="offcanvasLogoutBtn"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
                        <a href="https://www.thelalit.com/" target="_blank" class="ct-btn text-center"><i class="fas fa-hotel me-2"></i>Book Your Stay</a>
                    </div>
                </div>
            </div>
        </div>

        @hasSection('hero')
            <div class="hero-container">
                @yield('hero')
            </div>
        @endif
    </header>

    <!-- Sticky Page Navigation -->
    <div id="sticky-page-nav" class="sticky-top d-none">
        <div class="container-fluid py-2 bg-white border-bottom shadow-sm">
            <div class="container">
                <!-- Main Navigation Row -->
                <div class="d-flex justify-content-between align-items-center">
                    <!-- Logo instead of page title -->
                    <div class="sticky-logo">
                        <a href="{{ route('homestatic') }}">
                            <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid"
                                style="height: 40px;">
                        </a>
                    </div>

                    <!-- Secondary Navigation Links -->
                    <nav class="secondary-navigation d-none d-lg-block">
                        <ul class="nav nav-pills secondary-nav-links">
                            <li class="nav-item"><a class="nav-link" href="{{url('/membership/dashboard')}}">Overview</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ route('membership.offers') }}">Member Offers</a></li>
                            {{-- <li class="nav-item"><a class="nav-link" href="#">Collect</a></li> --}}
                            <li class="nav-item"><a class="nav-link" href="{{ route('membership.participating-hotels') }}">Participating Hotels</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/membership/rewards') }}">Rewards</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/package-details') }}">Tier Benefits</a></li>
                            <li class="nav-item"><a class="nav-link" href="{{ url('/membership/donations') }}">Donation</a></li>
                        </ul>
                    </nav>

                    <div class="nav-action">
                        <a href="#" class="btn btn-sm btn-primary" id="stickyLogoutBtn">Logout</a>
                    </div>
                </div>


            </div>
        </div>
    </div>

    <!-- Page Title Section - Will be shown on mobile views -->
    @hasSection('page_title')
        <div class="page-title-container d-md-none bg-white py-3">
            <div class="container">
                <h1 class="page-title">@yield('page_title')</h1>
            </div>
        </div>
    @endif

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="py-3" style="background-color: #f5f0eb;">
        <div class="container">
            <div class="row">
                <!-- Links Sections -->
                <div class="col-lg-8">
                    <div class="row">
                        <!-- First Column -->
                        <div class="col-md-6">
                            <h5 class="mb-3" style="color: #212322;">Quick Links</h5>
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/about-us" class="text-decoration-none"
                                        style="color: #212322; opacity: 0.7;">About The LaLiT Loyalty</a></li>
                                <li class="mb-2"><a href="/contact-us" class="text-decoration-none"
                                        style="color: #212322; opacity: 0.7;">Contact Us</a></li>
                                <li class="mb-2"><a href="/faqs" class="text-decoration-none"
                                        style="color: #212322; opacity: 0.7;">FAQs</a></li>
                            </ul>
                        </div>

                        <!-- Second Column -->
                        <div class="col-md-6 mb-4">
                            <ul class="list-unstyled">
                                <li class="mb-2"><a href="/terms-condition" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Terms & Conditions</a></li>
                                <li class="mb-2"><a href="/privacy-policy" class="text-decoration-none" style="color: #212322; opacity: 0.7;">Privacy Policy</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Copyright Section -->
            <hr class="my-3 border-secondary">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0" style="color: #212322; opacity: 0.7;">&copy; {{ date('Y') }} The LaLiT Hotels. All
                        rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <img src="{{ asset('assets/images/logo-black-lalit.png') }}" alt="Logo" class="img-fluid"
                        style="max-height: 100px;">
                </div>
            </div>
        </div>
    </footer>

    @stack('scripts')

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const header = document.querySelector('header');
            const stickyNav = document.getElementById('sticky-page-nav');
            const navLinks = document.querySelectorAll('#sticky-page-nav .nav-link');

            // Fix for mobile navigation links in off-canvas menu
            const mobileNavLinks = document.querySelectorAll('.mobile-nav-link');
            const offcanvasMenu = document.getElementById('offcanvasMenu');

            mobileNavLinks.forEach(link => {
                link.addEventListener('click', function (e) {
                    const href = this.getAttribute('href');
                    const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasMenu);

                    // If it's a hash link, handle special navigation
                    if (href.startsWith('#')) {
                        e.preventDefault();

                        // Close the offcanvas menu
                        if (bsOffcanvas) {
                            bsOffcanvas.hide();

                            // Wait for offcanvas to close before scrolling
                            offcanvasMenu.addEventListener('hidden.bs.offcanvas', function scrollToTarget() {
                                const targetElement = document.querySelector(href);
                                if (targetElement) {
                                    setTimeout(() => {
                                        window.scrollTo({
                                            top: targetElement.offsetTop - 100,
                                            behavior: 'smooth'
                                        });
                                    }, 150);
                                }
                                // Remove event listener to avoid multiple executions
                                offcanvasMenu.removeEventListener('hidden.bs.offcanvas', scrollToTarget);
                            });
                        }
                    } else {
                        // For non-hash links, just close the menu (default navigation will happen)
                        if (bsOffcanvas) {
                            bsOffcanvas.hide();
                        }
                    }
                });
            });

            // Handle scrolling events to show/hide sticky menu
            window.addEventListener('scroll', function () {
                if (!header) return;

                const headerBottom = header.getBoundingClientRect().bottom;

                // Show sticky nav when scrolled past header
                if (headerBottom <= 0) {
                    stickyNav.classList.remove('d-none');
                } else {
                    stickyNav.classList.add('d-none');
                }
            });

            // Handle navigation link clicks for smooth scrolling
            navLinks.forEach(link => {
                link.addEventListener('click', function (e) {
                    const targetId = this.getAttribute('href');
                    if (targetId && targetId.startsWith('#')) {
                        e.preventDefault();
                        const targetElement = document.querySelector(targetId);
                        if (targetElement) {
                            // Calculate offset with sticky nav height
                            const stickyNavHeight = stickyNav.offsetHeight;
                            const targetPosition = targetElement.getBoundingClientRect().top + window.scrollY - stickyNavHeight;

                            // Smooth scroll to target position
                            window.scrollTo({
                                top: targetPosition,
                                behavior: 'smooth'
                            });

                            // Update active state for secondary navigation only
                            navLinks.forEach(link => link.classList.remove('active'));
                            this.classList.add('active');
                        }
                    }
                });
            });

            // No need for section-based active link detection now that we've removed section navigation

            // Setup logout handlers
            setupLogoutHandlers();
        });
        
        function setupLogoutHandlers() {
            // Desktop logout
            const desktopLogout = document.getElementById('logoutBtn');
            if (desktopLogout) {
                desktopLogout.addEventListener('click', handleLogout);
            }
            
            // Mobile logout
            const mobileLogout = document.getElementById('mobileLogoutBtn');
            if (mobileLogout) {
                mobileLogout.addEventListener('click', handleLogout);
            }
            
            // Sticky logout
            const stickyLogout = document.getElementById('stickyLogoutBtn');
            if (stickyLogout) {
                stickyLogout.addEventListener('click', handleLogout);
            }
            
            // Offcanvas logout
            const offcanvasLogout = document.getElementById('offcanvasLogoutBtn');
            if (offcanvasLogout) {
                offcanvasLogout.addEventListener('click', handleLogout);
            }
        }
        
        async function handleLogout(event) {
            event.preventDefault();
            
            try {
                const response = await fetch('/membership/member-logout', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    // Redirect to home page
                    window.location.href = '/';
                } else {
                    console.error('Logout failed:', data.message);
                    // Still redirect even if API failed
                    window.location.href = '/';
                }
            } catch (error) {
                console.error('Logout error:', error);
                // Still redirect even if logout failed
                window.location.href = '/';
            }
        }
    </script>
</body>

</html>