@extends('layouts.pages')

@section('title', $packageDetail->heading . ' - The LaLiT Hotels')

@php
use Illuminate\Support\Facades\Storage;
@endphp

@section('content')
<div class="container py-4">
    <!-- Header Section -->
    <section class="text-center mb-2 pt-lg-3 pt-md-4">
        <h1 class="display-4 fw-bold" >{{ $packageDetail->heading }}</h1>
        @if($packageDetail->excerpt)
        <div class="lead my-3 w-75 mx-auto">
            {{ $packageDetail->excerpt }}
        </div>
        @endif
        
        @if($packageDetail->featured_image && Storage::disk('public')->exists($packageDetail->featured_image))
        <div class="featured-image-container text-center mt-4">
            <img src="{{ Storage::url($packageDetail->featured_image) }}" 
                 alt="{{ $packageDetail->heading }}" 
                 class="img-fluid rounded shadow">
        </div>
        @endif
    </section>
    
    <!-- Package Details Section -->
    <section class="package-details page-header" id="package-details">
        <div class="text-center mb-4">
            <h2 class="section-title">Member Tier Benefits</h2>
            <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
        </div>
        
        <!-- Package Content -->
        <div class="row">
            <div class="col-lg-8 mx-auto">
                @if($packageDetail->content)
                <div class="package-content">
                    {!! $packageDetail->content !!}
                </div>
                @endif
            </div>
        </div>
        
        <!-- Package Image - Full Width -->
        @if($packageDetail->package_image && Storage::disk('public')->exists($packageDetail->package_image))
        <div class="row">
            <div class="col-12">
                <div class="additional-image-container text-center mt-4">
                    <img src="{{ Storage::url($packageDetail->package_image) }}" 
                         class="img-fluid rounded shadow" 
                         alt="{{ $packageDetail->heading }} Package Image">
                </div>
            </div>
        </div>
        @endif
    </section>

    <!-- About Membership Benefits Section -->
    <section class="pt-5 membership-benefits-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="membership-benefits-card">
                        <h3 class="section-title text-center mb-4">{{ $packageDetail->membership_benefits_title ?? '' }}</h3>
                        <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
                        
                        <div class="benefits-content">
                            @if($packageDetail->membership_benefits_content)
                                <ul class="benefits-list">
                                    {!! $packageDetail->membership_benefits_content !!}
                                </ul>
                            @endif
                            
                            <div class="disclaimer mt-4 pt-3">
                                <p class="text-muted fst-italic">
                                    <strong>Please Note:</strong> {{ $packageDetail->membership_benefits_disclaimer ?? '' }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action Section -->
    <section class="py-5 text-center">
        <h3 class="section-title mb-3">Experience Luxury</h3>
        <div class="header-title-line mb-4" style="margin: 0 auto;"></div>
        <p class="section-subtitle mb-4">
            Book your stay with The LaLiT group and discover unparalleled hospitality and comfort.
        </p>
        <div class="d-flex flex-column flex-md-row gap-3 align-items-center justify-content-center">
            @if($packageDetail->link)
            <a href="{{ $packageDetail->link }}" target="_blank" class="btn btn-lg ct-btn-white">
                Book This Package
            </a>
            @endif
            <a href="https://www.thelalit.com" target="_blank" class="btn btn-lg ct-btn-white">
                Explore All Hotels
            </a>
        </div>
    </section>
</div>

@endsection

<style>
    /* Featured Image Container - Center Image */
    .featured-image-container {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }
    
    .featured-image-container img {
        max-width: 80%;
        max-height: 500px;
        object-fit: cover;
        display: block;
        margin: 0 auto;
    }
    
    /* Additional Image Container */
    .additional-image-container {
        width: 100%;
    }
    
    .additional-image-container img {
        width: 100%;
        max-height: auto;
        margin: 0 auto;
    }
    
    /* Section Styles */
    .section-title {
        position: relative;
        padding-bottom: 0.75rem;
        margin-bottom: 1.5rem;
    }
    
    /* Package Content Styles */
    .package-content {
        line-height: 1.7;
    }
    
    .package-content h1,
    .package-content h2,
    .package-content h3,
    .package-content h4,
    .package-content h5,
    .package-content h6 {
        margin-top: 2rem;
        margin-bottom: 1rem;
        color: #333;
    }
    
    .package-content p {
        margin-bottom: 1rem;
    }
    
    .package-content ul,
    .package-content ol {
        margin-bottom: 1rem;
        padding-left: 2rem;
    }
    
    .package-content img {
        max-width: 100%;
        height: auto;
        border-radius: 0.375rem;
        margin: 1rem 0;
    }
    
    /* Terms and Conditions */
    .terms-container {
        background-color: #f9f9f9;
        border-radius: 8px;
        padding: 2rem;
    }
    
    .terms-section {
        background-color: #f8f9fa;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .header-title-line {
        width: 60px;
        height: 3px;
        background-color: #c6aa76;
        margin: 0 auto 30px;
    }
    
    /* Membership Benefits Section */
    .membership-benefits-section {
        background-color: #f8f9fa;
    }
    
    .membership-benefits-card {
        background-color: white;
        border-radius: 12px;
        padding: 3rem 2.5rem;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin: 0 auto;
    }
    
    .benefits-content {
        font-size: 1.05rem;
        line-height: 1.7;
    }
    
    .benefits-list {
        list-style: none;
        padding-left: 0;
        margin-bottom: 0;
    }
    
    .benefits-list li {
        position: relative;
        padding-left: 2rem;
        margin-bottom: 1rem;
        color: #555;
    }
    
    .benefits-list li:before {
        content: "✓";
        position: absolute;
        left: 0;
        top: 0;
        color: #c6aa76;
        font-weight: bold;
        font-size: 1.2rem;
    }
    
    .benefits-list li strong {
        color: #333;
    }
    
    .disclaimer {
        border-top: 1px solid #e9ecef;
        text-align: center;
    }
    
    .disclaimer p {
        margin-bottom: 0;
        font-size: 0.95rem;
    }
    
    /* Ensure content isn't hidden under sticky nav */
    @media (max-width: 767.98px) {
        .container.my-5.pt-4 {
            padding-top: 4rem !important;
        }
    }
    
    /* Proper spacing on different screen sizes */
    @media (min-width: 768px) {
        .pt-md-4 {
            padding-top: 2rem !important;
        }
    }
    
    @media (min-width: 992px) {
        .pt-lg-3 {
            padding-top: 3rem !important;
        }
    }
</style>