@extends('layouts.pages')

@section('title', $point->meta_title ?? $point->title)

@section('meta_description', $point->meta_description)
@section('meta_keywords', $point->meta_keywords)
@section('meta_robots', $point->meta_robots)
@section('canonical_url', $point->canonical_url)

@section('content')
    <div class="container py-4">
        <!-- Header Section -->
        <section class="text-center mb-2 pt-lg-3 pt-md-4">
            <h1 class="display-4 fw-bold">{{ $point->title }}</h1>
            @if ($point->content)
                <div class="lead my-3 w-75 mx-auto">
                    {{ $point->content }}
                </div>
            @endif

            @if ($point->featured_image && Storage::disk('public')->exists($point->featured_image))
                <div class="featured-image-container text-center mt-4">
                    <img src="{{ Storage::url($point->featured_image) }}" alt="{{ $point->title }}"
                        class="img-fluid rounded shadow">
                </div>
            @endif
        </section>

        <!-- Earn Points Section -->
        <section class="earn-points-section py-5">
            <div class="row g-4">
                <!-- Hotel Stays Column -->
                @if ($point->hotel_stays_title != '')
                    <div class="col-md-4">
                        <div class="earn-points-card text-center p-4 h-100">
                            <div class="icon-wrapper mb-4">
                                <i class="{{ $point->hotel_stays_icon ?? '' }} fa-3x"></i>
                            </div>
                            <h3 class="h4 mb-3">{{ $point->hotel_stays_title ?? '' }}</h3>
                            @if ($point->hotel_stays_content)
                                <p>{!! nl2br(e($point->hotel_stays_content)) !!}</p>
                            @endif
                            @if ($point->hotel_stays_link)
                                <div class="mt-3">
                                    <a href="{{ $point->hotel_stays_link }}" class="btn btn-lalit" target="_blank"
                                        rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
                @if ($point->dining_title != '')
                    <!-- Dining Column -->
                    <div class="@if (request()->is('points/donate-points')) col-md-12 @else col-md-4 @endif">
                        <div class="earn-points-card text-center p-4 h-100">
                            @if ($point->dining_icon)
                                <div class="icon-wrapper mb-4">
                                    <i class="{{ $point->dining_icon }} fa-3x"></i>
                                </div>
                            @endif
                            <h3 class="h4 mb-3">{{ $point->dining_title ?? '' }}</h3>
                            @if ($point->dining_content)
                                <p>{!! nl2br(e($point->dining_content)) !!}</p>
                            @endif
                            @if ($point->dining_link)
                                <div class="mt-3">
                                    <a href="{{ $point->dining_link }}" class="btn btn-lalit" target="_blank"
                                        rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                @if ($point->spa_title != '')
                    <!-- Spa Column -->
                    <div class="col-md-4">
                        <div class="earn-points-card text-center p-4 h-100">
                            <div class="icon-wrapper mb-4">
                                <i class="{{ $point->spa_icon ?? '' }} fa-3x"></i>
                            </div>
                            <h3 class="h4 mb-3">{{ $point->spa_title ?? '' }}</h3>
                            @if ($point->spa_content)
                                <p>{!! nl2br(e($point->spa_content)) !!}</p>
                            @endif
                            @if ($point->spa_link)
                                <div class="mt-3">
                                    <a href="{{ $point->spa_link }}" class="btn btn-lalit" target="_blank" rel="noopener">
                                        More Details <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <!-- Centered Learn More Link - Only visible for donate-points -->
            @if (request()->is('points/donate-points'))
                <div class="text-center mt-5">
                    <a href="{{ route('charity.index') }}" class="btn ct-btn-white btn-lg">
                        Discover More <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            @endif
        </section>

        <!-- Points Earning Image Section -->
        @if ($point->points_earning_image && Storage::disk('public')->exists($point->points_earning_image))
            <section class="points-earning-image-section text-center mb-5">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <img src="{{ Storage::url($point->points_earning_image) }}"
                            alt="{{ $point->points_earning_image_alt ?? 'Points Earning Information' }}"
                            class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </section>
        @endif

    </div>

    <style>
        /* Featured Image Container - Center Image */
        .featured-image-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .featured-image-container img {
            max-width: 80%;
            max-height: 400px;
            object-fit: cover;
            display: block;
            margin: 0 auto;
        }

        /* Earn Points Section Styles */
        .earn-points-section {
            background-color: #f8f9fa;
            border-radius: 8px;
        }

        .earn-points-card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .earn-points-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .icon-wrapper {
            height: 80px;
            width: 80px;
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f5f0eb;
            border-radius: 50%;
            color: #b18645;
        }

        .header-title-line {
            width: 5.875rem;
        }

        /* Points Earning Image Section */
        .points-earning-image-section img {
            max-width: 100%;
            height: auto;
            transition: transform 0.3s ease;
        }

        .points-earning-image-section img:hover {
            transform: scale(1.02);
        }
    </style>

@endsection
