@extends('layouts.pages')

@section('title', $reward->meta_title ?? $reward->title . ' - The LaLiT Rewards')

@section('nav-portfolio', 'active')

@section('hero')
<!-- Hero Banner with Reward Image -->
<div class="hero-banner position-relative">
    <div class="hero-image">
        @if($reward->banner_image)
            <img src="{{ asset('storage/' . $reward->banner_image) }}" 
                 class="w-100" alt="{{ $reward->banner_image_alt ?? $reward->title }}" 
                 style="height: 38.563rem; object-fit: cover;">
        @elseif($reward->featured_image)
            <img src="{{ asset('storage/' . $reward->featured_image) }}" 
                 class="w-100" alt="{{ $reward->featured_image_alt ?? $reward->title }}" 
                 style="height: 38.563rem; object-fit: cover;">
        @else
            <img src="{{ asset('assets/images/hero-bg.avif') }}"
                 class="w-100" alt="Hero Background" style="height: 38.563rem; object-fit: cover;">
        @endif
    </div>
    <!-- Hero Overlay -->
    <div class="hero-overlay position-absolute top-0 start-0 w-100 h-100"
         style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.6) 100%);">
    </div>
</div>
@endsection

@section('page_nav_items')
<li class="nav-item">
    <a class="nav-link px-3" href="#overview">Overview</a>
</li>
<li class="nav-item">
    <a class="nav-link px-3" href="#details">Details</a>
</li>
<li class="nav-item">
    <a class="nav-link px-3" href="#terms">Terms & Conditions</a>
</li>
@endsection

@section('content')
<!-- Reward Title Section -->
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-lg-10 text-center">
            <h2 class="fw-bold">{{ $reward->title }}</h2>
        </div>
    </div>
</div>
<!-- Reward Content Section -->
<section id="overview" class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <!-- Reward Content -->
                <div class="reward-content bg-white shadow-sm rounded p-4 mb-5">
                    @if($reward->excerpt)
                        <div class="lead mb-4 fs-5 fw-semibold text-center">
                            {{ $reward->excerpt }}
                        </div>
                        <hr class="my-4">
                    @endif
                    
                    <div id="details" class="reward-details">
                        {!! $reward->content !!}
                    </div>                
                </div>
            </div>
        </div>
    </div>
</section>




@endsection

@push('styles')
<style>
    /* Custom styles for reward page */
    .reward-content {
        line-height: 1.8;
    }
    
    .reward-details img {
        max-width: 100%;
        height: auto;
        margin: 1.5rem 0;
    }
    
    .header-title-line {
        height: 3px;
        width: 5.875rem;
        background: #c6aa76;
        margin: 0 auto;
    }
    
    .btn-outline-gold {
        border: 2px solid #c6aa76;
        color: #c6aa76;
    }
    
    .btn-outline-gold:hover {
        background-color: #c6aa76;
        color: white;
    }
    
    .ct-btn {
        display: inline-block;
        text-decoration: none;
        padding: 0.5rem 1.5rem;
        font-weight: 600;
        border-radius: 0;
        transition: all 0.3s;
        background-color: #c6aa76;
        color: white;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.875rem;
    }
      .ct-btn:hover {
        background-color: #b09762;
        color: white;
        transform: translateY(-3px);
    }
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleButton = document.getElementById('toggleTerms');
    const termsPreview = document.getElementById('termsPreview');
    const termsFullContent = document.getElementById('termsFullContent');
    const seeMoreText = document.getElementById('seeMoreText');
    const seeLessText = document.getElementById('seeLessText');
    const chevronIcon = document.getElementById('chevronIcon');
    
    toggleButton.addEventListener('click', function() {
        termsPreview.classList.toggle('d-none');
        termsFullContent.classList.toggle('d-none');
        seeMoreText.classList.toggle('d-none');
        seeLessText.classList.toggle('d-none');
        
        // Rotate chevron icon
        if (chevronIcon) {
            if (termsFullContent.classList.contains('d-none')) {
                chevronIcon.classList.remove('fa-chevron-up');
                chevronIcon.classList.add('fa-chevron-down');
            } else {
                chevronIcon.classList.remove('fa-chevron-down');
                chevronIcon.classList.add('fa-chevron-up');
            }
        }
        
        // Smooth scroll to terms section if expanded
        if (!termsFullContent.classList.contains('d-none')) {
            setTimeout(() => {
                termsFullContent.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }, 100);
        }
    });
});
</script>
@endpush
