<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PublicPageController;
use App\Http\Controllers\CharityController;
use App\Http\Controllers\Admin\ManageHomeController;
use App\Http\Controllers\Admin\ArtisanController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\SlideController;
use App\Http\Controllers\Admin\CharityController as AdminCharityController;
use App\Http\Controllers\Admin\DonationController;
use App\Http\Controllers\Membership\MembershipController;
use App\Http\Controllers\Membership\MembershipApiController;
use App\Http\Controllers\Membership\ManageCardController;
use App\Http\Controllers\Membership\ExchangePointController;
use App\Http\Controllers\Membership\MemberBenefitsController;
use App\Http\Controllers\MembershipApiTokenController;
use Illuminate\Support\Facades\Route;

// Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/', [PublicPageController::class, 'homestatic'])->name('home');
Route::get('/homestatic', [PublicPageController::class, 'homestatic'])->name('homestatic');
Route::get('/package-details', [PublicPageController::class, 'packageDetails'])->name('package-details');
Route::get('/offers-detail', function () {
  return view('offers-detail');
})->name('offers-detail');

Route::get('/contact', function () {
  return view('contact');
})->name('contact');

// Public Membership Authentication Routes (using third-party API)
Route::prefix('membership')->name('membership.')->group(function () {
  Route::get('/check-auth', [MembershipApiController::class, 'checkAuthStatus'])->name('check-auth');
  Route::post('/login', [MembershipController::class, 'login'])->name('login');
  Route::post('/member-login', [MembershipApiController::class, 'login'])->name('member-login');
  Route::post('/send-otp', [MembershipApiController::class, 'sendOtp'])->name('send-otp');
  Route::post('/send-email-otp', [MembershipApiController::class, 'sendEmailOtp'])->name('send-email-otp');
  Route::post('/verify-email-otp', [MembershipApiController::class, 'verifyEmailOtp'])->name('verify-email-otp');
  Route::get('/test-mail', [MembershipApiController::class, 'testMail'])->name('test-mail');
  Route::post('/check-email', [MembershipApiController::class, 'checkEmailExists'])->name('check-email');
  Route::post('/check-mobile', [MembershipApiController::class, 'checkMobileExists'])->name('check-mobile');
  Route::post('/register', [MembershipApiController::class, 'register'])->name('register');
  Route::post('/validate-registration-otp', [MembershipApiController::class, 'validateRegistrationOtp'])->name('validate-registration-otp');
  Route::post('/set-password-registration', [MembershipApiController::class, 'setPasswordOnRegistration'])->name('set-password-registration');
  Route::post('/forgot-password', [MembershipController::class, 'forgotPassword'])->name('forgot-password');
  Route::post('/send-reset-otp', [MembershipApiController::class, 'sendResetPasswordOtp'])->name('send-reset-otp');
  Route::post('/reset-password', [MembershipApiController::class, 'resetPassword'])->name('reset-password');
  Route::get('/set-new-password', [MembershipController::class, 'setNewPassword'])->name('set-new-password');
  Route::post('/logout', [MembershipController::class, 'logout'])->name('logout');
  Route::post('/member-logout', [MembershipApiController::class, 'logout'])->name('member-logout');
});

// Protected Membership routes (require membership token)
// Route::prefix('membership')->name('membership.')->middleware('membership.token')->group(function () {
Route::prefix('membership')->name('membership.')->group(function () {
  Route::get('/dashboard', [MembershipController::class, 'dashboard'])->name('dashboard');
  Route::get('/edit-profile', [MembershipController::class, 'editProfile'])->name('edit-profile');
  Route::post('/update-profile', [MembershipController::class, 'updateProfile'])->name('update-profile');
  // add prefrence routes
  Route::post('/update-preferences', [MembershipController::class, 'updatePreferences'])->name('update-preferences');
  Route::post('/update-password', [MembershipApiController::class, 'changePassword'])->name('update-password');
  Route::post('/change-password', [MembershipApiController::class, 'changePassword'])->name('change-password');
  Route::get('/myrewards', [MembershipController::class, 'myRewards'])->name('myrewards');
  Route::get('/statement', [MembershipController::class, 'statement'])->name('statement');
  Route::post('/redeem-reward', [MembershipController::class, 'redeemReward'])->name('redeem-reward');

  Route::get('/exchange-points', [ExchangePointController::class, 'showExchangePoints'])->name('exchange-points');
  Route::get('/member-benefits', [MemberBenefitsController::class, 'showMembershipBenefits'])->name('member-benefits');
  Route::get('/manage-card', [ManageCardController::class, 'showManageCard'])->name('manage-card');

  // API routes for offers (must be before dynamic routes)
  Route::get('/offers/api', [MembershipApiController::class, 'getOffers'])->name('offers.api');
  Route::get('/offers/api/{offerId}', [MembershipApiController::class, 'getOfferDetails'])->name('offer-details.api');
  Route::post('/offers/api/{offerId}/acceptance', [MembershipApiController::class, 'offerAcceptance'])->name('offer-acceptance.api');
  Route::get('/sponsors/api', [MembershipApiController::class, 'getSponsors'])->name('sponsors.api');

  // Member Offers routes
  Route::get('/offers', [MembershipApiController::class, 'offers'])->name('offers');
  Route::get('/offers/{offerId}', [MembershipApiController::class, 'offerDetails'])->name('offer-details');
  Route::get('/donations', [MembershipController::class, 'donations'])->name('donations');
  Route::post('/donations/redeem', [MembershipApiController::class, 'redeemDonation'])->name('donations.redeem');
  Route::get('/participating-hotels', [MembershipController::class, 'participatingHotels'])->name('participating-hotels');
  Route::get('/rewards', [MembershipController::class, 'rewards'])->name('rewards');

  // AJAX Data Endpoints
  Route::get('/dashboard-data', [MembershipController::class, 'getDashboardData'])->name('dashboard-data');
  Route::get('/rewards-data', [MembershipController::class, 'getRewardsData'])->name('rewards-data');
  Route::get('/statement-data', [MembershipController::class, 'getStatementData'])->name('statement-data');
  
  // Transaction History API
  Route::get('/transaction-history', [MembershipApiController::class, 'getTransactionHistory'])->name('transaction-history');
  
  // Address Data Endpoints
  Route::get('/get-regions/{countryId}', [MembershipController::class, 'getRegions'])->name('get-regions');
  Route::get('/get-cities/{regionId}', [MembershipController::class, 'getCities'])->name('get-cities');
});

// Membership API authentication routes (for API integration) - also protected
Route::prefix('api/membership')->name('api.membership.')->middleware('membership.token')->group(function () {
  Route::post('/logout', [MembershipController::class, 'logout'])->name('logout');
});

Route::get('/laravel-dashboard', function () {
  return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
  Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
  Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
  Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

  // Admin routes
  Route::prefix('admin')->name('admin.')->group(function () {
    // Pages management routes (admin)
    Route::resource('pages', PageController::class);

    // Slides management routes (admin)
    Route::resource('slides', SlideController::class);

    // Manage Home routes (admin)
    Route::get('manage-home', [ManageHomeController::class, 'index'])->name('manage-home.index');
    Route::get('manage-home/{manageHome}/edit', [ManageHomeController::class, 'edit'])->name('manage-home.edit');
    Route::put('manage-home/{manageHome}', [ManageHomeController::class, 'update'])->name('manage-home.update');
    Route::post('manage-home/{manageHome}/toggle-status', [ManageHomeController::class, 'toggleStatus'])
      ->name('manage-home.toggle-status');

    // Package Details routes (admin)
    Route::get('package-details', [\App\Http\Controllers\Admin\PackageDetailController::class, 'index'])->name('package-details.index');
    Route::get('package-details/{packageDetail}/edit', [\App\Http\Controllers\Admin\PackageDetailController::class, 'edit'])->name('package-details.edit');
    Route::put('package-details/{packageDetail}', [\App\Http\Controllers\Admin\PackageDetailController::class, 'update'])->name('package-details.update');
    Route::post('package-details/{packageDetail}/toggle-status', [\App\Http\Controllers\Admin\PackageDetailController::class, 'toggleStatus'])
      ->name('package-details.toggle-status');

    // Donations management routes (admin)
    Route::resource('donations', \App\Http\Controllers\Admin\DonationController::class);
    Route::post('donations/update-order', [\App\Http\Controllers\Admin\DonationController::class, 'updateOrder'])->name('donations.update-order');

    // Participating Hotels management routes (admin)
    Route::resource('participating-hotels', \App\Http\Controllers\Admin\ParticipatingHotelController::class);

    // Rewards management routes (admin)
    Route::resource('rewards', \App\Http\Controllers\Admin\RewardController::class);

    // Benefits management routes (admin)
    Route::resource('benefits', \App\Http\Controllers\Admin\BenefitController::class);

    // Points management routes (admin)
    Route::resource('points', \App\Http\Controllers\Admin\PointController::class);

    // Tiers management routes (admin)
    Route::resource('tiers', \App\Http\Controllers\Admin\TierController::class);

    // Charities management routes (admin)
    Route::resource('charities', AdminCharityController::class);

    // FAQ management routes (admin)
    Route::resource('faqs', \App\Http\Controllers\Admin\FaqController::class);

    // Members management routes (admin) - Only for naveen@example.com
    Route::get('members', [\App\Http\Controllers\Admin\MemberController::class, 'index'])->name('members.index');
    Route::get('members/{member}', [\App\Http\Controllers\Admin\MemberController::class, 'show'])->name('members.show');
    Route::delete('members/{member}', [\App\Http\Controllers\Admin\MemberController::class, 'destroy'])->name('members.destroy');

    // Artisan commands routes (admin)
    Route::get('artisan', [ArtisanController::class, 'index'])->name('artisan.index');
    Route::post('artisan/clear-cache', [ArtisanController::class, 'clearCache'])->name('artisan.clear-cache');
    Route::post('artisan/clear-config', [ArtisanController::class, 'clearConfig'])->name('artisan.clear-config');
    Route::post('artisan/clear-route', [ArtisanController::class, 'clearRoute'])->name('artisan.clear-route');
    Route::post('artisan/clear-view', [ArtisanController::class, 'clearView'])->name('artisan.clear-view');
    Route::post('artisan/clear-all', [ArtisanController::class, 'clearAll'])->name('artisan.clear-all');
    Route::post('artisan/storage-link', [ArtisanController::class, 'storageLink'])->name('artisan.storage-link');
    Route::post('artisan/cache-config', [ArtisanController::class, 'cacheConfig'])->name('artisan.cache-config');
    Route::post('artisan/cache-route', [ArtisanController::class, 'cacheRoute'])->name('artisan.cache-route');
    Route::post('artisan/optimize', [ArtisanController::class, 'optimize'])->name('artisan.optimize');
    Route::post('artisan/migrate', [ArtisanController::class, 'migrate'])->name('artisan.migrate');

    // Membership API Tokens management routes (admin) - Only for naveen@example.com
    Route::get('membership-api-tokens', [MembershipApiTokenController::class, 'index'])->name('membership-api-tokens.index');
    Route::post('membership-api-tokens/generate', [MembershipApiTokenController::class, 'generate'])->name('membership-api-tokens.generate');
    Route::post('membership-api-tokens/refresh', [MembershipApiTokenController::class, 'refresh'])->name('membership-api-tokens.refresh');
    Route::post('membership-api-tokens/{id}/deactivate', [MembershipApiTokenController::class, 'deactivate'])->name('membership-api-tokens.deactivate');
    Route::post('membership-api-tokens/cleanup', [MembershipApiTokenController::class, 'cleanup'])->name('membership-api-tokens.cleanup');
  });
});

require __DIR__ . '/auth.php';

Route::get('/public/home', [PublicPageController::class, 'test'])->name('pages.test');
Route::get('/rewards/{slug}', [PublicPageController::class, 'rewards'])->name('pages.rewards');
Route::get('/tiers/{slug}', [PublicPageController::class, 'tiers'])->name('pages.tiers');
Route::get('/points/{slug}', [PublicPageController::class, 'points'])->name('pages.points');
Route::get('/faqs', [PublicPageController::class, 'faqs'])->name('pages.faqs');
Route::get('/contact', [PublicPageController::class, 'contact'])->name('pages.contact');
Route::get('/charity', [CharityController::class, 'index'])->name('charity.index');
Route::get('/charity/{charity}', [CharityController::class, 'show'])->name('charity.show');

// Test API Integration
Route::get('/test-api-integration', function () {
    // Set up test session data
    session([
        'member_id' => 1,
        'api_member_id' => '7201010365',
        'member_number' => '7201010365',
        'member_name' => 'Test User',
        'member_token' => 'test_token_123'
    ]);
    
    return redirect()->route('membership.edit-profile');
})->name('test.api.integration');

// Public page routes
Route::get('/{slug}', [PublicPageController::class, 'showBySlug'])->name('pages.public');
