<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo $__env->yieldContent('title', 'The LaLiT Hotels'); ?></title>

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.bunny.net">
  <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

  <!-- Scripts -->
  <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
  <!-- Bootstrap 5 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

  <!-- Optional Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>" />
  <style>
    /* Mobile Offcanvas Menu Styles */
    .offcanvas {
      width: 300px !important;
      background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    }

    .offcanvas-header {
      background-color: #c6aa76;
      color: white;
      padding: 1.5rem;
      border-bottom: 3px solid #b39968;
    }

    .offcanvas-title {
      font-size: 1.5rem;
      font-weight: 700;
      letter-spacing: 0.5px;
      color: white;
    }

    .offcanvas .btn-close {
      filter: brightness(0) invert(1);
      opacity: 1;
    }

    .offcanvas-body {
      padding: 1.5rem 1rem;
    }

    /* Mobile Navigation Links */
    .mobile-nav-link {
      color: #212322 !important;
      font-weight: 500;
      font-size: 1rem;
      padding: 0.875rem 1.25rem !important;
      margin-bottom: 0.5rem;
      border-radius: 8px;
      transition: all 0.3s ease;
      display: flex;
      align-items: center;
      background-color: transparent;
    }

    .mobile-nav-link:hover,
    .mobile-nav-link:focus {
      color: #c6aa76 !important;
      background-color: rgba(198, 170, 118, 0.1);
      transform: translateX(5px);
    }

    .mobile-nav-link::before {
      content: "▸";
      margin-right: 0.75rem;
      color: #c6aa76;
      font-size: 1.1rem;
      transition: transform 0.3s ease;
    }

    .mobile-nav-link:hover::before {
      transform: translateX(3px);
    }

    /* Mobile Menu Footer */
    #offcanvasFooter {
      border-top: 2px solid #e9ecef !important;
      padding-top: 1.5rem !important;
      margin-top: 1.5rem !important;
    }

    #offcanvasFooter .ct-btn {
      padding: 0.875rem 1.25rem;
      font-weight: 700;
      border-radius: 10px;
      transition: all 0.3s ease;
      text-transform: uppercase;
      font-size: 0.8rem;
      letter-spacing: 1px;
      border: none;
      background: linear-gradient(135deg, #212322 0%, #000000 100%);
      color: white;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
      text-decoration: none;
      display: block;
      position: relative;
      overflow: hidden;
    }

    #offcanvasFooter .ct-btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, #c6aa76 0%, #b39968 100%);
      transition: left 0.4s ease;
      z-index: 0;
    }

    #offcanvasFooter .ct-btn:hover::before {
      left: 0;
    }

    #offcanvasFooter .ct-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 6px 20px rgba(198, 170, 118, 0.4);
    }

    #offcanvasFooter .ct-btn span,
    #offcanvasFooter .ct-btn:not(:has(span)) {
      position: relative;
      z-index: 1;
    }

    /* Special styling for Book Your Stay button */
    #offcanvasFooter .ct-btn:last-child {
      background: linear-gradient(135deg, #c6aa76 0%, #b39968 100%);
    }

    #offcanvasFooter .ct-btn:last-child::before {
      background: linear-gradient(135deg, #212322 0%, #000000 100%);
    }

    #offcanvasFooter .gap-2 {
      gap: 0.75rem !important;
    }

    /* Primary Navigation Menu */
    .site-header {
      position: relative;
      z-index: 1030;
      width: 100%;
    }

    .carousel-nav-menu {
      background-color: #f5f0eb;
      /* padding: 0.75rem 1rem; */
    }

    /* Secondary Navigation Styles */
    .secondary-nav {
      border-top: 1px solid rgba(0, 0, 0, 0.05);
    }

    .secondary-nav-links .nav-link {
      color: #212322;
      font-weight: 500;
      padding: 0.5rem 1rem;
      transition: all 0.2s ease;
    }

    .secondary-nav-links .nav-link:hover,
    .secondary-nav-links .nav-link:focus {
      color: #c6aa76;
    }

    /* For better visibility on mobile */
    @media (max-width: 768px) {
      .carousel-nav-menu {
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        padding: 0.5rem;
      }

      /* .site-header {
                position: sticky;
                top: 0;
                z-index: 1030;
            } */

      .logo img {
        max-height: 40px !important;
      }

      .hero-container {
        width: 100%;
        overflow: hidden;
        position: relative;
      }

      h1.page-title {
        font-size: 1.75rem;
        margin-top: 1rem;
        margin-bottom: 1rem;
        text-align: center;
        color: #212322;
        font-weight: 600;
      }
    }

    /* Sticky Navigation Styles */
    #sticky-page-nav {
      transition: all 0.3s ease;
      z-index: 1020;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    #sticky-page-nav .container-fluid {
      background-color: rgba(255, 255, 255, 0.97) !important;
      backdrop-filter: blur(10px);
    }

    #sticky-page-nav .sticky-logo img {
      transition: all 0.3s ease;
    }

    #sticky-page-nav .secondary-navigation .nav-link {
      color: #444;
      font-size: 0.9rem;
      font-weight: 500;
      padding: 0.5rem 1rem;
      transition: all 0.2s ease;
      margin: 0 0.2rem;
    }

    #sticky-page-nav .secondary-navigation .nav-link:hover {
      color: #c6aa76;
    }

    #sticky-page-nav .secondary-navigation .nav-link.active {
      color: #c6aa76;
      font-weight: 600;
      background-color: transparent;
    }



    #sticky-page-nav .btn-primary {
      background-color: #c6aa76;
      border-color: #c6aa76;
      padding: 0.375rem 1rem;
      font-weight: 600;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
    }

    #sticky-page-nav .btn-primary:hover {
      background-color: #b09762;
      border-color: #b09762;
      transform: translateY(-2px);
    }

    @media (max-width: 991px) {
      #sticky-page-nav .secondary-navigation {
        display: none !important;
      }

      #sticky-page-nav .nav-action {
        margin-left: auto;
      }
    }

    @media (max-width: 768px) {
      #sticky-page-nav .sticky-logo img {
        height: 32px;
      }
    }

    /* Login Modal Tab Styles */
    .login-tab-btn {
      background-color: transparent !important;
      border: 2px solid #e5e5e5 !important;
      color: #666 !important;
      font-weight: 500;
      padding: 0.75rem 1rem;
      border-radius: 8px;
      transition: all 0.3s ease;
      margin: 0 0.25rem;
      white-space: nowrap;
      text-align: center;
    }

    /* Ensure tabs stay in same row */
    #loginTabs {
      display: flex !important;
      flex-wrap: nowrap;
      gap: 0.5rem;
    }

    #loginTabs .nav-link {
      flex: 1;
      min-width: 0;
    }

    .login-tab-btn:hover {
      background-color: #f8f9fa !important;
      border-color: #c6aa76 !important;
      color: #c6aa76 !important;
    }

    .login-tab-btn.active {
      background-color: #c6aa76 !important;
      border-color: #c6aa76 !important;
      color: white !important;
      font-weight: 600;
    }

    .login-tab-btn.active:hover {
      background-color: #b09762 !important;
      border-color: #b09762 !important;
      color: white !important;
    }

    /* Tab content transitions */
    .tab-pane {
      transition: all 0.3s ease-in-out;
    }

    /* Send OTP Button */
    #sendOtpBtn:hover {
      text-decoration: underline !important;
    }

    #sendOtpBtn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
    }

    /* Mobile responsive for login tabs */
    @media (max-width: 576px) {
      .login-tab-btn {
        font-size: 0.875rem;
        padding: 0.5rem 0.75rem;
      }

      .login-tab-btn i {
        display: none;
      }
    }
  </style>

  <?php echo $__env->yieldPushContent('styles'); ?>
  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-GTG6Q4XPMZ"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag() { dataLayer.push(arguments); }
    gtag('js', new Date());

    gtag('config', 'G-GTG6Q4XPMZ');
  </script>
</head>

<body class="page-layout font-sans antialiased bg-gray-50 dark:bg-gray-900">
  <header class="site-header">
    <!-- Primary Navigation Header -->
    <div class="carousel-nav-menu px-3" style="background-color: #f5f0eb;">
      <div class="d-flex justify-content-between align-items-center py-2">
        <!-- Left Side - Toggle Button for Mobile / Empty space for Desktop -->
        <div class="nav-left">
          <button class="btn btn-outline-dark d-lg-none" type="button" data-bs-toggle="offcanvas"
            data-bs-target="#offcanvasMenu">
            ☰
          </button>
          <!-- Empty space for desktop to balance layout -->
          <div class="d-none d-lg-block" style="width: 200px;"></div>
        </div>

        <!-- Center Logo -->
        <div class="logo">
          <a href="/">
            <img src="<?php echo e(asset('assets/images/logo-black-lalit.png')); ?>" alt="Logo" class="img-fluid">
          </a>
        </div>

        <!-- Right Side - Desktop Menu / Mobile Login -->
        <div class="nav-right">
          <!-- Desktop Menu -->
          <ul class="nav nav-pills d-none d-lg-flex" id="desktopNavMenu">
            <li class="nav-item" id="loginNavItem">
              <a href="#" class="nav-link" data-bs-toggle="modal" data-bs-target="#loginModal">
                Login
              </a>
            </li>
            <li class="nav-item d-none" id="dashboardNavItem">
              <a href="<?php echo e(route('membership.dashboard')); ?>" class="nav-link">
                Dashboard
              </a>
            </li>
            <li class="nav-item d-none" id="logoutNavItem">
              <a href="#" class="nav-link" id="logoutBtn">
                Logout
              </a>
            </li>
            <li class="nav-item"><a class="nav-link" href="https://www.thelalit.com/">Book your stay</a>
            </li>
            <li class="nav-item" id="joinNowNavItem"><a class="nav-link" href="#" data-bs-toggle="modal"
                data-bs-target="#signupModal">Sign Up</a></li>
          </ul>

          <!-- Login Button for Mobile (visible only on mobile) -->
          <div class="d-lg-none" id="mobileNavActions">
            <a href="#" class="btn btn-sm" data-bs-toggle="modal" data-bs-target="#loginModal" id="mobileLoginBtn">
              Login
            </a>
            <a href="<?php echo e(route('membership.dashboard')); ?>" class="btn btn-outline-dark btn-sm d-none"
              id="mobileDashboardBtn">
              Dashboard
            </a>
            <a href="#" class="btn btn-outline-dark btn-sm d-none" id="mobileLogoutBtn">
              Logout
            </a>
          </div>
        </div>
      </div>

      <!-- Secondary Navigation Header -->
      <div class="secondary-nav">
        <div class="container-fluid px-3">
          <div class="d-flex justify-content-center align-items-center">
            <!-- Secondary Navigation Links -->
            <ul class="nav nav-pills secondary-nav-links">
              <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership
                  Tiers</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/offers-detail')); ?>">Offers</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>

    <!-- Mobile Offcanvas Menu -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasMenu">
      <div class="offcanvas-header">
        <h5 class="offcanvas-title">The LaLiT Loyalty</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body d-flex flex-column">
        <nav>
          <ul class="nav flex-column">
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership
                Tiers</a></li>
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/offers-detail')); ?>">Offers</a></li>
            <li class="nav-item"><a class="nav-link mobile-nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
          </ul>
        </nav>
        <!-- Mobile Menu Footer -->
        <div class="mt-auto" id="offcanvasFooter">
          <div class="d-flex flex-column gap-2">
            <a href="#" class="ct-btn text-center" data-bs-toggle="modal" data-bs-target="#loginModal"
              data-bs-dismiss="offcanvas" id="offcanvasLoginBtn"><i class="fas fa-sign-in-alt me-2"></i>Login</a>
            <a href="<?php echo e(route('membership.dashboard')); ?>" class="ct-btn text-center d-none" data-bs-dismiss="offcanvas"
              id="offcanvasDashboardBtn"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</a>
            <a href="#" class="ct-btn text-center d-none" id="offcanvasLogoutBtn"><i
                class="fas fa-sign-out-alt me-2"></i>Logout</a>
            <a href="https://thelalitloyalty.in/#/landingpage" target="_blank" class="ct-btn text-center"
              id="offcanvasJoinBtn"><i class="fas fa-user-plus me-2"></i>Join Now</a>
            <a href="https://www.thelalit.com/" target="_blank" class="ct-btn text-center"><i
                class="fas fa-hotel me-2"></i>Book Your Stay</a>
          </div>
        </div>
      </div>
    </div>

    <?php if (! empty(trim($__env->yieldContent('hero')))): ?>
      <div class="hero-container">
        <?php echo $__env->yieldContent('hero'); ?>
      </div>
    <?php endif; ?>
  </header>

  <!-- Sticky Page Navigation -->
  <div id="sticky-page-nav" class="sticky-top d-none">
    <div class="container-fluid py-2 bg-white border-bottom shadow-sm">
      <div class="container">
        <!-- Main Navigation Row -->
        <div class="d-flex justify-content-between align-items-center">
          <!-- Logo instead of page title -->
          <div class="sticky-logo">
            <a href="<?php echo e(route('homestatic')); ?>">
              <img src="<?php echo e(asset('assets/images/logo-black-lalit.png')); ?>" alt="Logo" class="img-fluid"
                style="height: 40px;">
            </a>
          </div>

          <!-- Secondary Navigation Links -->
          <nav class="secondary-navigation d-none d-lg-block">
            <ul class="nav nav-pills secondary-nav-links">
              <li class="nav-item"><a class="nav-link" href="/">Home</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/about-us')); ?>">About</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#membership-tier">Membership
                  Tiers</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>#rewards">Rewards</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/offers-detail')); ?>">Offers</a></li>
              <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contact-us')); ?>">Contact</a></li>
            </ul>
          </nav>

          <div class="nav-action">
            <a href="https://thelalitloyalty.in/#/landingpage" class="btn btn-sm btn-primary">Join Now</a>
          </div>
        </div>


      </div>
    </div>
  </div>

  <!-- Page Title Section - Will be shown on mobile views -->
  <?php if (! empty(trim($__env->yieldContent('page_title')))): ?>
    <div class="page-title-container d-md-none bg-white py-3">
      <div class="container">
        <h1 class="page-title"><?php echo $__env->yieldContent('page_title'); ?></h1>
      </div>
    </div>
  <?php endif; ?>

  <!-- Main Content -->
  <main>
    <?php echo $__env->yieldContent('content'); ?>
  </main>

  <!-- Footer -->
  <footer class="py-3" style="background-color: #f5f0eb;">
    <div class="container">
      <div class="row">
        <!-- Links Sections -->
        <div class="col-lg-8">
          <div class="row">
            <!-- First Column -->
            <div class="col-md-6">
              <h5 class="mb-3" style="color: #212322;">Quick Links</h5>
              <ul class="list-unstyled">
                <li class="mb-2"><a href="/about-us" class="text-decoration-none"
                    style="color: #212322; opacity: 0.7;">About The LaLiT Loyalty</a></li>
                <li class="mb-2"><a href="/contact-us" class="text-decoration-none"
                    style="color: #212322; opacity: 0.7;">Contact Us</a></li>
                <li class="mb-2"><a href="/faqs" class="text-decoration-none"
                    style="color: #212322; opacity: 0.7;">FAQs</a></li>
              </ul>
            </div>

            <!-- Second Column -->
            <div class="col-md-6 mb-4">
              <ul class="list-unstyled">
                <li class="mb-2"><a href="/terms-condition" class="text-decoration-none"
                    style="color: #212322; opacity: 0.7;">Terms & Conditions</a></li>
                <li class="mb-2"><a href="/privacy-policy" class="text-decoration-none"
                    style="color: #212322; opacity: 0.7;">Privacy Policy</a></li>
              </ul>
            </div>
          </div>
        </div>

        <!-- Social Media Section -->
        
      </div>

      <!-- Copyright Section -->
      <hr class="my-3 border-secondary">
      <div class="row align-items-center">
        <div class="col-md-6">
          <p class="mb-0" style="color: #212322; opacity: 0.7;">&copy; <?php echo e(date('Y')); ?> The LaLiT Hotels. All
            rights reserved.</p>
        </div>
        <div class="col-md-6 text-md-end">
          <img src="<?php echo e(asset('assets/images/logo-black-lalit.png')); ?>" alt="Logo" class="img-fluid"
            style="max-height: 100px;">
        </div>
      </div>
    </div>
  </footer>

  <!-- Login Modal -->
  <div class="modal fade lalit-login-modal" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header border-0 relative bg-gradient-to-br p-8 pb-4">
          <button type="button" class="btn-close absolute top-4 right-4" data-bs-dismiss="modal"
            aria-label="Close"></button>
          <div class="w-full text-center">
            <h4 class="text-2xl font-bold mb-1 text-slate-700">Log in to your</h4>
            <h5 class="text-lg font-normal text-gray-500 mb-0">The LaLit Loyalty Account</h5>
          </div>
        </div>

        <div class="modal-body px-6 py-6 flex-grow">
          <!-- Error Display Area -->
          <div id="loginErrorAlert" class="alert alert-danger d-none mb-4" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <span id="loginErrorMessage">Incorrect login details. Please try again.</span>
          </div>

          <!-- Loading Overlay -->
          <div id="loginLoadingOverlay" class="position-absolute top-0 start-0 w-100 h-100 d-none"
            style="background: rgba(255,255,255,0.9); z-index: 10; border-radius: 0 0 12px 12px;">
            <div class="d-flex align-items-center justify-content-center h-100">
              <div class="text-center">
                <div class="spinner-border text-primary mb-2" role="status">
                  <span class="visually-hidden">Loading...</span>
                </div>
                <div class="text-muted">Logging in...</div>
              </div>
            </div>
          </div>

          <!-- Login Method Tabs -->
          <div class="mb-6">
            <div class="nav nav-pills d-flex" id="loginTabs" role="tablist">
              <button class="nav-link active login-tab-btn flex-fill" id="mobile-tab" data-bs-toggle="pill"
                data-bs-target="#mobile-login" type="button" role="tab" aria-controls="mobile-login"
                aria-selected="true">
                <i class="fas fa-mobile-alt me-2"></i>Login by Mobile
              </button>
              <button class="nav-link login-tab-btn flex-fill" id="member-tab" data-bs-toggle="pill"
                data-bs-target="#member-login" type="button" role="tab" aria-controls="member-login"
                aria-selected="false">
                <i class="fas fa-id-card me-2"></i>Login by Member ID
              </button>
            </div>
          </div>

          <form id="loginForm" action="<?php echo e(route('membership.login')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Hidden field to track login method -->
            <input type="hidden" id="login_method" name="login_method" value="mobile">

            <!-- Tab Content -->
            <div class="tab-content" id="loginTabContent">
              <!-- Mobile Login Tab -->
              <div class="tab-pane fade show active" id="mobile-login" role="tabpanel" aria-labelledby="mobile-tab">

                <!-- Mobile Number Field -->
                <div class="mb-8">
                  <div class="row">
                    <!-- Country Code Field -->
                    <div class="col-4">
                      <label for="country_code_login"
                        class="block text-sm font-medium mb-3 text-orange-600">Country</label>
                      <select
                        class="form-select lalit-input w-full text-base bg-transparent border-0 border-b border-orange-400 rounded-none px-0 py-2 focus:outline-none focus:border-orange-500 focus:ring-0"
                        id="country_code_login" name="country_code" disabled>
                        <option value="+91" selected>+91</option>
                      </select>
                    </div>
                    <!-- Mobile Number Field -->
                    <div class="col-8">
                      <label for="mobile_number" class="block text-sm font-medium mb-3 text-orange-600">Mobile
                        Number</label>
                      <input type="tel"
                        class="lalit-input w-full text-base bg-transparent border-0 border-b border-orange-400 rounded-none px-0 py-2 focus:outline-none focus:border-orange-500 focus:ring-0"
                        id="mobile_number" name="mobile_number" value="" placeholder="Enter your mobile number"
                        maxlength="10">
                    </div>
                  </div>
                </div>

                <!-- OTP Field -->
                <div class="mb-6 relative">
                  <div class="d-flex justify-content-between align-items-center mb-3">
                    <label for="otp" class="block text-sm font-medium text-orange-600">OTP</label>
                    <button type="button" id="sendOtpBtn"
                      class="btn btn-sm text-orange-500 p-0 border-0 bg-transparent text-decoration-none hover:text-orange-600"
                      style="font-size: 0.875rem;">
                      <i class="fas fa-paper-plane me-1"></i>Send OTP
                    </button>
                  </div>
                  <input type="text"
                    class="lalit-input w-full text-base bg-transparent border-0 border-b border-orange-400 rounded-none px-0 py-2 focus:outline-none focus:border-orange-500 focus:ring-0"
                    id="otp" name="otp" value="" placeholder="Enter OTP" maxlength="6">
                </div>
              </div>

              <!-- Member ID Login Tab -->
              <div class="tab-pane fade" id="member-login" role="tabpanel" aria-labelledby="member-tab">

                <!-- Membership Number Field -->
                <div class="mb-8">
                  <label for="membership_number" class="block text-sm font-medium mb-3 text-orange-600">Membership
                    Number</label>
                  <input type="text"
                    class="lalit-input w-full text-base bg-transparent border-0 border-b border-orange-400 rounded-none px-0 py-2 focus:outline-none focus:border-orange-500 focus:ring-0"
                    id="membership_number" name="membership_number" value="" placeholder="Enter Membership number">
                </div>

                <!-- Password Field -->
                <div class="mb-6 relative">
                  <label for="loginPassword" class="block text-sm font-medium mb-3 text-orange-600">Password</label>
                  <div class="relative">
                    <input type="password"
                      class="lalit-input w-full text-base bg-transparent border-0 border-b border-orange-400 rounded-none px-0 py-2 pr-8 focus:outline-none focus:border-orange-500 focus:ring-0"
                      id="loginPassword" name="password" value="" placeholder="Enter Password">
                    <button class="absolute right-0 top-2 p-1 border-0 bg-transparent text-gray-500 hover:text-gray-700"
                      type="button" id="togglePassword">
                      <i class="fas fa-eye text-sm"></i>
                    </button>
                  </div>
                </div>

                <!-- Forgot Password Link -->
                <div class="mb-6 text-left">
                  <a href="#" class="text-orange-500 text-sm no-underline hover:text-orange-600"
                    id="forgotPasswordLink">Forgot Password</a>
                </div>
              </div>
            </div>

            <!-- Login Button -->
            <div class="mb-4">
              <button type="submit" class="w-full btn-lg ct-btn" id="loginSubmitBtn">
                <span class="login-btn-text">LOG IN</span>
                <span class="login-btn-loading d-none">
                  <i class="fas fa-spinner fa-spin me-2"></i>Logging in...
                </span>
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Signup Modal -->
  <div class="modal fade lalit-login-modal" id="signupModal" tabindex="-1" aria-labelledby="signupModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header border-0 relative bg-gradient-to-br p-8 pb-4">
          <button type="button" class="btn-close absolute top-4 right-4" data-bs-dismiss="modal"
            aria-label="Close"></button>
          <div class="w-full text-center">
            <h4 class="text-2xl font-bold mb-1 text-slate-700">Join</h4>
            <h5 class="text-lg font-normal text-gray-500 mb-0">The LaLit Loyalty</h5>
            <p>for a world of exclusive privileges. Program open to only Indian Residents</p>
          </div>
        </div>

        <div class="modal-body px-6 py-6 flex-grow">
          <!-- Error Display Area -->
          <div id="signupErrorAlert" class="alert alert-danger d-none mb-4" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <span id="signupErrorMessage">Registration failed. Please try again.</span>
          </div>

          <!-- Success Display Area -->
          <div id="signupSuccessAlert" class="alert alert-success d-none mb-4" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <span id="signupSuccessMessage">Registration successful! Please check your email.</span>
          </div>

          <!-- Loading Overlay -->
          <div id="signupLoadingOverlay" class="position-absolute top-0 start-0 w-100 h-100 d-none"
            style="background: rgba(255,255,255,0.9); z-index: 10; border-radius: 0 0 12px 12px;">
            <div class="d-flex align-items-center justify-content-center h-100">
              <div class="text-center">
                <div class="spinner-border text-primary mb-2" role="status">
                  <span class="visually-hidden">Loading...</span>
                </div>
                <div class="text-muted">Creating your account...</div>
              </div>
            </div>
          </div>

          <form id="signupForm" action="<?php echo e(route('membership.register')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Step 1: Basic Information -->
            <div id="signupStep1">
              <!-- First Name Field -->
              <div class="mb-4">
                <label for="first_name" class="block text-sm font-medium mb-2 text-orange-600">First Name
                  <span class="text-red-500">*</span></label>
                <input type="text"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="first_name" name="first_name" placeholder="Enter your first name as per govt. Id" required>
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              </div>

              <!-- Last Name Field -->
              <div class="mb-4">
                <label for="last_name" class="block text-sm font-medium mb-2 text-orange-600">Last Name
                  <span class="text-red-500">*</span></label>
                <input type="text"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="last_name" name="last_name" placeholder="Enter your last name as per govt. Id" required>
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              </div>

              <!-- Mobile Field -->
              <div class="mb-4">
                <div class="row">
                  <!-- Country Code Field -->
                  <div class="col-4">
                    <label for="country_code_signup" class="block text-sm font-medium mb-2 text-orange-600">Country
                      <span class="text-red-500">*</span></label>
                    <select
                      class="form-select w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                      id="country_code_signup" name="country_code" disabled required>
                      <option value="+91" selected>+91</option>
                    </select>
                  </div>
                  <!-- Mobile Number Field -->
                  <div class="col-8">
                    <label for="mobile" class="block text-sm font-medium mb-2 text-orange-600">Mobile
                      Number <span class="text-red-500">*</span></label>
                    <input type="tel"
                      class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                      id="mobile" name="mobile" placeholder="Enter your mobile number" pattern="[0-9]{10}"
                      maxlength="10" required>
                    <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
                    <small class="text-gray-500 text-xs">10-digit mobile number</small>
                  </div>
                </div>
              </div>

              <!-- Email Field -->
              <div class="mb-4">
                <label for="email" class="block text-sm font-medium mb-2 text-orange-600">Email <span
                    class="text-red-500">*</span></label>
                <input type="email"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="email" name="email" placeholder="Enter your valid email address" required>
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
                <div id="emailOtpSuccess" class="text-green-600 text-sm mt-1 d-none"></div>
                <div class="text-end">
                  <button type="button" class="btn btn-outline-orange px-4 py-2 mt-2" id="sendEmailOtpBtn" style="border-color: #f97316; color: #f97316;">
                    <span class="send-otp-text">SEND OTP</span>
                    <span class="send-otp-loading d-none">
                      <i class="fas fa-spinner fa-spin"></i>
                    </span>
                  </button>
                </div>
              </div>

              <!-- Email OTP Field (Hidden initially) -->
              <div class="mb-4 d-none" id="emailOtpField">
                <label for="email_otp" class="block text-sm font-medium mb-2 text-orange-600">Enter OTP <span
                    class="text-red-500">*</span></label>
                <input type="text"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="email_otp" name="email_otp" placeholder="Enter 6-digit OTP sent to your email" 
                  maxlength="6" pattern="[0-9]{6}">
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
                <div id="emailOtpError" class="text-red-500 text-sm mt-1 d-none"></div>
                <div id="emailOtpVerified" class="text-green-600 text-sm mt-1 d-none">
                  <i class="fas fa-check-circle me-1"></i>Email verified successfully!
                </div>
                <small class="text-gray-500 text-xs">OTP is valid for 10 minutes</small>
              </div>

              <!-- Terms and Conditions Checkbox -->
              <div class="mb-4">
                <div class="form-check">
                  <input type="checkbox" class="form-check-input" id="terms_accepted" name="terms_accepted" required>
                  <label class="form-check-label text-sm text-gray-700 lh-base" for="terms_accepted">
                    By joining, I agree to The LaLit Loyalty
                    <a href="/terms-condition" target="_blank"
                      class="text-orange-500 hover:text-orange-600 text-decoration-underline">Terms
                      and Conditions.</a> <span class="text-red-500">*</span>
                  </label>
                  <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
                </div>
              </div>

              <!-- Continue Button -->
              <div class="mb-4">
                <button type="button" class="w-full btn-lg ct-btn" id="signupContinueBtn">
                  <span class="signup-continue-text">CONTINUE</span>
                  <span class="signup-continue-loading d-none">
                    <i class="fas fa-spinner fa-spin me-2"></i>Creating account...
                  </span>
                </button>
              </div>
            </div>

            <!-- Step 2: OTP and Password Setup (Hidden initially) -->
            <div id="signupStep2" class="d-none">
              <input type="hidden" id="member_id" name="member_id">
              <input type="hidden" id="member_email" name="member_email">

              <!-- Back Button -->
              <div class="mb-4">
                <button type="button" class="btn btn-outline-secondary" id="signupBackBtn">
                  <i class="fas fa-arrow-left me-2"></i>BACK
                </button>
              </div>

              <!-- Info Message -->
              <div class="alert alert-info mb-4">
                <i class="fas fa-info-circle me-2"></i>
                <span>An OTP has been sent to your registered mobile number during registration. Please enter it below along with your desired password to complete your registration.</span>
              </div>

              <!-- OTP Field -->
              <div class="mb-4">
                <label for="signup_otp" class="block text-sm font-medium mb-2 text-orange-600">Enter OTP
                  <span class="text-red-500">*</span></label>
                <input type="text"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="signup_otp" name="otp" placeholder="Enter 6-digit OTP" maxlength="6" pattern="[0-9]{6}">
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              </div>

              <!-- Password Field -->
              <div class="mb-4">
                <label for="signup_password" class="block text-sm font-medium mb-2 text-orange-600">Password
                  <span class="text-red-500">*</span></label>
                <input type="password"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="signup_password" name="password" placeholder="Enter your password" minlength="8">
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
                <small class="text-gray-500 text-xs">Password must contain at least 8 characters with one upper case alphabet and one numeric character.</small>
              </div>

              <!-- Confirm Password Field -->
              <div class="mb-4">
                <label for="signup_confirm_password" class="block text-sm font-medium mb-2 text-orange-600">Confirm
                  Password
                  <span class="text-red-500">*</span></label>
                <input type="password"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="signup_confirm_password" name="confirm_password" placeholder="Confirm your password"
                  minlength="8">
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              </div>

              <!-- Complete Registration Button -->
              <div class="mb-4">
                <button type="submit" class="w-full btn-lg ct-btn" id="signupSubmitBtn">
                  <span class="signup-btn-text">COMPLETE REGISTRATION</span>
                  <span class="signup-btn-loading d-none">
                    <i class="fas fa-spinner fa-spin me-2"></i>Verifying...
                  </span>
                </button>
              </div>
            </div>

            <!-- Already Have Account -->
            <div class="text-center">
              <p class="mb-0 text-gray-500 text-sm">
                Already have an account?
                <a href="#" class="text-orange-500 no-underline hover:text-orange-600" data-bs-toggle="modal"
                  data-bs-target="#loginModal" data-bs-dismiss="modal">
                  <strong>Log In</strong>
                </a>
              </p>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Forgot Password Modal -->
  <div class="modal fade lalit-login-modal" id="forgotPasswordModal" tabindex="-1"
    aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header border-0 pb-0">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body px-5 pb-5">
          <!-- Header -->
          <div class="text-center mb-4">
            <h2 class="modal-title text-2xl font-bold text-gray-800 mb-2" id="forgotPasswordModalLabel">
              Forgot Password</h2>
            <p class="text-gray-600 text-sm">Enter your email address to receive a OTP on your email and associated mobile number
              to reset password</p>
          </div>

          <!-- Alert Messages -->
          <div id="forgotPasswordAlert" class="alert d-none mb-4" role="alert"></div>

          <!-- Step 1: Send OTP Form -->
          <form id="sendOtpForm">
            <?php echo csrf_field(); ?>
            <div id="emailStep">
              <!-- Email Field -->
              <div class="mb-4">
                <label for="resetEmail" class="block text-sm font-medium mb-2 text-orange-600">Email
                  Address <span class="text-red-500">*</span></label>
                <input type="email"
                  class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                  id="resetEmail" name="email" placeholder="Enter your email address" required>
                <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              </div>

              <!-- Send OTP Button -->
              <div class="mb-4">
                <button type="submit" class="w-full btn-lg ct-btn" id="sendResetOtpBtn">
                  <span class="send-otp-text">SEND OTP</span>
                  <span class="send-otp-loading d-none">
                    <i class="fas fa-spinner fa-spin me-2"></i>Sending...
                  </span>
                </button>
              </div>
            </div>
          </form>

          <!-- Step 2: Reset Password Form -->
          <form id="resetPasswordForm" class="d-none">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="resetPasswordEmail" name="email">

            <!-- OTP Code Field -->
            <div class="mb-4">
              <label for="resetKey" class="block text-sm font-medium mb-2 text-orange-600">OTP Code <span
                  class="text-red-500">*</span></label>
              <input type="text"
                class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                id="resetKey" name="reset_key" placeholder="Enter OTP code from email" required>
              <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
            </div>

            <!-- New Password Field -->
            <div class="mb-4">
              <label for="newPassword" class="block text-sm font-medium mb-2 text-orange-600">New Password
                <span class="text-red-500">*</span></label>
              <input type="password"
                class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                id="newPassword" name="new_password" placeholder="Enter new password" minlength="6" required>
              <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
              <small class="text-gray-500 text-xs">Password must contain at least 8 characters with one uppercase alphabet and one numeric character.</small>
            </div>

            <!-- Confirm Password Field -->
            <div class="mb-4">
              <label for="confirmPassword" class="block text-sm font-medium mb-2 text-orange-600">Confirm
                Password <span class="text-red-500">*</span></label>
              <input type="password"
                class="form-control w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 focus:border-orange-500 transition duration-200"
                id="confirmPassword" name="confirm_password" placeholder="Confirm new password" minlength="6" required>
              <div class="invalid-feedback text-red-500 text-sm mt-1"></div>
            </div>

            <!-- Reset Password Button -->
            <div class="mb-4">
              <button type="submit" class="w-full btn-lg ct-btn" id="resetPasswordBtn">
                <span class="reset-password-text">RESET PASSWORD</span>
                <span class="reset-password-loading d-none">
                  <i class="fas fa-spinner fa-spin me-2"></i>Resetting...
                </span>
              </button>
            </div>

            <!-- Resend OTP Link -->
            <div class="text-center">
              <a href="#" id="resendOtpLink" class="text-orange-500 text-sm no-underline hover:text-orange-600">
                Didn't receive the code? Resend OTP
              </a>
            </div>
          </form>

          <!-- Back to Login -->
          <div class="text-center mt-4">
            <a href="#" class="text-gray-600 text-sm no-underline hover:text-gray-800" data-bs-toggle="modal"
              data-bs-target="#loginModal" data-bs-dismiss="modal">
              <i class="fas fa-arrow-left me-1"></i> Back to Login
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php echo $__env->yieldPushContent('scripts'); ?>

  <script>
    document.addEventListener('DOMContentLoaded', function () {
      const header = document.querySelector('header');
      const stickyNav = document.getElementById('sticky-page-nav');
      const navLinks = document.querySelectorAll('#sticky-page-nav .nav-link');

      // Fix for mobile navigation links in off-canvas menu
      const mobileNavLinks = document.querySelectorAll('.mobile-nav-link');
      const offcanvasMenu = document.getElementById('offcanvasMenu');

      mobileNavLinks.forEach(link => {
        link.addEventListener('click', function (e) {
          const href = this.getAttribute('href');
          const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasMenu);

          // If it's a hash link, handle special navigation
          if (href.startsWith('#')) {
            e.preventDefault();

            // Close the offcanvas menu
            if (bsOffcanvas) {
              bsOffcanvas.hide();

              // Wait for offcanvas to close before scrolling
              offcanvasMenu.addEventListener('hidden.bs.offcanvas', function scrollToTarget() {
                const targetElement = document.querySelector(href);
                if (targetElement) {
                  setTimeout(() => {
                    window.scrollTo({
                      top: targetElement.offsetTop - 100,
                      behavior: 'smooth'
                    });
                  }, 150);
                }
                // Remove event listener to avoid multiple executions
                offcanvasMenu.removeEventListener('hidden.bs.offcanvas', scrollToTarget);
              });
            }
          } else {
            // For non-hash links, just close the menu (default navigation will happen)
            if (bsOffcanvas) {
              bsOffcanvas.hide();
            }
          }
        });
      });

      // Handle scrolling events to show/hide sticky menu
      window.addEventListener('scroll', function () {
        if (!header) return;

        const headerBottom = header.getBoundingClientRect().bottom;

        // Show sticky nav when scrolled past header
        if (headerBottom <= 0) {
          stickyNav.classList.remove('d-none');
        } else {
          stickyNav.classList.add('d-none');
        }
      });

      // Handle navigation link clicks for smooth scrolling
      navLinks.forEach(link => {
        link.addEventListener('click', function (e) {
          const targetId = this.getAttribute('href');
          if (targetId && targetId.startsWith('#')) {
            e.preventDefault();
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
              // Calculate offset with sticky nav height
              const stickyNavHeight = stickyNav.offsetHeight;
              const targetPosition = targetElement.getBoundingClientRect().top + window.scrollY - stickyNavHeight;

              // Smooth scroll to target position
              window.scrollTo({
                top: targetPosition,
                behavior: 'smooth'
              });

              // Update active state for secondary navigation only
              navLinks.forEach(link => link.classList.remove('active'));
              this.classList.add('active');
            }
          }
        });
      });

      // No need for section-based active link detection now that we've removed section navigation

      // Check authentication status on page load
      checkAuthenticationStatus();

      // Setup logout handlers
      setupLogoutHandlers();

      // Setup signup form handler
      setupSignupFormHandler();

      // Setup login form handler
      setupLoginFormHandler();

      // Setup forgot password handlers
      setupForgotPasswordHandlers();

      // Setup password toggle functionality
      setupPasswordToggle();

      // Setup login modal handlers
      setupLoginModalHandlers();
    });

    // Password Toggle Functionality
    function setupPasswordToggle() {
      const togglePassword = document.getElementById('togglePassword');
      const passwordField = document.getElementById('loginPassword');

      if (togglePassword && passwordField) {
        togglePassword.addEventListener('click', function () {
          const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
          passwordField.setAttribute('type', type);

          // Toggle the eye icon
          const icon = this.querySelector('i');
          if (type === 'password') {
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
          } else {
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
          }
        });
      }
    }

    // Login Modal Animation Handlers
    function setupLoginModalHandlers() {
      const loginModal = document.getElementById('loginModal');
      if (loginModal) {
        loginModal.addEventListener('show.bs.modal', function () {
          document.body.style.overflow = 'hidden';
        });
        loginModal.addEventListener('hidden.bs.modal', function () {
          document.body.style.overflow = '';
        });
      }
    }

    // Login Form Handler
    function setupLoginFormHandler() {
      // Login form submission is handled by membership.js (jQuery delegation)
      // No need for additional event listener here to avoid duplicate API calls

      // Setup login tab switching
      setupLoginTabSwitching();

      // Setup OTP sending functionality
      setupOtpSending();
    }

    // Login Tab Switching Functionality
    function setupLoginTabSwitching() {
      const mobileTab = document.getElementById('mobile-tab');
      const memberTab = document.getElementById('member-tab');
      const mobileLoginPane = document.getElementById('mobile-login');
      const memberLoginPane = document.getElementById('member-login');
      const loginMethodInput = document.getElementById('login_method');

      function switchToMobileLogin() {
        // Update tab appearance
        if (mobileTab) mobileTab.classList.add('active');
        if (memberTab) memberTab.classList.remove('active');

        // Show/hide content
        if (mobileLoginPane) {
          mobileLoginPane.classList.add('show', 'active');
        }
        if (memberLoginPane) {
          memberLoginPane.classList.remove('show', 'active');
        }

        // Update login method
        if (loginMethodInput) loginMethodInput.value = 'mobile';

        // Manage field requirements
        const mobileField = document.getElementById('mobile_number');
        const otpField = document.getElementById('otp');
        const memberField = document.getElementById('membership_number');
        const passwordField = document.getElementById('loginPassword');

        if (mobileField) mobileField.required = true;
        if (otpField) otpField.required = true;
        if (memberField) memberField.required = false;
        if (passwordField) passwordField.required = false;
      }

      function switchToMemberLogin() {
        // Update tab appearance
        if (memberTab) memberTab.classList.add('active');
        if (mobileTab) mobileTab.classList.remove('active');

        // Show/hide content
        if (memberLoginPane) {
          memberLoginPane.classList.add('show', 'active');
        }
        if (mobileLoginPane) {
          mobileLoginPane.classList.remove('show', 'active');
        }

        // Update login method
        if (loginMethodInput) loginMethodInput.value = 'member';

        // Manage field requirements
        const mobileField = document.getElementById('mobile_number');
        const otpField = document.getElementById('otp');
        const memberField = document.getElementById('membership_number');
        const passwordField = document.getElementById('loginPassword');

        if (mobileField) mobileField.required = false;
        if (otpField) otpField.required = false;
        if (memberField) memberField.required = true;
        if (passwordField) passwordField.required = true;
      }

      // Add event listeners for tab switching
      if (mobileTab) {
        mobileTab.addEventListener('click', switchToMobileLogin);
      }

      if (memberTab) {
        memberTab.addEventListener('click', switchToMemberLogin);
      }

      // Initialize with mobile login tab active
      switchToMobileLogin();
    }

    // OTP Sending Functionality
    function setupOtpSending() {
      const sendOtpBtn = document.getElementById('sendOtpBtn');

      if (sendOtpBtn) {
        sendOtpBtn.addEventListener('click', async function () {
          const mobileNumber = document.getElementById('mobile_number').value;

          if (!mobileNumber || mobileNumber.length !== 10) {
            alert('Please enter a valid 10-digit mobile number');
            return;
          }

          // Disable button and show loading state
          this.disabled = true;
          const originalText = this.innerHTML;
          this.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Sending...';

          try {
            const response = await fetch('/membership/send-otp', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
              },
              body: JSON.stringify({
                mobile_number: mobileNumber
              })
            });

            const data = await response.json();

            if (data.success) {
              this.innerHTML = '<i class="fas fa-paper-plane me-1"></i>Resend OTP';
              alert('OTP sent successfully to your mobile number!');

              // Start countdown timer
              let countdown = 30;
              const timer = setInterval(() => {
                if (countdown > 0) {
                  this.innerHTML = `<i class="fas fa-clock me-1"></i>Resend in ${countdown}s`;
                  countdown--;
                } else {
                  clearInterval(timer);
                  this.innerHTML = '<i class="fas fa-paper-plane me-1"></i>Resend OTP';
                  this.disabled = false;
                }
              }, 1000);
            } else {
              throw new Error(data.message || 'Failed to send OTP');
            }
          } catch (error) {
            console.error('OTP Send Error:', error);
            this.disabled = false;
            this.innerHTML = originalText;
            alert('Failed to send OTP: ' + (error.message || 'Please try again later'));
          }
        });
      }
    }

    // Forgot Password Handlers
    function setupForgotPasswordHandlers() {
      // Forgot Password Link Handler
      const forgotPasswordLink = document.getElementById('forgotPasswordLink');
      if (forgotPasswordLink) {
        forgotPasswordLink.addEventListener('click', function (e) {
          e.preventDefault();

          // Close login modal
          const loginModal = bootstrap.Modal.getInstance(document.getElementById('loginModal'));
          if (loginModal) {
            loginModal.hide();
          }

          // Reset forgot password form
          resetForgotPasswordForm();

          // Show forgot password modal
          const forgotPasswordModal = new bootstrap.Modal(document.getElementById('forgotPasswordModal'));
          forgotPasswordModal.show();
        });
      }

      // Send OTP Form Handler
      const sendOtpForm = document.getElementById('sendOtpForm');
      if (sendOtpForm) {
        sendOtpForm.addEventListener('submit', function (e) {
          e.preventDefault();

          const alertBox = document.getElementById('forgotPasswordAlert');
          const emailInput = document.getElementById('resetEmail');
          const submitBtn = document.getElementById('sendResetOtpBtn');
          const btnText = submitBtn.querySelector('.send-otp-text');
          const btnLoading = submitBtn.querySelector('.send-otp-loading');

          // Clear previous alerts
          alertBox.classList.add('d-none');
          emailInput.classList.remove('is-invalid');

          // Show loading state
          submitBtn.disabled = true;
          btnText.classList.add('d-none');
          btnLoading.classList.remove('d-none');

          // Get form data
          const formData = new FormData(sendOtpForm);

          // Submit via AJAX
          fetch('/membership/send-reset-otp', {
            method: 'POST',
            body: formData,
            headers: {
              'X-Requested-With': 'XMLHttpRequest'
            }
          })
            .then(response => response.json())
            .then(data => {
              // Hide loading state
              submitBtn.disabled = false;
              btnText.classList.remove('d-none');
              btnLoading.classList.add('d-none');

              if (data.status === 'success') {
                // Show success message
                alertBox.className = 'alert alert-success mb-4';
                alertBox.textContent = data.message || 'OTP has been sent to your email address.';
                alertBox.classList.remove('d-none');

                // Store email for next step
                document.getElementById('resetPasswordEmail').value = emailInput.value;

                // Hide email step, show reset password step
                document.getElementById('emailStep').classList.add('d-none');
                sendOtpForm.classList.add('d-none');
                document.getElementById('resetPasswordForm').classList.remove('d-none');

                // Update modal title
                document.getElementById('forgotPasswordModalLabel').textContent = 'Reset Password';
                document.querySelector('#forgotPasswordModal .text-gray-600').textContent = 'Enter the OTP code sent to your email/mobile number and your new password';
              } else {
                // Show error message
                alertBox.className = 'alert alert-danger mb-4';

                // Handle nested message object or string
                let errorMessage = 'Failed to send OTP. Please try again.';
                if (data.message) {
                  if (typeof data.message === 'object' && data.message.message) {
                    errorMessage = data.message.message;
                  } else if (typeof data.message === 'string') {
                    errorMessage = data.message;
                  }
                }

                alertBox.textContent = errorMessage;
                alertBox.classList.remove('d-none');

                // Handle field errors
                if (data.errors && data.errors.email) {
                  emailInput.classList.add('is-invalid');
                  const feedback = emailInput.nextElementSibling;
                  if (feedback && feedback.classList.contains('invalid-feedback')) {
                    feedback.textContent = Array.isArray(data.errors.email) ? data.errors.email[0] : data.errors.email;
                  }
                }
              }
            })
            .catch(error => {
              console.error('Send OTP error:', error);

              // Hide loading state
              submitBtn.disabled = false;
              btnText.classList.remove('d-none');
              btnLoading.classList.add('d-none');

              // Show error
              alertBox.className = 'alert alert-danger mb-4';
              alertBox.textContent = 'An error occurred. Please try again later.';
              alertBox.classList.remove('d-none');
            });
        });
      }

      // Reset Password Form Handler
      const resetPasswordForm = document.getElementById('resetPasswordForm');
      if (resetPasswordForm) {
        resetPasswordForm.addEventListener('submit', function (e) {
          e.preventDefault();

          const alertBox = document.getElementById('forgotPasswordAlert');
          const resetKeyInput = document.getElementById('resetKey');
          const newPasswordInput = document.getElementById('newPassword');
          const confirmPasswordInput = document.getElementById('confirmPassword');
          const submitBtn = document.getElementById('resetPasswordBtn');
          const btnText = submitBtn.querySelector('.reset-password-text');
          const btnLoading = submitBtn.querySelector('.reset-password-loading');

          // Clear previous alerts and errors
          alertBox.classList.add('d-none');
          resetPasswordForm.querySelectorAll('.form-control').forEach(field => {
            field.classList.remove('is-invalid');
          });

          // Validate password confirmation
          if (newPasswordInput.value !== confirmPasswordInput.value) {
            confirmPasswordInput.classList.add('is-invalid');
            const feedback = confirmPasswordInput.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Passwords do not match.';
            }
            return;
          }

          // Show loading state
          submitBtn.disabled = true;
          btnText.classList.add('d-none');
          btnLoading.classList.remove('d-none');

          // Get form data
          const formData = new FormData(resetPasswordForm);

          // Submit via AJAX
          fetch('/membership/reset-password', {
            method: 'POST',
            body: formData,
            headers: {
              'X-Requested-With': 'XMLHttpRequest'
            }
          })
            .then(response => response.json())
            .then(data => {
              // Hide loading state
              submitBtn.disabled = false;
              btnText.classList.remove('d-none');
              btnLoading.classList.add('d-none');

              if (data.status === 'success') {
                // Show success message
                alertBox.className = 'alert alert-success mb-4';
                alertBox.textContent = data.message || 'Password reset successfully! You can now login with your new password.';
                alertBox.classList.remove('d-none');

                // Wait 2 seconds then close modal and open login modal
                setTimeout(() => {
                  const forgotPasswordModal = bootstrap.Modal.getInstance(document.getElementById('forgotPasswordModal'));
                  if (forgotPasswordModal) {
                    forgotPasswordModal.hide();
                  }

                  // Reset form
                  resetForgotPasswordForm();

                  // Show success message on login modal
                  const loginModal = new bootstrap.Modal(document.getElementById('loginModal'));
                  loginModal.show();

                  // Show success message in login modal (if you have an alert there)
                  const loginAlert = document.getElementById('loginErrorAlert');
                  if (loginAlert) {
                    loginAlert.className = 'alert alert-success mb-4';
                    const loginErrorMsg = document.getElementById('loginErrorMessage');
                    if (loginErrorMsg) {
                      loginErrorMsg.textContent = 'Password reset successfully! Please login with your new password.';
                    }
                    loginAlert.classList.remove('d-none');

                    // Hide after 5 seconds
                    setTimeout(() => {
                      loginAlert.classList.add('d-none');
                    }, 5000);
                  }
                }, 2000);
              } else {
                // Show error message
                alertBox.className = 'alert alert-danger mb-4';
                
                // Handle different message formats
                let errorMessage = 'Failed to reset password. Please try again.';
                let isHtmlMessage = false;
                
                if (data.message) {
                  if (Array.isArray(data.message)) {
                    // Message is an array of error objects
                    const errorMessages = [];
                    data.message.forEach(error => {
                      if (error.message) {
                        // Remove brackets and quotes if present: "['error']" -> "error"
                        let cleanMessage = error.message.replace(/^\[\'(.+)\'\]$/, '$1');
                        errorMessages.push(cleanMessage);
                      }
                    });
                    
                    if (errorMessages.length > 0) {
                      if (errorMessages.length === 1) {
                        errorMessage = errorMessages[0];
                      } else {
                        // Multiple errors - show as list
                        isHtmlMessage = true;
                        errorMessage = '<i class="fas fa-exclamation-circle me-2"></i><strong>Please fix the following errors:</strong><ul class="mb-0 mt-2 ps-3">' +
                          errorMessages.map(msg => `<li>${msg}</li>`).join('') +
                          '</ul>';
                      }
                    }
                  } else if (typeof data.message === 'string') {
                    // Message is a simple string
                    errorMessage = data.message;
                  }
                }
                
                // Set message content
                if (isHtmlMessage) {
                  alertBox.innerHTML = errorMessage;
                } else {
                  alertBox.textContent = errorMessage;
                }
                
                alertBox.classList.remove('d-none');

                // Handle field errors
                if (data.errors) {
                  if (data.errors.reset_key) {
                    resetKeyInput.classList.add('is-invalid');
                    const feedback = resetKeyInput.nextElementSibling;
                    if (feedback && feedback.classList.contains('invalid-feedback')) {
                      feedback.textContent = Array.isArray(data.errors.reset_key) ? data.errors.reset_key[0] : data.errors.reset_key;
                    }
                  }
                  if (data.errors.new_password) {
                    newPasswordInput.classList.add('is-invalid');
                    const feedback = newPasswordInput.nextElementSibling;
                    if (feedback && feedback.classList.contains('invalid-feedback')) {
                      // Handle array of errors
                      let errorText = '';
                      if (Array.isArray(data.errors.new_password)) {
                        errorText = data.errors.new_password.join(' ');
                      } else {
                        errorText = data.errors.new_password;
                      }
                      feedback.textContent = errorText;
                    }
                  }
                }
              }
            })
            .catch(error => {
              console.error('Reset password error:', error);

              // Hide loading state
              submitBtn.disabled = false;
              btnText.classList.remove('d-none');
              btnLoading.classList.add('d-none');

              // Show error
              alertBox.className = 'alert alert-danger mb-4';
              alertBox.textContent = 'An error occurred. Please try again later.';
              alertBox.classList.remove('d-none');
            });
        });
      }

      // Resend OTP Link Handler
      const resendOtpLink = document.getElementById('resendOtpLink');
      if (resendOtpLink) {
        resendOtpLink.addEventListener('click', function (e) {
          e.preventDefault();

          // Reset to email step
          document.getElementById('emailStep').classList.remove('d-none');
          document.getElementById('sendOtpForm').classList.remove('d-none');
          document.getElementById('resetPasswordForm').classList.add('d-none');
          document.getElementById('forgotPasswordAlert').classList.add('d-none');

          // Update modal title back
          document.getElementById('forgotPasswordModalLabel').textContent = 'Forgot Password';
          document.querySelector('#forgotPasswordModal .text-gray-600').textContent = 'Enter your email address to receive a OTP on your email and associated mobile number to reset password';
        });
      }

      // Helper function to reset forgot password form
      function resetForgotPasswordForm() {
        // Clear all inputs
        document.getElementById('resetEmail').value = '';
        document.getElementById('resetKey').value = '';
        document.getElementById('newPassword').value = '';
        document.getElementById('confirmPassword').value = '';
        document.getElementById('resetPasswordEmail').value = '';

        // Clear all errors
        document.querySelectorAll('#forgotPasswordModal .form-control').forEach(field => {
          field.classList.remove('is-invalid');
        });

        // Hide alert
        document.getElementById('forgotPasswordAlert').classList.add('d-none');

        // Reset to email step
        document.getElementById('emailStep').classList.remove('d-none');
        document.getElementById('sendOtpForm').classList.remove('d-none');
        document.getElementById('resetPasswordForm').classList.add('d-none');

        // Reset modal title
        document.getElementById('forgotPasswordModalLabel').textContent = 'Forgot Password';
        document.querySelector('#forgotPasswordModal .text-gray-600').textContent = 'Enter your email address to receive a OTP on your email and associated mobile number to reset password.';
      }
    }

    // Check authentication status
    async function checkAuthenticationStatus() {
      try {
        const response = await fetch('/membership/check-auth', {
          method: 'GET',
          headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
          }
        });

        const data = await response.json();

        if (data.success) {
          // User is logged in
          showLoggedInState();
        } else {
          // User is not logged in
          showLoggedOutState();
        }
      } catch (error) {
        console.log('Auth check failed:', error);
        showLoggedOutState();
      }
    }

    function showLoggedInState() {
      // Desktop navigation
      document.getElementById('loginNavItem')?.classList.add('d-none');
      document.getElementById('dashboardNavItem')?.classList.remove('d-none');
      document.getElementById('logoutNavItem')?.classList.remove('d-none');
      document.getElementById('joinNowNavItem')?.classList.add('d-none');

      // Mobile navigation
      document.getElementById('mobileLoginBtn')?.classList.add('d-none');
      document.getElementById('mobileDashboardBtn')?.classList.remove('d-none');
      document.getElementById('mobileLogoutBtn')?.classList.remove('d-none');

      // Offcanvas navigation
      document.getElementById('offcanvasLoginBtn')?.classList.add('d-none');
      document.getElementById('offcanvasDashboardBtn')?.classList.remove('d-none');
      document.getElementById('offcanvasLogoutBtn')?.classList.remove('d-none');
      document.getElementById('offcanvasJoinBtn')?.classList.add('d-none');
    }

    function showLoggedOutState() {
      // Desktop navigation
      document.getElementById('loginNavItem')?.classList.remove('d-none');
      document.getElementById('dashboardNavItem')?.classList.add('d-none');
      document.getElementById('logoutNavItem')?.classList.add('d-none');
      document.getElementById('joinNowNavItem')?.classList.remove('d-none');

      // Mobile navigation
      document.getElementById('mobileLoginBtn')?.classList.remove('d-none');
      document.getElementById('mobileDashboardBtn')?.classList.add('d-none');
      document.getElementById('mobileLogoutBtn')?.classList.add('d-none');

      // Offcanvas navigation
      document.getElementById('offcanvasLoginBtn')?.classList.remove('d-none');
      document.getElementById('offcanvasDashboardBtn')?.classList.add('d-none');
      document.getElementById('offcanvasLogoutBtn')?.classList.add('d-none');
      document.getElementById('offcanvasJoinBtn')?.classList.remove('d-none');
    }

    function setupLogoutHandlers() {
      // Desktop logout
      const desktopLogout = document.getElementById('logoutBtn');
      if (desktopLogout) {
        desktopLogout.addEventListener('click', handleLogout);
      }

      // Mobile logout
      const mobileLogout = document.getElementById('mobileLogoutBtn');
      if (mobileLogout) {
        mobileLogout.addEventListener('click', handleLogout);
      }

      // Offcanvas logout
      const offcanvasLogout = document.getElementById('offcanvasLogoutBtn');
      if (offcanvasLogout) {
        offcanvasLogout.addEventListener('click', handleLogout);
      }
    }

    async function handleLogout(event) {
      event.preventDefault();

      try {
        const response = await fetch('/membership/member-logout', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
          }
        });

        const data = await response.json();

        if (data.success) {
          // Update UI to logged out state
          showLoggedOutState();

          // Reload page to show updated state
          window.location.reload();
        } else {
          console.error('Logout failed:', data.message);
          // Still reload even if API failed
          window.location.reload();
        }
      } catch (error) {
        console.error('Logout error:', error);
        // Still reload even if logout failed
        window.location.reload();
      }
    }

    function setupSignupFormHandler() {
      // Email OTP Verification Handlers
      let emailVerified = false;
      const sendEmailOtpBtn = document.getElementById('sendEmailOtpBtn');
      const emailInput = document.getElementById('email');
      const emailOtpField = document.getElementById('emailOtpField');
      const emailOtpInput = document.getElementById('email_otp');
      const signupContinueBtn = document.getElementById('signupContinueBtn');
      const signupForm = document.getElementById('signupForm');
      const mobileInput = document.getElementById('mobile');

      // Function to check if form has any validation errors
      function checkFormValidation() {
        if (!signupContinueBtn) return;

        const hasEmailError = emailInput && emailInput.classList.contains('is-invalid');
        const hasMobileError = mobileInput && mobileInput.classList.contains('is-invalid');
        const isEmailVerified = emailVerified === true;

        // Disable button if there are any errors or email is not verified
        if (hasEmailError || hasMobileError || !isEmailVerified) {
          signupContinueBtn.disabled = true;
          signupContinueBtn.style.opacity = '0.5';
          signupContinueBtn.style.cursor = 'not-allowed';
        } else {
          signupContinueBtn.disabled = false;
          signupContinueBtn.style.opacity = '1';
          signupContinueBtn.style.cursor = 'pointer';
        }
      }

      // Initially disable the continue button
      if (signupContinueBtn) {
        signupContinueBtn.disabled = true;
        signupContinueBtn.style.opacity = '0.5';
        signupContinueBtn.style.cursor = 'not-allowed';
      }

      // Check if email exists in database on blur
      if (emailInput && sendEmailOtpBtn) {
        emailInput.addEventListener('blur', async function() {
          const email = this.value.trim();
          
          // Skip if email is empty or invalid format
          if (!email || !email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
            return;
          }
          
          // Clear previous feedback
          this.classList.remove('is-invalid', 'is-valid');
          const feedback = this.nextElementSibling;
          if (feedback && feedback.classList.contains('invalid-feedback')) {
            feedback.textContent = '';
            feedback.style.display = 'none';
          }
          
          try {
            const response = await fetch('<?php echo e(route('membership.check-email')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({ email: email })
            });
            
            const data = await response.json();
            
            if (data.exists) {
              // Email already exists - show error and disable Send OTP button
              this.classList.add('is-invalid');
              const feedback = this.nextElementSibling;
              if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = data.message || 'This email address is already registered.';
                feedback.style.display = 'block';
              }
              // Disable Send OTP button
              sendEmailOtpBtn.disabled = true;
              sendEmailOtpBtn.style.opacity = '0.5';
              sendEmailOtpBtn.style.cursor = 'not-allowed';
              // Check form validation
              checkFormValidation();
            } else if (data.valid) {
              // Email is available - enable Send OTP button
              this.classList.add('is-valid');
              sendEmailOtpBtn.disabled = false;
              sendEmailOtpBtn.style.opacity = '1';
              sendEmailOtpBtn.style.cursor = 'pointer';
              // Check form validation
              checkFormValidation();
            }
          } catch (error) {
            console.error('Email check error:', error);
            // On error, enable the button to allow user to proceed
            sendEmailOtpBtn.disabled = false;
            sendEmailOtpBtn.style.opacity = '1';
            sendEmailOtpBtn.style.cursor = 'pointer';
          }
        });
        
        // Also clear error when user starts typing
        emailInput.addEventListener('input', function() {
          this.classList.remove('is-invalid', 'is-valid');
          const feedback = this.nextElementSibling;
          if (feedback && feedback.classList.contains('invalid-feedback')) {
            feedback.textContent = '';
            feedback.style.display = 'none';
          }
          // Check form validation
          checkFormValidation();
        });
      }

      // Check if mobile exists in database on blur
      const mobileInput = document.getElementById('mobile');
      if (mobileInput) {
        mobileInput.addEventListener('blur', async function() {
          const mobile = this.value.trim();
          
          // Skip if mobile is empty or not 10 digits
          if (!mobile || mobile.length !== 10 || !/^[0-9]{10}$/.test(mobile)) {
            return;
          }
          
          // Clear previous feedback
          this.classList.remove('is-invalid', 'is-valid');
          const feedback = this.nextElementSibling;
          if (feedback && feedback.classList.contains('invalid-feedback')) {
            feedback.textContent = '';
            feedback.style.display = 'none';
          }
          
          try {
            const response = await fetch('<?php echo e(route('membership.check-mobile')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({ mobile: mobile })
            });
            
            const data = await response.json();
            
            if (data.exists) {
              // Mobile already exists - show error
              this.classList.add('is-invalid');
              const feedback = this.nextElementSibling;
              if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = data.message || 'This mobile number is already registered.';
                feedback.style.display = 'block';
              }
              // Check form validation
              checkFormValidation();
            } else if (data.valid) {
              // Mobile is available - show valid
              this.classList.add('is-valid');
              // Check form validation
              checkFormValidation();
            }
          } catch (error) {
            console.error('Mobile check error:', error);
          }
        });
        
        // Also clear error when user starts typing
        mobileInput.addEventListener('input', function() {
          this.classList.remove('is-invalid', 'is-valid');
          const feedback = this.nextElementSibling;
          if (feedback && feedback.classList.contains('invalid-feedback')) {
            feedback.textContent = '';
            feedback.style.display = 'none';
          }
          // Check form validation
          checkFormValidation();
        });
      }

      // Send Email OTP
      if (sendEmailOtpBtn && emailInput) {
        sendEmailOtpBtn.addEventListener('click', async function(e) {
          e.preventDefault();

          const email = emailInput.value.trim();
          
          // Validate email
          if (!email || !email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
            emailInput.classList.add('is-invalid');
            const feedback = emailInput.nextElementSibling.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Please enter a valid email address';
              feedback.style.display = 'block';
            }
            return;
          }

          emailInput.classList.remove('is-invalid');
          
          const btnText = this.querySelector('.send-otp-text');
          const btnLoading = this.querySelector('.send-otp-loading');
          
          // Show loading
          this.disabled = true;
          btnText.classList.add('d-none');
          btnLoading.classList.remove('d-none');

          try {
            const response = await fetch('<?php echo e(route('membership.send-email-otp')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({ email: email })
            });

            const data = await response.json();

            if (data.success) {
              // Show success message
              const successMsg = document.getElementById('emailOtpSuccess');
              if (successMsg) {
                successMsg.textContent = data.message;
                successMsg.classList.remove('d-none');
              }

              // Show OTP input field
              emailOtpField.classList.remove('d-none');
              
              // Disable email input
              emailInput.setAttribute('readonly', true);
              
              // Change button text to "Resend OTP"
              btnText.textContent = 'RESEND OTP';
              
              // Auto-focus on OTP input
              emailOtpInput.focus();

            } else {
              // Show error
              emailInput.classList.add('is-invalid');
              const feedback = emailInput.nextElementSibling.nextElementSibling;
              if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = data.message || 'Failed to send OTP';
                feedback.style.display = 'block';
              }
            }

          } catch (error) {
            console.error('Send Email OTP Error:', error);
            emailInput.classList.add('is-invalid');
            const feedback = emailInput.nextElementSibling.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Failed to send OTP. Please try again.';
              feedback.style.display = 'block';
            }
          } finally {
            // Reset button
            this.disabled = false;
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');
          }
        });
      }

      // Verify Email OTP on input
      if (emailOtpInput && emailInput) {
        emailOtpInput.addEventListener('input', async function(e) {
          const otp = this.value.trim();
          
          // Only verify when 6 digits are entered
          if (otp.length !== 6) {
            return;
          }

          const email = emailInput.value.trim();
          
          try {
            const response = await fetch('<?php echo e(route('membership.verify-email-otp')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({ 
                email: email,
                otp: otp 
              })
            });

            const data = await response.json();

            if (data.success) {
              // Mark email as verified
              emailVerified = true;
              
              // Show success message
              const verifiedMsg = document.getElementById('emailOtpVerified');
              const errorMsg = document.getElementById('emailOtpError');
              if (verifiedMsg) {
                verifiedMsg.classList.remove('d-none');
              }
              if (errorMsg) {
                errorMsg.classList.add('d-none');
              }
              
              // Remove invalid class and add valid class
              this.classList.remove('is-invalid');
              this.classList.add('is-valid');
              
              // Disable the OTP input field
              this.disabled = true;
              this.setAttribute('readonly', true);
              
              // Enable continue button
              if (signupContinueBtn) {
                emailVerified = true;
                checkFormValidation();
                const infoText = signupContinueBtn.parentElement.querySelector('small');
                if (infoText) {
                  infoText.classList.add('d-none');
                }
              }

            } else {
              // Show error
              emailVerified = false;
              this.classList.add('is-invalid');
              const errorMsg = document.getElementById('emailOtpError');
              if (errorMsg) {
                errorMsg.textContent = data.message || 'Invalid OTP';
                errorMsg.classList.remove('d-none');
              }
              
              // Keep continue button disabled
              if (signupContinueBtn) {
                checkFormValidation();
              }
            }

          } catch (error) {
            console.error('Verify Email OTP Error:', error);
            emailVerified = false;
            this.classList.add('is-invalid');
            const errorMsg = document.getElementById('emailOtpError');
            if (errorMsg) {
              errorMsg.textContent = 'Failed to verify OTP. Please try again.';
              errorMsg.classList.remove('d-none');
            }
            // Keep continue button disabled
            if (signupContinueBtn) {
              checkFormValidation();
            }
          }
        });
      }

      // Signup Form Handler - Step 1: Continue Button (Create Member)

      if (signupContinueBtn && signupForm) {
        signupContinueBtn.addEventListener('click', async function (e) {
          e.preventDefault();

          const errorAlert = document.getElementById('signupErrorAlert');
          const loadingOverlay = document.getElementById('signupLoadingOverlay');
          const btnText = this.querySelector('.signup-continue-text');
          const btnLoading = this.querySelector('.signup-continue-loading');

          // Clear previous errors
          errorAlert.classList.add('d-none');
          signupForm.querySelectorAll('.form-control').forEach(field => {
            field.classList.remove('is-invalid');
            const feedback = field.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = '';
            }
          });

          // Validate Step 1 fields
          const firstName = document.getElementById('first_name').value.trim();
          const lastName = document.getElementById('last_name').value.trim();
          const email = document.getElementById('email').value.trim();
          const mobile = document.getElementById('mobile').value.trim();
          const termsAccepted = document.getElementById('terms_accepted').checked;

          if (!firstName || !lastName || !email || !mobile || !termsAccepted) {
            const errorMsg = document.getElementById('signupErrorMessage');
            errorMsg.textContent = 'Please fill in all required fields.';
            errorAlert.classList.remove('d-none');
            return;
          }

          // Show loading
          loadingOverlay.classList.remove('d-none');
          this.disabled = true;
          btnText.classList.add('d-none');
          btnLoading.classList.remove('d-none');

          try {
            // Step 1: Create member
            const formData = new FormData(signupForm);
            const response = await fetch('<?php echo e(route('membership.register')); ?>', {
              method: 'POST',
              body: formData,
              headers: {
                'X-Requested-With': 'XMLHttpRequest'
              }
            });

            const data = await response.json();

            // Hide loading
            loadingOverlay.classList.add('d-none');
            this.disabled = false;
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');

            if (data.success) {
              // Store member data
              document.getElementById('member_id').value = data.member_id || '';
              document.getElementById('member_email').value = email;

              // Move to Step 2 (OTP was already sent during registration)
              document.getElementById('signupStep1').classList.add('d-none');
              document.getElementById('signupStep2').classList.remove('d-none');
            } else {
              // Show error message
              const errorMsg = document.getElementById('signupErrorMessage');
              let displayMessage = 'Registration failed. Please try again.';
              let errorList = [];

              // Extract field-specific errors
              let fieldErrors = null;
              if (data.message && data.message.user) {
                fieldErrors = data.message.user;
              } else if (data.details && data.details.error && data.details.error.user) {
                fieldErrors = data.details.error.user;
              } else if (data.errors) {
                fieldErrors = data.errors;
              }

              if (fieldErrors) {
                // Collect all error messages
                Object.keys(fieldErrors).forEach(fieldName => {
                  const errors = fieldErrors[fieldName];
                  if (Array.isArray(errors)) {
                    errorList.push(...errors);
                  } else if (typeof errors === 'string') {
                    errorList.push(errors);
                  }

                  // Also mark the field as invalid
                  const field = signupForm.querySelector(`[name="${fieldName}"]`);
                  if (field) {
                    field.classList.add('is-invalid');
                    const feedback = field.nextElementSibling;
                    if (feedback && feedback.classList.contains('invalid-feedback')) {
                      let errorText = '';
                      if (Array.isArray(fieldErrors[fieldName])) {
                        if (typeof fieldErrors[fieldName][0] === 'object' && fieldErrors[fieldName][0].message) {
                          errorText = fieldErrors[fieldName][0].message;
                        } else {
                          errorText = fieldErrors[fieldName][0];
                        }
                      } else {
                        errorText = fieldErrors[fieldName];
                      }
                      feedback.textContent = errorText;
                    }
                  }
                });
              }

              // Display all errors in the alert box
              if (errorList.length > 0) {
                if (errorList.length === 1) {
                  errorMsg.textContent = errorList[0];
                } else {
                  errorMsg.innerHTML = '<strong>Please fix the following errors:</strong><ul class="mb-0 mt-2 ps-3">' +
                    errorList.map(err => `<li>${err}</li>`).join('') +
                    '</ul>';
                }
              } else if (typeof data.message === 'string') {
                errorMsg.textContent = data.message;
              } else {
                errorMsg.textContent = displayMessage;
              }

              errorAlert.classList.remove('d-none');
            }
          } catch (error) {
            console.error('Signup error:', error);
            loadingOverlay.classList.add('d-none');
            this.disabled = false;
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');

            const errorMsg = document.getElementById('signupErrorMessage');
            errorMsg.textContent = error.message || 'An error occurred. Please try again later.';
            errorAlert.classList.remove('d-none');
          }
        });
      }

      // Signup Form Handler - Step 2: Complete Registration (Verify OTP and Set Password)
      if (signupForm) {
        signupForm.addEventListener('submit', async function (e) {
          e.preventDefault();

          const errorAlert = document.getElementById('signupErrorAlert');
          const successAlert = document.getElementById('signupSuccessAlert');
          const loadingOverlay = document.getElementById('signupLoadingOverlay');
          const submitBtn = document.getElementById('signupSubmitBtn');
          const btnText = submitBtn.querySelector('.signup-btn-text');
          const btnLoading = submitBtn.querySelector('.signup-btn-loading');

          // Clear previous errors
          errorAlert.classList.add('d-none');
          successAlert.classList.add('d-none');
          signupForm.querySelectorAll('#signupStep2 .form-control').forEach(field => {
            field.classList.remove('is-invalid');
            const feedback = field.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = '';
            }
          });

          // Validate Step 2 fields
          const otp = document.getElementById('signup_otp').value.trim();
          const password = document.getElementById('signup_password').value;
          const confirmPassword = document.getElementById('signup_confirm_password').value;
          const memberId = document.getElementById('member_id').value;

          if (!otp || !password || !confirmPassword) {
            const errorMsg = document.getElementById('signupErrorMessage');
            errorMsg.textContent = 'Please fill in all required fields.';
            errorAlert.classList.remove('d-none');
            return;
          }

          if (password !== confirmPassword) {
            const confirmField = document.getElementById('signup_confirm_password');
            confirmField.classList.add('is-invalid');
            const feedback = confirmField.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Passwords do not match.';
            }
            return;
          }

          if (password.length < 8) {
            const passwordField = document.getElementById('signup_password');
            passwordField.classList.add('is-invalid');
            const feedback = passwordField.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Password must be at least 8 characters.';
            }
            return;
          }

          // check password is alphanumeric with at least one uppercase letter
          const passwordPattern = /^(?=.*[A-Z])(?=.*\d).+$/;
          if (!passwordPattern.test(password)) {
            const passwordField = document.getElementById('signup_password');
            passwordField.classList.add('is-invalid');
            const feedback = passwordField.nextElementSibling;
            if (feedback && feedback.classList.contains('invalid-feedback')) {
              feedback.textContent = 'Password must contain at least 8 characters with one uppercase alphabet and one numeric character.';
            }
            return;
          }

          // Show loading
          loadingOverlay.classList.remove('d-none');
          submitBtn.disabled = true;
          btnText.classList.add('d-none');
          btnLoading.classList.remove('d-none');

          try {
            // Step 1: Validate Registration OTP
            const otpResponse = await fetch('<?php echo e(route('membership.validate-registration-otp')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({
                member_id: memberId,
                otp: otp
              })
            });

            const otpData = await otpResponse.json();

            if (!otpData.success) {
              // Hide loading
              loadingOverlay.classList.add('d-none');
              submitBtn.disabled = false;
              btnText.classList.remove('d-none');
              btnLoading.classList.add('d-none');

              // Show error
              const errorMsg = document.getElementById('signupErrorMessage');
              errorMsg.textContent = otpData.message || 'Invalid OTP. Please try again.';
              errorAlert.classList.remove('d-none');

              // Highlight OTP field
              const otpField = document.getElementById('signup_otp');
              otpField.classList.add('is-invalid');
              const feedback = otpField.nextElementSibling;
              if (feedback && feedback.classList.contains('invalid-feedback')) {
                feedback.textContent = 'Invalid OTP. Please check and try again.';
              }
              return;
            }

            // Step 2: Set Password using new API
            const passwordResponse = await fetch('<?php echo e(route('membership.set-password-registration')); ?>', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({
                password: password
              })
            });

            const data = await passwordResponse.json();

            // Hide loading
            loadingOverlay.classList.add('d-none');
            submitBtn.disabled = false;
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');

            if (data.success) {
              // Show success message with member ID
              const successMsg = document.getElementById('signupSuccessMessage');
              successMsg.innerHTML = `<strong>Registration Successful!</strong><br>Your Member ID: <strong>${memberId}</strong><br>Redirecting to dashboard...`;
              successAlert.classList.remove('d-none');

              // Reset form
              signupForm.reset();
              document.getElementById('signupStep1').classList.remove('d-none');
              document.getElementById('signupStep2').classList.add('d-none');

              // Redirect to dashboard after 2 seconds
              setTimeout(() => {
                window.location.href = '<?php echo e(route('membership.dashboard')); ?>';
              }, 2000);
            } else {
              // Show error
              const errorMsg = document.getElementById('signupErrorMessage');
              
              // Handle different message formats
              let errorMessage = 'Failed to verify OTP. Please try again.';
              let isHtmlMessage = false;
              
              if (data.message) {
                if (Array.isArray(data.message)) {
                  // Message is an array of error objects
                  const errorMessages = [];
                  data.message.forEach(error => {
                    if (error.message) {
                      // Remove brackets and quotes if present: "['error']" -> "error"
                      let cleanMessage = error.message.replace(/^\[\'(.+)\'\]$/, '$1');
                      errorMessages.push(cleanMessage);
                    }
                  });
                  
                  if (errorMessages.length > 0) {
                    if (errorMessages.length === 1) {
                      errorMessage = errorMessages[0];
                    } else {
                      // Multiple errors - show as list
                      isHtmlMessage = true;
                      errorMessage = '<i class="fas fa-exclamation-circle me-2"></i><strong>Please fix the following errors:</strong><ul class="mb-0 mt-2 ps-3">' +
                        errorMessages.map(msg => `<li>${msg}</li>`).join('') +
                        '</ul>';
                    }
                  }
                } else if (typeof data.message === 'string') {
                  // Message is a simple string
                  errorMessage = data.message;
                }
              }
              
              // Set message content
              if (isHtmlMessage) {
                errorMsg.innerHTML = errorMessage;
              } else {
                errorMsg.textContent = errorMessage;
              }
              
              errorAlert.classList.remove('d-none');

              // Highlight OTP field if invalid
              if (data.message && (typeof data.message === 'string' && data.message.includes('OTP'))) {
                const otpField = document.getElementById('signup_otp');
                otpField.classList.add('is-invalid');
                const feedback = otpField.nextElementSibling;
                if (feedback && feedback.classList.contains('invalid-feedback')) {
                  feedback.textContent = 'Invalid OTP. Please check and try again.';
                }
              }
            }
          } catch (error) {
            console.error('Verification error:', error);
            loadingOverlay.classList.add('d-none');
            submitBtn.disabled = false;
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');

            const errorMsg = document.getElementById('signupErrorMessage');
            errorMsg.textContent = 'An error occurred. Please try again later.';
            errorAlert.classList.remove('d-none');
          }
        });
      }

      // Back button handler
      const signupBackBtn = document.getElementById('signupBackBtn');
      if (signupBackBtn) {
        signupBackBtn.addEventListener('click', function () {
          document.getElementById('signupStep2').classList.add('d-none');
          document.getElementById('signupStep1').classList.remove('d-none');
          document.getElementById('signupErrorAlert').classList.add('d-none');
        });
      }
    }
  </script>

  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

  <!-- Membership Related Script -->
  <script src="<?php echo e(asset('assets/js/membership.js')); ?>"></script>
</body>

</html><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/layouts/pages.blade.php ENDPATH**/ ?>