<!-- Name -->
<div class="mb-3">
    <label for="name" class="form-label">Slide Name <span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name', $slide->name ?? '')); ?>" required>
    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Description -->
<div class="mb-3">
    <label for="description" class="form-label">Description</label>
    <textarea class="form-control" id="description" name="description" rows="3"><?php echo e(old('description', $slide->description ?? '')); ?></textarea>
    <div class="form-text">A short description that will appear with the slide (optional)</div>
    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Image Upload -->
<div class="mb-3">
    <label for="image" class="form-label">
        Slide Image <?php echo e(isset($slide) ? '(leave empty to keep current)' : ''); ?> <span class="text-danger"><?php echo e(!isset($slide) ? '*' : ''); ?></span>
    </label>
    <input type="file" class="form-control" id="image" name="image" accept="image/*" <?php echo e(!isset($slide) ? 'required' : ''); ?>>
    <div class="form-text">Accepted formats: JPEG, PNG, JPG, GIF, WebP. Max size: 2MB. Recommended size: 1920x700px</div>
    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Image Alt Text -->
<div class="mb-3">
    <label for="image_alt" class="form-label">Image Alt Text</label>
    <input type="text" class="form-control" id="image_alt" name="image_alt" value="<?php echo e(old('image_alt', $slide->image_alt ?? '')); ?>">
    <div class="form-text">Describe the image for accessibility (for screen readers)</div>
    <?php $__errorArgs = ['image_alt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Link Section -->
<hr>
<h5 class="mb-3">Link Settings (Optional)</h5>

<!-- Link URL -->
<div class="mb-3">
    <label for="link_url" class="form-label">Link URL</label>
    <input type="url" class="form-control" id="link_url" name="link_url" value="<?php echo e(old('link_url', $slide->link_url ?? '')); ?>">
    <div class="form-text">Optional URL if you want this slide to link somewhere</div>
    <?php $__errorArgs = ['link_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Link Text -->
<div class="mb-3">
    <label for="link_text" class="form-label">Link Text</label>
    <input type="text" class="form-control" id="link_text" name="link_text" value="<?php echo e(old('link_text', $slide->link_text ?? '')); ?>">
    <div class="form-text">Text to display on the button (required if URL is provided)</div>
    <?php $__errorArgs = ['link_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<!-- Open in New Tab -->
<div class="mb-3 form-check">
    <input type="checkbox" class="form-check-input" id="link_new_tab" name="link_new_tab" value="1" 
           <?php echo e(old('link_new_tab', $slide->link_new_tab ?? false) ? 'checked' : ''); ?>>
    <label class="form-check-label" for="link_new_tab">Open link in new tab</label>
    <?php $__errorArgs = ['link_new_tab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger mt-1"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<hr class="my-4">

<div class="row">
    <!-- Status -->
    <div class="col-md-6 mb-3">
        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
        <select class="form-select" id="status" name="status" required>
            <option value="active" <?php echo e(old('status', $slide->status ?? 'active') == 'active' ? 'selected' : ''); ?>>Active</option>
            <option value="inactive" <?php echo e(old('status', $slide->status ?? '') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
        </select>
        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger mt-1"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <!-- Sort Order -->
    <div class="col-md-6 mb-3">
        <label for="sort_order" class="form-label">Sort Order <span class="text-danger">*</span></label>
        <input type="number" class="form-control" id="sort_order" name="sort_order" 
               value="<?php echo e(old('sort_order', $slide->sort_order ?? 0)); ?>" min="0" required>
        <div class="form-text">Lower numbers appear first in the slider</div>
        <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger mt-1"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>
<?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/admin/slides/form.blade.php ENDPATH**/ ?>