<?php $__env->startSection('content'); ?>
<div class="py-12">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900 dark:text-gray-100">                
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1 class="h3 mb-0">Manage Home Page Sections</h1>
                    <div class="btn-group">
                        <form action="<?php echo e(route('admin.manage-home.toggle-status', $manageHome)); ?>" 
                              method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                    class="btn <?php echo e($manageHome->status ? 'btn-success' : 'btn-secondary'); ?>">
                                <i class="fas fa-toggle-<?php echo e($manageHome->status ? 'on' : 'off'); ?>"></i>
                                <?php echo e($manageHome->status ? 'Active' : 'Inactive'); ?>

                            </button>
                        </form>
                        <a href="<?php echo e(route('homestatic')); ?>" class="btn btn-outline-primary" target="_blank">
                            <i class="fas fa-eye"></i> Preview Homepage
                        </a>
                    </div>
                </div>

                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.manage-home.update', $manageHome)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Current Banner Image -->
                            <?php if($manageHome->banner_img): ?>
                            <div class="mb-3">
                                <label class="form-label">Current Banner Image</label>
                                <div>
                                    <img src="<?php echo e(Storage::url($manageHome->banner_img)); ?>" 
                                         alt="Current Banner" 
                                         class="img-thumbnail" 
                                         style="max-width: 200px;">
                                </div>
                            </div>
                            <?php endif; ?>

                            <!-- Banner Image Upload -->
                            <div class="mb-4">
                                <label for="banner_img" class="form-label">
                                    <?php echo e($manageHome->banner_img ? 'Replace Banner Image' : 'Banner Image'); ?>

                                </label>
                                <input type="file" 
                                       class="form-control <?php $__errorArgs = ['banner_img'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="banner_img" 
                                       name="banner_img" 
                                       accept="image/*">
                                <?php $__errorArgs = ['banner_img'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">
                                    Supported formats: JPEG, PNG, JPG, GIF. Max size: 2MB
                                    <?php echo e($manageHome->banner_img ? ' (Leave empty to keep current image)' : ''); ?>

                                </small>
                            </div>                            
                            <!-- Section 1 -->
                            <div class="mb-4">
                                <label for="section_1" class="form-label">Benefits Section Heading</label>
                                <textarea class="form-control <?php $__errorArgs = ['section_1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="section_1" 
                                          name="section_1" 
                                          rows="8" 
                                          placeholder="Enter HTML content for section 1"><?php echo e(old('section_1', $manageHome->section_1['content'] ?? '')); ?></textarea>
                                <?php $__errorArgs = ['section_1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 2 -->
                            <div class="mb-4">
                                <label for="section_2" class="form-label">The LaLiT Rewards Content</label>
                                <textarea class="form-control <?php $__errorArgs = ['section_2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="section_2" 
                                          name="section_2" 
                                          rows="8" 
                                          placeholder="Enter HTML content for The LaLiT Rewards"><?php echo e(old('section_2', $manageHome->section_2['content'] ?? '')); ?></textarea>
                                <?php $__errorArgs = ['section_2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 3 -->
                            <div class="mb-4">
                                <label for="section_3" class="form-label">Membership Tiers Content</label>
                                <textarea class="form-control <?php $__errorArgs = ['section_3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="section_3" 
                                          name="section_3" 
                                          rows="8" 
                                          placeholder="Enter HTML content for Membership Tiers"><?php echo e(old('section_3', $manageHome->section_3['content'] ?? '')); ?></textarea>
                                <?php $__errorArgs = ['section_3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Section 4 -->
                            <div class="mb-4">
                                <label for="section_4" class="form-label">Help & Support Content</label>
                                <textarea class="form-control <?php $__errorArgs = ['section_4'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="section_4" 
                                          name="section_4" 
                                          rows="8" 
                                          placeholder="Enter HTML content for Help & Support"><?php echo e(old('section_4', $manageHome->section_4['content'] ?? '')); ?></textarea>
                                <?php $__errorArgs = ['section_4'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                            </div>                            
                            <!-- Discover The LaLiT Loyalty -->
                            <div class="mb-4">
                                <h5 class="fw-bold mb-3">Discover The LaLiT Loyalty Section</h5>

                                <!-- Current Section 5 Image (if exists) -->
                                <?php if(isset($manageHome->section_5['image']) && $manageHome->section_5['image']): ?>
                                <div class="mb-3">
                                    <label class="form-label">Current Section Image</label>
                                    <div>
                                        <img src="<?php echo e(Storage::url($manageHome->section_5['image'])); ?>" 
                                             alt="Discover The LaLiT Loyalty Image" 
                                             class="img-thumbnail" 
                                             style="max-width: 200px;">
                                    </div>
                                </div>
                                <?php endif; ?>

                                <!-- Section 5 Image Upload -->
                                <div class="mb-3">
                                    <label for="section_5_image" class="form-label">
                                        <?php echo e(isset($manageHome->section_5['image']) ? 'Replace Section Image' : 'Section Image'); ?>

                                    </label>
                                    <input type="file" 
                                           class="form-control <?php $__errorArgs = ['section_5_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="section_5_image" 
                                           name="section_5_image" 
                                           accept="image/*">
                                    <?php $__errorArgs = ['section_5_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">
                                        Supported formats: JPEG, PNG, JPG, GIF. Max size: 2MB
                                        <?php echo e(isset($manageHome->section_5['image']) ? ' (Leave empty to keep current image)' : ''); ?>

                                    </small>
                                </div>

                                <!-- Section 5 Content -->
                                <div class="mb-3">
                                    <label for="section_5" class="form-label">Section Content</label>
                                    <textarea class="form-control <?php $__errorArgs = ['section_5'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="section_5" 
                                              name="section_5" 
                                              rows="8" 
                                              placeholder="Enter HTML content for Discover The LaLiT Loyalty"><?php echo e(old('section_5', $manageHome->section_5['content'] ?? '')); ?></textarea>
                                    <?php $__errorArgs = ['section_5'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">You can use HTML tags for formatting.</small>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           value="1" 
                                           id="status" 
                                           name="status" 
                                           <?php echo e(old('status', $manageHome->status) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="status">
                                        Active Status
                                    </label>
                                </div>
                            </div>                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Home Sections
                                </button>
                                <button type="reset" class="btn btn-secondary">
                                    <i class="fas fa-undo"></i> Reset Changes
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/admin/manage-home/edit.blade.php ENDPATH**/ ?>