

<?php $__env->startSection('title', 'Participating Hotels'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">Participating Hotels</h5>
                            <p class="text-sm mb-0">
                                Manage participating hotels for the loyalty program.
                            </p>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                                <a href="<?php echo e(route('admin.participating-hotels.create')); ?>" class="btn bg-gradient-primary btn-sm mb-0">
                                    <i class="fas fa-plus me-1"></i> Add New Hotel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body px-0 pb-0">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success mx-4">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($hotels->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-flush" id="hotels-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Hotel</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Description</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Sort Order</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Status</th>
                                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder text-center opacity-7 ps-2">Created</th>
                                        <th class="text-secondary opacity-7"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex px-2 py-1">
                                                    <div>
                                                        <?php if($hotel->image): ?>
                                                            <img src="<?php echo e(Storage::url($hotel->image)); ?>" class="hotel-thumb me-3 border-radius-lg" alt="<?php echo e($hotel->title); ?>">
                                                        <?php else: ?>
                                                            <div class="hotel-thumb me-3 border-radius-lg bg-gradient-secondary d-flex align-items-center justify-content-center">
                                                                <i class="fas fa-building text-white"></i>
                                                            </div>
                                                        <?php endif; ?>  
                                                    </div>
                                                    <div class="d-flex flex-column justify-content-center">
                                                        <h6 class="mb-0 text-sm"><?php echo e($hotel->title); ?></h6>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="align-middle text-center text-sm">
                                                <p class="text-xs text-secondary mb-0">
                                                    <?php echo e(Str::limit($hotel->description, 60)); ?>

                                                </p>
                                            </td>
                                            <td class="align-middle text-center">
                                                <span class="text-secondary text-xs font-weight-bold"><?php echo e($hotel->sort_order); ?></span>
                                            </td>
                                            <td class="align-middle text-center text-sm">
                                                <?php if($hotel->is_active): ?>
                                                    <span class="badge badge-sm bg-gradient-success">Active</span>
                                                <?php else: ?>
                                                    <span class="badge badge-sm bg-gradient-secondary">Inactive</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="align-middle text-center">
                                                <span class="text-secondary text-xs font-weight-bold"><?php echo e($hotel->created_at->format('M d, Y')); ?></span>
                                            </td>
                                            <td class="align-middle">
                                                <div class="dropdown">
                                                    <a href="#" class="btn btn-link text-secondary mb-0" data-bs-toggle="dropdown">
                                                        <i class="fa fa-ellipsis-v text-xs"></i>
                                                    </a>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a class="dropdown-item" href="<?php echo e(route('admin.participating-hotels.show', $hotel)); ?>">
                                                            <i class="fas fa-eye me-2"></i> View
                                                        </a>
                                                        <a class="dropdown-item" href="<?php echo e(route('admin.participating-hotels.edit', $hotel)); ?>">
                                                            <i class="fas fa-edit me-2"></i> Edit
                                                        </a>
                                                        <div class="dropdown-divider"></div>
                                                        <form action="<?php echo e(route('admin.participating-hotels.destroy', $hotel)); ?>" method="POST" 
                                                              onsubmit="return confirm('Are you sure you want to delete this hotel?')">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="dropdown-item text-danger">
                                                                <i class="fas fa-trash me-2"></i> Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <div class="mb-3">
                                <i class="fas fa-building fa-3x text-muted"></i>
                            </div>
                            <h5 class="text-muted">No Participating Hotels Found</h5>
                            <p class="text-muted">Start by adding your first participating hotel to the loyalty program.</p>
                            <a href="<?php echo e(route('admin.participating-hotels.create')); ?>" class="btn bg-gradient-primary">
                                <i class="fas fa-plus me-1"></i> Add First Hotel
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.hotel-thumb {
    width: 40px;
    height: 40px;
    object-fit: cover;
    border-radius: 8px;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tlshs/public_html/thelalitloyalty.com/resources/views/admin/participating-hotels/index.blade.php ENDPATH**/ ?>